/*
 * Decompiled with CFR 0.152.
 */
package ca.canucksoftware;

import ca.canucksoftware.NovacomConnection;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import javax.swing.JOptionPane;
import org.json.JSONObject;

public class AppInfoEntry {
    public String id = "<unkown>";
    public String name = "<unkown>";
    public String size = "<unkown>";
    public String developer = "<unkown>";
    public String version = "<unkown>";
    public String file = "<unkown>";
    public String installTime = "<unkown>";
    public String status = "<unkown>";
    public JSONObject source = new JSONObject();
    public final String UNKNOWN = "<unkown>";
    private NovacomConnection novaCon;
    public boolean controlParsed = false;

    public AppInfoEntry(NovacomConnection nc) {
        this.novaCon = nc;
    }

    public void parseControl() {
        BufferedReader input;
        String tmpFilePath = System.getProperty("java.io.tmpdir");
        File f = new File(tmpFilePath, "currAppControl");
        this.novaCon.receiveFile(this.novaCon.offlineRoot + "/usr/lib/ipkg/info/" + this.id + ".control", f, false);
        try {
            input = new BufferedReader(new FileReader(f));
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "Error finding package list");
            input = null;
        }
        if (input != null) {
            try {
                String line = input.readLine();
                while (line != null) {
                    String[] elements = (line = line.trim()).split(" ");
                    if (elements.length > 1) {
                        if (elements[0].startsWith("Package")) {
                            this.id = elements[1];
                        } else if (elements[0].startsWith("Description")) {
                            this.name = line.substring(line.indexOf(":") + 2);
                        } else if (elements[0].startsWith("Version")) {
                            this.version = elements[1];
                        } else if (elements[0].startsWith("Maintainer")) {
                            this.developer = line.substring(line.indexOf(":") + 2);
                        } else if (elements[0].startsWith("Source")) {
                            this.source = new JSONObject(line.substring(line.indexOf(":") + 2));
                        }
                    }
                    line = input.readLine();
                }
            }
            catch (Exception e) {
                this.source = new JSONObject();
            }
        }
        if (input != null) {
            try {
                input.close();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        this.controlParsed = true;
    }

    public boolean isNewerVersion(AppInfoEntry otherApp) {
        boolean newer = false;
        String[] parts1 = this.version.replace('.', '-').split("-");
        String[] parts2 = otherApp.version.replace('.', '-').split("-");
        for (int i = 0; i < parts1.length; ++i) {
            if (i >= parts2.length) {
                if (Integer.parseInt(parts1[i]) != 0) {
                    newer = true;
                    break;
                }
                newer = false;
                break;
            }
            if (Integer.parseInt(parts1[i]) > Integer.parseInt(parts2[i])) {
                newer = true;
                break;
            }
            if (Integer.parseInt(parts1[i]) >= Integer.parseInt(parts2[i])) continue;
            newer = false;
            break;
        }
        return newer;
    }

    public String toString() {
        return "Name: " + this.name + "\nID: " + this.id + "\nVersion: " + this.version + "\nSize: " + this.size + "B\nDeveloper: " + this.developer + "\nFilename: " + this.file + "\nInstallTime: " + this.installTime;
    }
}

