/*
 * Decompiled with CFR 0.152.
 */
package ca.canucksoftware;

import ca.canucksoftware.AppInfoEntry;
import ca.canucksoftware.InstalledAppInfoBox;
import ca.canucksoftware.NovacomConnection;
import ca.canucksoftware.PackageFeed;
import ca.canucksoftware.PatchInfoBox;
import ca.canucksoftware.WebOSQuickInstallApp;
import com.palm.nova.installer.core.DeviceInfo;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.prefs.Preferences;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import org.jdesktop.application.Action;
import org.jdesktop.application.Application;
import org.jdesktop.application.ApplicationActionMap;
import org.jdesktop.application.ResourceMap;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeviceManagement
extends JDialog {
    public boolean dontOpen;
    private InstalledAppInfoBox appInfoBox;
    private PatchInfoBox patchInfoBox;
    private NovacomConnection novaCon;
    private PackageFeed userApps;
    private DeviceInfo di;
    private boolean useEmulator;
    private ResourceMap rmap;
    private DefaultTableModel modTable;
    private Timer t;
    private boolean appsListLoaded;
    private int listLoadTries;
    private List<String> patches;
    private List<AppInfoEntry> currList;
    private int currType;
    private boolean firstRun;
    private JButton closeButton;
    private JButton jButton1;
    private JComboBox jComboBox1;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JLayeredPane jLayeredPane1;
    private JLayeredPane jLayeredPane2;
    private JLayeredPane jLayeredPane3;
    private JScrollPane jScrollPane1;
    private JTable jTable1;

    public DeviceManagement(Frame parent, ResourceMap rm) {
        super(parent);
        this.initComponents();
        this.rmap = rm;
        this.appsListLoaded = false;
        this.firstRun = true;
        this.getRootPane().setDefaultButton(this.closeButton);
        this.dontOpen = false;
        this.useEmulator = Preferences.userRoot().getBoolean("useEmulator", false);
        this.jTable1.setAutoCreateColumnsFromModel(false);
        this.modTable = (DefaultTableModel)this.jTable1.getModel();
        this.modTable.addRow(new Object[]{"Loading list...", Boolean.FALSE});
        this.getContentPane().requestFocus();
        this.novaCon = new NovacomConnection();
        this.t = new Timer();
        this.currList = new ArrayList<AppInfoEntry>();
        this.currType = 0;
        this.userApps = null;
        this.listLoadTries = 0;
        if (this.novaCon.connect(true)) {
            this.loadData();
        } else if (JOptionPane.showConfirmDialog(parent, "Please connect your device then hit \"OK\"", "No Device Detected", 2, 2) == 0) {
            if (this.novaCon.connect(true)) {
                this.loadData();
            } else {
                JOptionPane.showMessageDialog(parent, "ERROR: No device detected.", "ERROR", 0);
                this.dontOpen = true;
            }
        } else {
            this.dontOpen = true;
        }
    }

    private void loadData() {
        this.loadDeviceDetails();
        this.t.schedule((TimerTask)new DoLoad(), 50L);
    }

    private void loadPatchData() {
        this.patches = this.loadPatchPackages();
    }

    private void loadDeviceDetails() {
        if (this.useEmulator) {
            this.jLabel2.setText(this.jLabel2.getText() + "    Emulator");
            this.jLabel1.setText(this.jLabel1.getText() + "    N/A");
            this.jLabel5.setText(this.jLabel5.getText() + "    N/A");
            this.jLabel10.setText(this.jLabel10.getText() + "    N/A");
            this.jLabel4.setText(this.jLabel4.getText() + "    N/A");
            this.jLabel6.setText(this.jLabel6.getText() + "    N/A");
            this.jLabel3.setText(this.jLabel3.getText() + "    N/A");
            this.jLabel9.setText(this.jLabel9.getText() + "    N/A");
            this.jLabel8.setText(this.jLabel8.getText() + "    N/A");
            ImageIcon device = new ImageIcon(this.rmap.getImageIcon("emulator").getImage());
            this.jLabel7.setIcon(device);
        } else {
            try {
                this.di = this.novaCon.getDeviceInfo();
                if (this.di != null) {
                    ImageIcon device;
                    if (this.di.getBuildName().toLowerCase().contains("castle")) {
                        this.jLabel2.setText(this.jLabel2.getText() + "    Palm Pre");
                        device = new ImageIcon(this.rmap.getImageIcon("pre").getImage());
                    } else if (this.di.getBuildName().toLowerCase().contains("pixie")) {
                        this.jLabel2.setText(this.jLabel2.getText() + "    Palm Pixi");
                        device = new ImageIcon(this.rmap.getImageIcon("pixi").getImage());
                    } else {
                        this.jLabel2.setText(this.jLabel2.getText() + "    <unknown:" + this.di.getBuildName() + ">");
                        device = new ImageIcon(this.rmap.getImageIcon("pre").getImage());
                    }
                    this.jLabel1.setText(this.jLabel1.getText() + "    " + this.di.getBatteryPercentage() + "%");
                    this.jLabel5.setText(this.jLabel5.getText() + "    " + this.capitalize(this.di.getCarrierName()));
                    this.jLabel10.setText(this.jLabel10.getText() + "    " + this.di.getProductVersion());
                    this.jLabel4.setText(this.jLabel4.getText() + "    " + this.di.getBuildVersion());
                    this.jLabel6.setText(this.jLabel6.getText() + "    " + this.capitalize(this.di.getCustomizationVariant()) + " " + this.di.getCustomizationVersion());
                    this.jLabel3.setText(this.jLabel3.getText() + "    " + this.di.getModemType());
                    this.jLabel9.setText(this.jLabel9.getText() + "    " + this.di.getModemFwVersion());
                    this.jLabel8.setText(this.jLabel8.getText() + "    " + this.di.getTouchPanelFwVersion());
                    this.jLabel7.setIcon(device);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private String capitalize(String text) {
        String result = "";
        String[] words = text.split(" ");
        for (int i = 0; i < words.length - 1; ++i) {
            if (words[i].length() > 0) {
                result = result + words[i].substring(0, 1).toUpperCase() + words[i].substring(1);
            }
            result = result + " ";
        }
        result = words[words.length - 1].length() > 0 ? result + words[words.length - 1].substring(0, 1).toUpperCase() + words[words.length - 1].substring(1) : result + " ";
        return result;
    }

    private void loadAppTable() {
        if (this.userApps == null) {
            this.userApps = this.novaCon.getAppsFeed(this.novaCon.offlineRoot + "/usr/lib/ipkg/status");
            if (this.userApps != null) {
                this.userApps.sort(true);
                this.loadPatchData();
            }
        }
        if (this.modTable.getRowCount() == 1) {
            this.modTable.removeRow(0);
        }
        if (this.userApps != null) {
            int i;
            this.appsListLoaded = true;
            for (i = 0; i < this.userApps.apps.size(); ++i) {
                JSONObject json;
                if (!this.userApps.apps.get((int)i).name.startsWith("This is a webOS application") || (json = this.novaCon.readJSONFile(this.novaCon.offlineRoot + "/usr/palm/applications/" + this.userApps.apps.get((int)i).id + "/appinfo.json")) == null) continue;
                try {
                    this.userApps.apps.get((int)i).name = json.getString("title");
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.userApps.sort(true);
            for (i = 0; i < this.userApps.apps.size(); ++i) {
                if (this.currType == 0) {
                    if (this.patches.contains(this.userApps.apps.get((int)i).id)) continue;
                    this.modTable.addRow(new Object[]{this.userApps.apps.get((int)i).name, Boolean.FALSE});
                    this.currList.add(this.userApps.apps.get(i));
                    continue;
                }
                if (this.currType != 1 || !this.patches.contains(this.userApps.apps.get((int)i).id)) continue;
                this.modTable.addRow(new Object[]{this.userApps.apps.get((int)i).name, Boolean.FALSE});
                this.currList.add(this.userApps.apps.get(i));
            }
        }
    }

    @Action
    public void uninstall() {
        if (this.jTable1.getRowCount() > 0) {
            this.t.schedule((TimerTask)new DoDeleteApps(), 50L);
        }
    }

    private void uninstallApps() {
        this.jButton1.setText("Please wait...");
        this.jButton1.setEnabled(false);
        this.closeButton.setEnabled(false);
        this.setDefaultCloseOperation(0);
        for (int i = 0; i < this.modTable.getRowCount(); ++i) {
            Boolean b = (Boolean)this.modTable.getValueAt(i, 1);
            if (b != Boolean.TRUE) continue;
            if (this.currType == 1) {
                this.novaCon.restartLuna = true;
            }
            String id = this.currList.get((int)i).id;
            if (this.novaCon.fileExists(this.novaCon.offlineRoot + "/usr/lib/ipkg/info/" + this.userApps.apps.get((int)i).id + ".prerm")) {
                this.currList.get(i).parseControl();
                try {
                    if (this.currList.get((int)i).source.has("PostInstallFlags")) {
                        this.novaCon.restartLuna |= this.userApps.apps.get((int)i).source.getString("PostRemoveFlags").equalsIgnoreCase("RestartLuna");
                        this.novaCon.restartJava |= this.userApps.apps.get((int)i).source.getString("PostRemoveFlags").equalsIgnoreCase("RestartJava");
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (!this.novaCon.uninstall(id)) continue;
            this.currList.remove(i);
            this.modTable.removeRow(i);
            --i;
        }
        this.novaCon.finishIpkgAction();
        this.jButton1.setText("Uninstall");
        this.jButton1.setEnabled(true);
        this.closeButton.setEnabled(true);
        this.setDefaultCloseOperation(2);
    }

    @Action
    public void closeManagement() {
        this.dispose();
    }

    private void launchInfo(int index) {
        if (index > -1) {
            JFrame mainFrame = WebOSQuickInstallApp.getApplication().getMainFrame();
            if (this.currType == 0) {
                this.appInfoBox = new InstalledAppInfoBox((Frame)mainFrame, this.currList.get(index));
                this.appInfoBox.setLocationRelativeTo(mainFrame);
                WebOSQuickInstallApp.getApplication().show(this.appInfoBox);
            } else if (this.currType == 1) {
                this.patchInfoBox = new PatchInfoBox((Frame)mainFrame, this.currList.get(index));
                this.patchInfoBox.setLocationRelativeTo(mainFrame);
                WebOSQuickInstallApp.getApplication().show(this.patchInfoBox);
            }
        }
    }

    private List<String> loadPatchPackages() {
        List<String> packages = this.novaCon.listInstalled();
        for (int i = 0; i < packages.size(); ++i) {
            if (packages.get(i).startsWith("ca.canucksoftware.patches.") || packages.get(i).startsWith("org.webosinternals.patches.")) continue;
            packages.remove(i);
            --i;
        }
        return packages;
    }

    private void initComponents() {
        this.jLayeredPane1 = new JLayeredPane();
        this.closeButton = new JButton();
        this.jLayeredPane3 = new JLayeredPane();
        this.jButton1 = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.jTable1 = new JTable();
        this.jComboBox1 = new JComboBox();
        this.jLayeredPane2 = new JLayeredPane();
        this.jLabel1 = new JLabel();
        this.jLabel10 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel8 = new JLabel();
        this.jLabel9 = new JLabel();
        this.jLabel5 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jLabel6 = new JLabel();
        this.jLabel7 = new JLabel();
        this.setDefaultCloseOperation(2);
        ResourceMap resourceMap = Application.getInstance(WebOSQuickInstallApp.class).getContext().getResourceMap(DeviceManagement.class);
        this.setTitle(resourceMap.getString("title", new Object[0]));
        this.setModal(true);
        this.setName("aboutBox");
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                DeviceManagement.this.formWindowClosing(evt);
            }
        });
        this.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent evt) {
                DeviceManagement.this.formKeyPressed(evt);
            }
        });
        this.jLayeredPane1.setName("jLayeredPane1");
        this.jLayeredPane1.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                DeviceManagement.this.jLayeredPane1MouseClicked(evt);
            }
        });
        this.jLayeredPane1.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent evt) {
                DeviceManagement.this.jLayeredPane1KeyTyped(evt);
            }
        });
        ApplicationActionMap actionMap = Application.getInstance(WebOSQuickInstallApp.class).getContext().getActionMap(DeviceManagement.class, this);
        this.closeButton.setAction(actionMap.get("closeManagement"));
        this.closeButton.setText(resourceMap.getString("closeButton.text", new Object[0]));
        this.closeButton.setName("closeButton");
        this.closeButton.setBounds(280, 350, 77, 25);
        this.jLayeredPane1.add((Component)this.closeButton, JLayeredPane.DEFAULT_LAYER);
        this.jLayeredPane3.setBorder(BorderFactory.createTitledBorder(null, resourceMap.getString("jLayeredPane3.border.title", new Object[0]), 0, 0, resourceMap.getFont("jLayeredPane3.border.titleFont")));
        this.jLayeredPane3.setName("jLayeredPane3");
        this.jLayeredPane3.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                DeviceManagement.this.jLayeredPane3MouseClicked(evt);
            }
        });
        this.jButton1.setAction(actionMap.get("uninstall"));
        this.jButton1.setText(resourceMap.getString("jButton1.text", new Object[0]));
        this.jButton1.setName("jButton1");
        this.jButton1.setBounds(150, 290, 110, 25);
        this.jLayeredPane3.add((Component)this.jButton1, JLayeredPane.DEFAULT_LAYER);
        this.jScrollPane1.setName("jScrollPane1");
        this.jTable1.setModel(new DefaultTableModel(new Object[0][], new String[]{"Name", ""}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{String.class, Boolean.class};
                this.canEdit = new boolean[]{false, true};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.jTable1.setFillsViewportHeight(true);
        this.jTable1.setFocusable(false);
        this.jTable1.setGridColor(resourceMap.getColor("jTable1.gridColor"));
        this.jTable1.setName("jTable1");
        this.jTable1.setSelectionMode(0);
        this.jTable1.setShowVerticalLines(false);
        this.jTable1.getTableHeader().setResizingAllowed(false);
        this.jTable1.getTableHeader().setReorderingAllowed(false);
        this.jTable1.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                DeviceManagement.this.jTable1MouseClicked(evt);
            }

            public void mousePressed(MouseEvent evt) {
                DeviceManagement.this.jTable1MousePressed(evt);
            }

            public void mouseReleased(MouseEvent evt) {
                DeviceManagement.this.jTable1MouseReleased(evt);
            }
        });
        this.jTable1.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent evt) {
                DeviceManagement.this.jTable1KeyTyped(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jTable1);
        this.jTable1.getColumnModel().getColumn(0).setPreferredWidth(250);
        this.jTable1.getColumnModel().getColumn(0).setHeaderValue(resourceMap.getString("jTable1.columnModel.title0", new Object[0]));
        this.jTable1.getColumnModel().getColumn(1).setPreferredWidth(50);
        this.jTable1.getColumnModel().getColumn(1).setHeaderValue(resourceMap.getString("jTable1.columnModel.title1", new Object[0]));
        this.jScrollPane1.setBounds(20, 50, 240, 230);
        this.jLayeredPane3.add((Component)this.jScrollPane1, JLayeredPane.DEFAULT_LAYER);
        this.jComboBox1.setModel(new DefaultComboBoxModel<String>(new String[]{"Applications", "Patches"}));
        this.jComboBox1.setName("jComboBox1");
        this.jComboBox1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DeviceManagement.this.jComboBox1ActionPerformed(evt);
            }
        });
        this.jComboBox1.setBounds(154, 20, 100, 22);
        this.jLayeredPane3.add((Component)this.jComboBox1, JLayeredPane.DEFAULT_LAYER);
        this.jLayeredPane3.setBounds(320, 10, 280, 330);
        this.jLayeredPane1.add((Component)this.jLayeredPane3, JLayeredPane.DEFAULT_LAYER);
        this.jLayeredPane2.setBorder(BorderFactory.createTitledBorder(null, resourceMap.getString("jLayeredPane2.border.title", new Object[0]), 0, 0, resourceMap.getFont("jLayeredPane2.border.titleFont")));
        this.jLayeredPane2.setName("jLayeredPane2");
        this.jLayeredPane2.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                DeviceManagement.this.jLayeredPane2MouseClicked(evt);
            }
        });
        this.jLabel1.setText(resourceMap.getString("jLabel1.text", new Object[0]));
        this.jLabel1.setName("jLabel1");
        this.jLabel1.setBounds(20, 60, 170, 16);
        this.jLayeredPane2.add((Component)this.jLabel1, JLayeredPane.DEFAULT_LAYER);
        this.jLabel10.setText(resourceMap.getString("jLabel10.text", new Object[0]));
        this.jLabel10.setName("jLabel10");
        this.jLabel10.setBounds(20, 120, 250, 16);
        this.jLayeredPane2.add((Component)this.jLabel10, JLayeredPane.DEFAULT_LAYER);
        this.jLabel3.setText(resourceMap.getString("jLabel3.text", new Object[0]));
        this.jLabel3.setName("jLabel3");
        this.jLabel3.setBounds(20, 210, 250, 16);
        this.jLayeredPane2.add((Component)this.jLabel3, JLayeredPane.DEFAULT_LAYER);
        this.jLabel2.setText(resourceMap.getString("jLabel2.text", new Object[0]));
        this.jLabel2.setName("jLabel2");
        this.jLabel2.setBounds(20, 30, 170, 16);
        this.jLayeredPane2.add((Component)this.jLabel2, JLayeredPane.DEFAULT_LAYER);
        this.jLabel8.setText(resourceMap.getString("jLabel8.text", new Object[0]));
        this.jLabel8.setName("jLabel8");
        this.jLabel8.setBounds(20, 270, 250, 16);
        this.jLayeredPane2.add((Component)this.jLabel8, JLayeredPane.DEFAULT_LAYER);
        this.jLabel9.setText(resourceMap.getString("jLabel9.text", new Object[0]));
        this.jLabel9.setName("jLabel9");
        this.jLabel9.setBounds(20, 240, 250, 16);
        this.jLayeredPane2.add((Component)this.jLabel9, JLayeredPane.DEFAULT_LAYER);
        this.jLabel5.setText(resourceMap.getString("jLabel5.text", new Object[0]));
        this.jLabel5.setName("jLabel5");
        this.jLabel5.setBounds(20, 90, 170, 16);
        this.jLayeredPane2.add((Component)this.jLabel5, JLayeredPane.DEFAULT_LAYER);
        this.jLabel4.setText(resourceMap.getString("jLabel4.text", new Object[0]));
        this.jLabel4.setName("jLabel4");
        this.jLabel4.setBounds(20, 150, 250, 16);
        this.jLayeredPane2.add((Component)this.jLabel4, JLayeredPane.DEFAULT_LAYER);
        this.jLabel6.setText(resourceMap.getString("jLabel6.text", new Object[0]));
        this.jLabel6.setName("jLabel6");
        this.jLabel6.setBounds(20, 180, 250, 16);
        this.jLayeredPane2.add((Component)this.jLabel6, JLayeredPane.DEFAULT_LAYER);
        this.jLabel7.setText(resourceMap.getString("jLabel7.text", new Object[0]));
        this.jLabel7.setVerticalAlignment(1);
        this.jLabel7.setName("jLabel7");
        this.jLabel7.setBounds(190, 20, 70, 70);
        this.jLayeredPane2.add((Component)this.jLabel7, JLayeredPane.DEFAULT_LAYER);
        this.jLayeredPane2.setBounds(20, 10, 280, 330);
        this.jLayeredPane1.add((Component)this.jLayeredPane2, JLayeredPane.DEFAULT_LAYER);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLayeredPane1, -1, 621, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLayeredPane1, -1, 386, Short.MAX_VALUE));
        this.pack();
    }

    private void formKeyPressed(KeyEvent evt) {
    }

    private void jTable1MouseClicked(MouseEvent evt) {
    }

    private void jTable1KeyTyped(KeyEvent evt) {
    }

    private void jLayeredPane1KeyTyped(KeyEvent evt) {
    }

    private void jLayeredPane2MouseClicked(MouseEvent evt) {
    }

    private void jLayeredPane3MouseClicked(MouseEvent evt) {
    }

    private void jLayeredPane1MouseClicked(MouseEvent evt) {
    }

    private void jTable1MousePressed(MouseEvent evt) {
        int i = this.jTable1.rowAtPoint(evt.getPoint());
        if (i > -1 && this.jTable1.columnAtPoint(evt.getPoint()) == 0) {
            this.launchInfo(i);
        }
        this.jTable1.removeRowSelectionInterval(this.jTable1.getSelectedRow(), this.jTable1.getSelectedRow());
    }

    private void jTable1MouseReleased(MouseEvent evt) {
        this.jTable1.removeRowSelectionInterval(this.jTable1.getSelectedRow(), this.jTable1.getSelectedRow());
    }

    private void formWindowClosing(WindowEvent evt) {
        this.t.cancel();
        this.novaCon.close();
    }

    private void jComboBox1ActionPerformed(ActionEvent evt) {
        this.currType = this.jComboBox1.getSelectedIndex();
        this.firstRun = true;
        this.t.schedule((TimerTask)new DoListApps(), 50L);
    }

    class DoBatteryUpdate
    extends TimerTask {
        DoBatteryUpdate() {
        }

        public void run() {
            try {
                DeviceManagement.this.di = DeviceManagement.this.novaCon.getDeviceInfo();
                DeviceManagement.this.jLabel1.setText("Battery:    " + DeviceManagement.this.di.getBatteryPercentage() + "%");
                DeviceManagement.this.t.schedule((TimerTask)new DoBatteryUpdate(), 60000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    class DoDeleteApps
    extends TimerTask {
        DoDeleteApps() {
        }

        public void run() {
            DeviceManagement.this.uninstallApps();
        }
    }

    class DoListApps
    extends TimerTask {
        DoListApps() {
        }

        public void run() {
            if (DeviceManagement.this.firstRun) {
                DeviceManagement.this.currList.clear();
                while (DeviceManagement.this.modTable.getRowCount() > 0) {
                    DeviceManagement.this.modTable.removeRow(0);
                }
                DeviceManagement.this.modTable.addRow(new Object[]{"Loading...", Boolean.FALSE});
            }
            DeviceManagement.this.firstRun = false;
            DeviceManagement.this.loadAppTable();
            DeviceManagement.this.listLoadTries++;
            if (!DeviceManagement.this.appsListLoaded && DeviceManagement.this.listLoadTries < 15) {
                DeviceManagement.this.t.schedule((TimerTask)new DoListApps(), 150L);
            }
            if (!DeviceManagement.this.useEmulator) {
                DeviceManagement.this.t.schedule((TimerTask)new DoBatteryUpdate(), 60000L);
            }
        }
    }

    class DoLoad
    extends TimerTask {
        DoLoad() {
        }

        public void run() {
            DeviceManagement.this.novaCon.getWebOSVersion();
            DeviceManagement.this.t.schedule((TimerTask)new DoListApps(), 50L);
        }
    }
}

