/*
 * Decompiled with CFR 0.152.
 */
package ca.canucksoftware;

import ca.canucksoftware.JarFileLoader;
import java.io.File;
import java.net.URL;
import java.util.prefs.Preferences;
import javax.swing.JOptionPane;

public class DoctorJarLoader
extends JarFileLoader {
    private String path = Preferences.userRoot().get("webOSDoctor", null);

    public DoctorJarLoader() {
        super(new URL[0]);
    }

    public boolean lookForDoctor() {
        boolean result = false;
        if (this.path == null) {
            result = true;
        } else if (!new File(this.path).exists()) {
            result = true;
        }
        return result;
    }

    public void setDoctor(File file) {
        try {
            this.path = file.getCanonicalPath();
        }
        catch (Exception e) {
            this.path = file.getPath();
        }
    }

    public void loadDoctor() {
        try {
            super.addFile(this.path);
            LoadThread load = new LoadThread(this);
            load.start();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, e.getMessage());
        }
    }

    private class LoadThread
    extends Thread {
        private DoctorJarLoader url;

        public LoadThread(DoctorJarLoader djl) {
            this.url = djl;
        }

        public void run() {
            try {
                this.url.loadClass("com.palm.nova.installer.core.DeviceInfo");
                this.url.loadClass("com.palm.novacom.INovacomController");
                this.url.loadClass("com.palm.novacom.INovacomDevice");
                this.url.loadClass("com.palm.novacom.INovacomStream");
                this.url.loadClass("com.palm.novacom.NovaDeviceInfo");
                this.url.loadClass("com.palm.novacom.Novacom");
                this.url.loadClass("com.palm.nova.installer.core.DesktopDriversMgr");
                this.url.loadClass("com.palm.nova.installer.core.DeviceInfo");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

