/*
 * Decompiled with CFR 0.152.
 */
package ca.canucksoftware;

import ca.canucksoftware.Carrier;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DoctorURLs {
    private final String CURRENT_CSV = "http://webosdoctor-url-generator.googlecode.com/svn/trunk/webOSDoctor%20URL%20Generator/current.csv";
    private ArrayList<Carrier> carriers = new ArrayList();

    public boolean loadCSV() {
        boolean result = false;
        URLConnection urlCon = null;
        try {
            urlCon = new URL("http://webosdoctor-url-generator.googlecode.com/svn/trunk/webOSDoctor%20URL%20Generator/current.csv").openConnection();
            urlCon.setRequestProperty("Content-Type", "text/plain");
            BufferedInputStream bis = new BufferedInputStream(urlCon.getInputStream());
            BufferedReader br = new BufferedReader(new InputStreamReader(bis));
            String line = br.readLine();
            while (line != null) {
                if (line.trim().length() > 0) {
                    this.addCSVEntry(line);
                }
                line = br.readLine();
            }
            br.close();
            if (this.carriers.size() > 0) {
                result = true;
            }
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    private void addCSVEntry(String entry) {
        String[] tokens = entry.split(",");
        if (tokens.length == 3) {
            Carrier curr = this.getCarrierByName(tokens[0]);
            if (curr == null) {
                curr = new Carrier(tokens[0]);
                this.carriers.add(curr);
            }
            curr.addDevice(tokens[1], tokens[2]);
        }
    }

    public ArrayList<Carrier> getCarriers() {
        return this.carriers;
    }

    public Carrier getCarrierByName(String name) {
        Carrier result = null;
        for (int i = 0; i < this.carriers.size(); ++i) {
            if (!this.carriers.get(i).getName().equalsIgnoreCase(name)) continue;
            result = this.carriers.get(i);
        }
        return result;
    }
}

