/*
 * Decompiled with CFR 0.152.
 */
package ca.canucksoftware;

import ca.canucksoftware.WebOSQuickInstallApp;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.text.NumberFormat;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import org.jdesktop.application.Application;
import org.jdesktop.application.ResourceMap;

public class Download
extends JDialog {
    private Timer t;
    private boolean downloadStarted;
    private String[] url;
    private File[] dest;
    private int[] maxSize;
    public boolean cancel;
    NumberFormat nf;
    private JButton jButton1;
    private JLabel jLabel1;
    private JLayeredPane jLayeredPane1;
    private JProgressBar jProgressBar1;

    public Download(Frame parent, String[] url, String[] d, int[] maxSize) {
        super(parent);
        this.initComponents();
        this.t = new Timer();
        this.downloadStarted = false;
        this.url = url;
        this.maxSize = maxSize;
        this.nf = NumberFormat.getNumberInstance();
        this.nf.setGroupingUsed(false);
        this.nf.setMaximumFractionDigits(2);
        this.cancel = false;
        this.jButton1.setText("Cancel");
        File[] array = new File[d.length];
        for (int i = 0; i < d.length; ++i) {
            array[i] = new File(d[i]);
        }
        this.dest = array;
    }

    public Download(Frame parent, String[] url, File[] dest, int[] maxSize) {
        super(parent);
        this.initComponents();
        this.t = new Timer();
        this.downloadStarted = false;
        this.url = url;
        this.dest = dest;
        this.maxSize = maxSize;
        this.nf = NumberFormat.getNumberInstance();
        this.nf.setGroupingUsed(false);
        this.nf.setMaximumFractionDigits(2);
        this.cancel = false;
        this.jButton1.setText("Cancel");
    }

    private String getName(String s) {
        return s.substring(s.lastIndexOf("/") + 1);
    }

    private void initComponents() {
        this.jLayeredPane1 = new JLayeredPane();
        this.jButton1 = new JButton();
        this.jProgressBar1 = new JProgressBar();
        this.jLabel1 = new JLabel();
        this.setDefaultCloseOperation(0);
        ResourceMap resourceMap = Application.getInstance(WebOSQuickInstallApp.class).getContext().getResourceMap(Download.class);
        this.setTitle(resourceMap.getString("title", new Object[0]));
        this.setBackground(resourceMap.getColor("transfer.background"));
        this.setCursor(new Cursor(3));
        this.setForeground(resourceMap.getColor("transfer.foreground"));
        this.setIconImage(null);
        this.setModal(true);
        this.setName("transfer");
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            public void windowActivated(WindowEvent evt) {
                Download.this.formWindowActivated(evt);
            }

            public void windowClosed(WindowEvent evt) {
                Download.this.formWindowClosed(evt);
            }

            public void windowOpened(WindowEvent evt) {
                Download.this.formWindowOpened(evt);
            }
        });
        this.jLayeredPane1.setBackground(resourceMap.getColor("jLayeredPane1.background"));
        this.jLayeredPane1.setForeground(resourceMap.getColor("jLayeredPane1.foreground"));
        this.jLayeredPane1.setName("jLayeredPane1");
        this.jLayeredPane1.setOpaque(true);
        this.jButton1.setText(resourceMap.getString("jButton1.text", new Object[0]));
        this.jButton1.setName("jButton1");
        this.jButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Download.this.jButton1ActionPerformed(evt);
            }
        });
        this.jButton1.setBounds(110, 120, 79, 25);
        this.jLayeredPane1.add((Component)this.jButton1, JLayeredPane.DEFAULT_LAYER);
        this.jProgressBar1.setName("jProgressBar1");
        this.jProgressBar1.setStringPainted(true);
        this.jProgressBar1.setBounds(50, 70, 200, 30);
        this.jLayeredPane1.add((Component)this.jProgressBar1, JLayeredPane.DEFAULT_LAYER);
        this.jLabel1.setHorizontalAlignment(2);
        this.jLabel1.setVerticalAlignment(1);
        this.jLabel1.setName("jLabel1");
        this.jLabel1.setBounds(60, 20, 230, 40);
        this.jLayeredPane1.add((Component)this.jLabel1, JLayeredPane.DEFAULT_LAYER);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLayeredPane1, -1, 308, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLayeredPane1, -1, 156, Short.MAX_VALUE));
        this.pack();
    }

    private void formWindowOpened(WindowEvent evt) {
    }

    private void formWindowActivated(WindowEvent evt) {
        if (!this.downloadStarted) {
            this.t.schedule((TimerTask)new DoDownload(), 100L);
            this.downloadStarted = true;
        }
    }

    private void formWindowClosed(WindowEvent evt) {
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        this.cancel = true;
    }

    class DoDownload
    extends TimerTask {
        DoDownload() {
        }

        public void run() {
            Download.this.t.cancel();
            try {
                int kbCount = 0;
                double percent = 0.0;
                byte[] data = new byte[1024];
                HttpURLConnection urlCon = null;
                for (int i = 0; i < Download.this.url.length; ++i) {
                    kbCount = 0;
                    int count = 0;
                    if (Download.this.maxSize[i] > 0) {
                        Download.this.jProgressBar1.setMaximum(Download.this.maxSize[i]);
                    }
                    File f = Download.this.dest[i];
                    Download.this.jLabel1.setText("<html>Downloading:\n" + Download.this.getName(Download.this.url[i]));
                    urlCon = (HttpURLConnection)new URL(Download.this.url[i]).openConnection();
                    urlCon.setInstanceFollowRedirects(true);
                    urlCon.setRequestProperty("REFERER", Download.this.url[i]);
                    if (urlCon.getContentLength() > -1) {
                        ((Download)Download.this).maxSize[i] = urlCon.getContentLength() / 1024;
                        Download.this.jProgressBar1.setMaximum(Download.this.maxSize[i]);
                    }
                    urlCon.connect();
                    BufferedInputStream in = new BufferedInputStream(urlCon.getInputStream());
                    FileOutputStream fos = new FileOutputStream(f);
                    BufferedOutputStream bout = new BufferedOutputStream(fos);
                    while ((count = in.read(data)) != -1 && !Download.this.cancel) {
                        if (Download.this.maxSize[i] > 0) {
                            percent = (double)kbCount / (double)Download.this.maxSize[i] * 100.0;
                            if ((int)Math.ceil(percent) > 100) {
                                Download.this.jLabel1.setText("<html>Processing finished download. This may take a few minutes.");
                                Download.this.jProgressBar1.setString("100%");
                            } else {
                                Download.this.jProgressBar1.setString((int)Math.ceil(percent) + "%");
                            }
                            Download.this.jProgressBar1.setValue(kbCount);
                        } else if (kbCount < 1000) {
                            Download.this.jProgressBar1.setString(kbCount + " KB");
                        } else {
                            Download.this.jProgressBar1.setString(Download.this.nf.format(kbCount / 1024) + " MB");
                        }
                        ++kbCount;
                        bout.write(data, 0, count);
                    }
                    if (Download.this.url.length > 1) {
                        Download.this.jProgressBar1.setValue(0);
                    }
                    bout.flush();
                    Download.this.jLabel1.setText("<html>Cleaning up:\n" + Download.this.getName(Download.this.url[i]));
                    fos.close();
                    bout.close();
                    in.close();
                    if (!Download.this.cancel) continue;
                    f.delete();
                    break;
                }
                urlCon.disconnect();
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(Download.this.rootPane, "ERROR:\n\n" + e);
            }
            System.gc();
            Download.this.dispose();
        }
    }
}

