/*
 * Decompiled with CFR 0.152.
 */
package ca.canucksoftware;

import ca.canucksoftware.WebOSQuickInstallApp;
import com.palm.nova.installer.core.BootieUtilities;
import com.palm.nova.installer.core.DeviceInfo;
import com.palm.nova.installer.core.ModemUtilities;
import com.palm.nova.installer.core.stages.EnableNovacomUsbByDefaultStage;
import com.palm.novacom.INovacomController;
import com.palm.novacom.INovacomDevice;
import com.palm.novacom.INovacomStream;
import com.palm.novacom.NovaDeviceInfo;
import com.palm.novacom.Novacom;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.util.prefs.Preferences;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JOptionPane;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextPane;
import javax.swing.text.Style;
import javax.swing.text.StyledDocument;
import org.jdesktop.application.Action;
import org.jdesktop.application.Application;
import org.jdesktop.application.ApplicationActionMap;
import org.jdesktop.application.ResourceMap;

public class Extras
extends JDialog {
    private static final String sep = "--------------------";
    private static INovacomDevice defaultDevice;
    private static Novacom Novacom;
    private NovaDeviceInfo[] devices;
    private INovacomController controller;
    private StyledDocument doc;
    private JButton closeButton;
    private JButton jButton1;
    private JButton jButton10;
    private JButton jButton11;
    private JButton jButton12;
    private JButton jButton2;
    private JButton jButton3;
    private JButton jButton4;
    private JButton jButton5;
    private JButton jButton6;
    private JButton jButton7;
    private JButton jButton8;
    private JButton jButton9;
    private JCheckBox jCheckBox1;
    private JCheckBox jCheckBox2;
    private JLabel jLabel1;
    private JLayeredPane jLayeredPane1;
    private JLayeredPane jLayeredPane2;
    private JScrollBar jScrollBar1;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;
    private JTextPane jTextPane1;

    public Extras(Frame parent) {
        super(parent);
        this.initComponents();
        this.getRootPane().setDefaultButton(this.closeButton);
        this.controller = Novacom.getController();
        this.devices = null;
        this.doc = this.jTextPane1.getStyledDocument();
        this.jCheckBox2.setSelected(Preferences.userRoot().getBoolean("ExtendScan", false));
        this.closeButton.requestFocus();
        try {
            this.devices = !Preferences.userRoot().getBoolean("useEmulator", false) ? this.controller.getDeviceListOnUsb() : this.controller.getDeviceList();
            if (this.devices != null && this.devices.length != 0) {
                defaultDevice = this.controller.connectToDevice(this.devices[0]);
                INovacomStream ins = defaultDevice.runProgram("/bin/mount", new String[]{"-o", "remount,rw", "/"});
                ins.waitForReturnCode();
            } else {
                this.addText("ERROR: No devices found\n--------------------", null);
            }
        }
        catch (Exception e) {
            this.addText("ERROR: " + e + "\n" + sep, null);
        }
    }

    private void addText(String text, Style s) {
        try {
            this.doc.insertString(this.doc.getLength(), text, s);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this.rootPane, e.getMessage());
        }
    }

    @Action
    public void closeAboutBox() {
        try {
            INovacomStream ins = defaultDevice.runProgram("/bin/mount", new String[]{"-o", "remount,ro", "/"});
            ins.waitForReturnCode();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.dispose();
    }

    @Action
    public void NovacomUSB() {
        EnableNovacomUsbByDefaultStage enubds;
        if (this.jCheckBox1.isSelected()) {
            this.addText("\nEnableNovacomUsbByDefault with USBNet...", null);
            enubds = new EnableNovacomUsbByDefaultStage(defaultDevice, "usbnet_enable");
        } else {
            this.addText("\nEnableNovacomUsbByDefault...", null);
            enubds = new EnableNovacomUsbByDefaultStage(defaultDevice, "blah");
        }
        try {
            enubds.run();
            this.addText("\nComplete!\n--------------------", null);
        }
        catch (Exception e) {
            this.addText("\nERROR: " + e + "\n" + sep, null);
        }
    }

    @Action
    public void LoadBootieUtilities() {
        String result = "";
        try {
            this.addText("\nLoading Bootie Utilities...", null);
            BootieUtilities bu = new BootieUtilities(defaultDevice, true);
            result = result + "\n    CciAuxSerialNumber: " + bu.readCciAuxSerialNumber();
            result = result + "\n    RadioSerialNumber: " + bu.readRadioSerialNumber();
            result = result + "\n    Battery: " + bu.checkPowerStatus() + "%";
            this.addText(result + "\nComplete!\n" + sep, null);
        }
        catch (Exception e) {
            this.addText(result, null);
            this.addText("\nERROR: " + e + "\n" + sep, null);
        }
    }

    @Action
    public void LoadModemUtilities() {
        String result = "";
        try {
            this.addText("\nLoading Modem Utilities...", null);
            ModemUtilities mu = new ModemUtilities(defaultDevice);
            result = result + "\n    ModemFirmwareVersion: " + mu.getModemFirmwareVersion();
            result = result + "\n    ModemType: " + mu.getModemType();
            result = result + "\n    ModemID: " + mu.getModemID();
            result = result + "\n    PriCRC: " + mu.getPriCRC();
            result = result + "\n    PrlRevision: " + mu.getPrlRevision();
            this.addText(result + "\nComplete!\n" + sep, null);
        }
        catch (Exception e) {
            this.addText(result, null);
            this.addText("\nERROR: " + e + "\n" + sep, null);
        }
    }

    @Action
    public void novacomDeviceInfo() {
        String result = "";
        if (this.devices[0] != null) {
            this.addText("\nNovacom Device Info...", null);
            result = result + "\n    MachineName: " + this.devices[0].getMachineName();
            result = result + "\n    Name: " + this.devices[0].getName();
            result = result + "\n    Transport: " + this.devices[0].getTransport();
            result = result + "\n    Port: " + this.devices[0].getPort();
            result = result + "\n    UIDString: " + this.devices[0].getUIDString();
            this.addText(result + "\nComplete!\n" + sep, null);
        } else {
            this.addText(result, null);
            this.addText("\nERROR: No devices found\n--------------------", null);
        }
    }

    @Action
    public void fullDeviceDetails() {
        String result = "";
        try {
            this.addText("\nFull Device Details...", null);
            DeviceInfo di = new DeviceInfo(defaultDevice);
            result = result + "\n    DeviceName: " + di.getDeviceName();
            result = result + "\n    DeviceType: " + di.getDeviceType();
            result = result + "\n    Battery: " + di.getBatteryPercentage() + "%";
            result = result + "\n    OSVersion: " + di.getOSVersion();
            result = result + "\n    ProductVersion: " + di.getProductVersion();
            result = result + "\n    BuildName: " + di.getBuildName();
            result = result + "\n    BuildVersion: " + di.getBuildVersion();
            result = result + "\n    BuildNumber: " + di.getBuildNumber();
            result = result + "\n    CarrierName: " + di.getCarrierName();
            result = result + "\n    CustomizationVariant: " + di.getCustomizationVariant();
            result = result + "\n    CustomizationVersion: " + di.getCustomizationVersion();
            result = result + "\n    SwUpdateServerFile: " + di.getSwUpdateServerFile();
            result = result + "\n    TouchPanelFwVersion: " + di.getTouchPanelFwVersion();
            result = result + "\n    HasAModem: " + di.hasAModem();
            result = result + "\n    ModemFwVersion: " + di.getModemFwVersion();
            result = result + "\n    ModemType: " + di.getModemType();
            result = result + "\n    ModemMeidOrImei: " + di.getModemMeidOrImei();
            this.addText(result + "\nComplete!\n" + sep, null);
        }
        catch (Exception e) {
            this.addText(result, null);
            this.addText("\nERROR: " + e + "\n" + sep, null);
        }
    }

    @Action
    public void enableSimLock() {
        try {
            this.addText("\nEnabling SimLock...", null);
            ModemUtilities mu = new ModemUtilities(defaultDevice);
            mu.enableSimLock();
            this.addText("\nComplete!\n--------------------", null);
        }
        catch (Exception e) {
            this.addText("\nERROR: " + e + "\n" + sep, null);
        }
    }

    @Action
    public void disableSimLock() {
        try {
            this.addText("\nDisabling SimLock...", null);
            ModemUtilities mu = new ModemUtilities(defaultDevice);
            String msl = JOptionPane.showInputDialog("Enter your MSL: ");
            if (msl != null) {
                mu.disableSimLock(msl);
                this.addText("\nComplete!\n--------------------", null);
            } else {
                this.addText("\nERROR: No MSL provided.\n--------------------", null);
            }
        }
        catch (Exception e) {
            this.addText("\nERROR: " + e + "\n" + sep, null);
        }
    }

    @Action
    public void rtnReset() {
        String result = "";
        try {
            this.addText("\nRTN Resetting...", null);
            ModemUtilities mu = new ModemUtilities(defaultDevice);
            mu.rtnReset();
            this.addText("\nComplete!\n--------------------", null);
        }
        catch (Exception e) {
            this.addText(result, null);
            this.addText("\nERROR: " + e + "\n" + sep, null);
        }
    }

    @Action
    public void priReset() {
        String result = "";
        try {
            this.addText("\nPRI Resetting...", null);
            ModemUtilities mu = new ModemUtilities(defaultDevice);
            mu.priReset();
            this.addText("\nComplete!\n--------------------", null);
        }
        catch (Exception e) {
            this.addText(result, null);
            this.addText("\nERROR: " + e + "\n" + sep, null);
        }
    }

    @Action
    public void deleteNascar() {
        this.addText("\nDeleting Nascar app...", null);
        if (this.deleteApp("com.handson.app.nascar")) {
            this.addText("\nComplete!", null);
        }
        this.addText("\n--------------------", null);
    }

    @Action
    public void deleteNFL() {
        this.addText("\nDeleting NFL app...", null);
        if (this.deleteApp("com.handson.app.nfl")) {
            this.addText("\nComplete!\n--------------------", null);
        }
        this.addText("\n--------------------", null);
    }

    private boolean deleteApp(String app) {
        INovacomStream ins;
        boolean deleted = true;
        try {
            ins = defaultDevice.runProgram("/bin/rm", new String[]{"/usr/palm/applications/" + app, "-r"});
            ins.waitForReturnCode();
        }
        catch (Exception e) {
            deleted = false;
            this.addText("\nERROR: " + e, null);
        }
        try {
            ins = defaultDevice.runProgram("/usr/bin/luna-send", new String[]{"palm://com.palm.applicationManager/rescan {}"});
            ins.waitForReturnCode();
        }
        catch (Exception e) {
            this.addText("\nERROR: " + e, null);
        }
        return deleted;
    }

    private void makeDir() {
        try {
            INovacomStream ins = defaultDevice.runProgram("/bin/mkdir", new String[]{"-p", "/media/internal/applications/"});
            ins.waitForReturnCode();
        }
        catch (Exception e) {
            this.addText("\n" + e.getMessage(), null);
        }
    }

    private void deleteDir() {
        if (JOptionPane.showConfirmDialog(this.rootPane, "Would you like to also delete the /media/internal/applications folder?", "Delete?", 0) == 0) {
            try {
                INovacomStream ins = defaultDevice.runProgram("/bin/rm", new String[]{"-r", "/media/internal/applications"});
                ins.waitForReturnCode();
            }
            catch (Exception e) {
                this.addText("\n" + e.getMessage(), null);
            }
        }
    }

    private void processConf(boolean b) {
        String tmpFilePath = System.getProperty("java.io.tmpdir");
        if (b) {
            this.makeDir();
        } else {
            this.deleteDir();
        }
        try {
            BufferedWriter newConf = new BufferedWriter(new FileWriter(tmpFilePath + "/luna.newconf"));
            INovacomStream conf = defaultDevice.getFile("/etc/palm/luna.conf");
            String line = conf.readLine();
            while (!line.equalsIgnoreCase("")) {
                if (line.startsWith("ApplicationPath=")) {
                    line = b ? "ApplicationPath=/usr/lib/luna/applications:/var/luna/applications:/var/usr/lib/luna/applications:/usr/palm/applications:/var/usr/palm/applications:/media/internal/applications\n" : "ApplicationPath=/usr/lib/luna/applications:/var/luna/applications:/var/usr/lib/luna/applications:/usr/palm/applications:/var/usr/palm/applications\n";
                }
                newConf.write(line);
                line = conf.readLine();
            }
            newConf.close();
            conf.close();
        }
        catch (Exception e) {
            this.addText("\n" + e.getMessage(), null);
        }
        File f = new File(tmpFilePath + "/luna.newconf");
        if (f.exists() && f.length() > 0L) {
            this.copyToDevice(f, "/etc/palm/luna.newconf");
            try {
                INovacomStream ins = defaultDevice.runProgram("/bin/mv", new String[]{"-f", "/etc/palm/luna.newconf", "/etc/palm/luna.conf"});
                ins.waitForReturnCode();
                ins = defaultDevice.runProgram("/usr/bin/luna-send", new String[]{"palm://com.palm.applicationManager/rescan {}"});
                ins.waitForReturnCode();
                this.addText("\nComplete!", null);
            }
            catch (Exception e) {
                this.addText("\n" + e.getMessage(), null);
            }
        }
    }

    public void copyToDevice(File src, String dest) {
        byte[] buffer = new byte[65536];
        FileInputStream input = null;
        INovacomStream stream = null;
        try {
            input = new FileInputStream(src);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this.rootPane, "ERROR 2:\n\n" + e.getMessage());
        }
        if (input != null) {
            try {
                stream = defaultDevice.putFile(dest);
            }
            catch (Exception e2) {
                JOptionPane.showMessageDialog(this.rootPane, "ERROR 3:\n\n" + e2.getMessage());
            }
            if (stream != null) {
                try {
                    int count = 0;
                    while ((count = input.read(buffer)) != -1) {
                        stream.write(buffer, 0, count);
                    }
                    stream.flush();
                    stream.closeInput();
                    stream.closeOutput();
                    stream.waitForReturnCode();
                    input.close();
                }
                catch (Exception e3) {
                    JOptionPane.showMessageDialog(this.rootPane, "ERROR 4:\n\n" + e3.getMessage());
                }
            }
        }
    }

    private void initComponents() {
        this.jLayeredPane1 = new JLayeredPane();
        this.jButton3 = new JButton();
        this.closeButton = new JButton();
        this.jButton10 = new JButton();
        this.jButton11 = new JButton();
        this.jLabel1 = new JLabel();
        this.jButton1 = new JButton();
        this.jLayeredPane2 = new JLayeredPane();
        this.jButton8 = new JButton();
        this.jButton7 = new JButton();
        this.jButton4 = new JButton();
        this.jCheckBox2 = new JCheckBox();
        this.jButton2 = new JButton();
        this.jButton9 = new JButton();
        this.jButton5 = new JButton();
        this.jSeparator1 = new JSeparator();
        this.jScrollBar1 = new JScrollBar();
        this.jScrollPane1 = new JScrollPane();
        this.jTextPane1 = new JTextPane();
        this.jCheckBox1 = new JCheckBox();
        this.jButton12 = new JButton();
        this.jButton6 = new JButton();
        this.setDefaultCloseOperation(0);
        ResourceMap resourceMap = Application.getInstance(WebOSQuickInstallApp.class).getContext().getResourceMap(Extras.class);
        this.setTitle(resourceMap.getString("title", new Object[0]));
        this.setModal(true);
        this.setName("aboutBox");
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                Extras.this.formWindowClosing(evt);
            }
        });
        this.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent evt) {
                Extras.this.formKeyPressed(evt);
            }
        });
        this.jLayeredPane1.setName("jLayeredPane1");
        ApplicationActionMap actionMap = Application.getInstance(WebOSQuickInstallApp.class).getContext().getActionMap(Extras.class, this);
        this.jButton3.setAction(actionMap.get("fullDeviceDetails"));
        this.jButton3.setText(resourceMap.getString("jButton3.text", new Object[0]));
        this.jButton3.setName("jButton3");
        this.jButton3.setBounds(20, 280, 160, -1);
        this.jLayeredPane1.add((Component)this.jButton3, JLayeredPane.DEFAULT_LAYER);
        this.closeButton.setAction(actionMap.get("closeAboutBox"));
        this.closeButton.setName("closeButton");
        this.closeButton.setBounds(240, 370, 77, -1);
        this.jLayeredPane1.add((Component)this.closeButton, JLayeredPane.DEFAULT_LAYER);
        this.jButton10.setAction(actionMap.get("deleteNascar"));
        this.jButton10.setText(resourceMap.getString("jButton10.text", new Object[0]));
        this.jButton10.setName("jButton10");
        this.jButton10.setBounds(250, 60, -1, -1);
        this.jLayeredPane1.add((Component)this.jButton10, JLayeredPane.DEFAULT_LAYER);
        this.jButton11.setAction(actionMap.get("priReset"));
        this.jButton11.setText(resourceMap.getString("jButton11.text", new Object[0]));
        this.jButton11.setName("jButton11");
        this.jButton11.setBounds(20, 190, 160, -1);
        this.jLayeredPane1.add((Component)this.jButton11, JLayeredPane.DEFAULT_LAYER);
        this.jLabel1.setText(resourceMap.getString("jLabel1.text", new Object[0]));
        this.jLabel1.setName("jLabel1");
        this.jLabel1.setBounds(30, 10, 480, 30);
        this.jLayeredPane1.add((Component)this.jLabel1, JLayeredPane.DEFAULT_LAYER);
        this.jButton1.setText(resourceMap.getString("jButton1.text", new Object[0]));
        this.jButton1.setName("jButton1");
        this.jButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Extras.this.jButton1ActionPerformed(evt);
            }
        });
        this.jButton1.setBounds(450, 360, 79, -1);
        this.jLayeredPane1.add((Component)this.jButton1, JLayeredPane.DEFAULT_LAYER);
        this.jLayeredPane2.setBorder(BorderFactory.createTitledBorder(resourceMap.getString("jLayeredPane2.border.title", new Object[0])));
        this.jLayeredPane2.setName("jLayeredPane2");
        this.jButton8.setAction(actionMap.get("enableSimLock"));
        this.jButton8.setText(resourceMap.getString("jButton8.text", new Object[0]));
        this.jButton8.setName("jButton8");
        this.jButton8.setBounds(10, 20, 130, -1);
        this.jLayeredPane2.add((Component)this.jButton8, JLayeredPane.DEFAULT_LAYER);
        this.jButton7.setAction(actionMap.get("disableSimLock"));
        this.jButton7.setText(resourceMap.getString("jButton7.text", new Object[0]));
        this.jButton7.setName("jButton7");
        this.jButton7.setBounds(10, 50, 130, -1);
        this.jLayeredPane2.add((Component)this.jButton7, JLayeredPane.DEFAULT_LAYER);
        this.jLayeredPane2.setBounds(400, 50, 150, 80);
        this.jLayeredPane1.add((Component)this.jLayeredPane2, JLayeredPane.DEFAULT_LAYER);
        this.jButton4.setAction(actionMap.get("LoadBootieUtilities"));
        this.jButton4.setText(resourceMap.getString("jButton4.text", new Object[0]));
        this.jButton4.setName("jButton4");
        this.jButton4.setBounds(20, 130, 160, -1);
        this.jLayeredPane1.add((Component)this.jButton4, JLayeredPane.DEFAULT_LAYER);
        this.jCheckBox2.setFont(resourceMap.getFont("jCheckBox2.font"));
        this.jCheckBox2.setText(resourceMap.getString("jCheckBox2.text", new Object[0]));
        this.jCheckBox2.setName("jCheckBox2");
        this.jCheckBox2.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                Extras.this.jCheckBox2MouseClicked(evt);
            }
        });
        this.jCheckBox2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Extras.this.jCheckBox2ActionPerformed(evt);
            }
        });
        this.jCheckBox2.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent evt) {
                Extras.this.jCheckBox2KeyTyped(evt);
            }
        });
        this.jCheckBox2.setBounds(0, 310, 200, 60);
        this.jLayeredPane1.add((Component)this.jCheckBox2, JLayeredPane.DEFAULT_LAYER);
        this.jButton2.setAction(actionMap.get("NovacomUSB"));
        this.jButton2.setText(resourceMap.getString("jButton2.text", new Object[0]));
        this.jButton2.setName("jButton2");
        this.jButton2.setBounds(20, 60, 210, -1);
        this.jLayeredPane1.add((Component)this.jButton2, JLayeredPane.DEFAULT_LAYER);
        this.jButton9.setAction(actionMap.get("deleteNFL"));
        this.jButton9.setText(resourceMap.getString("jButton9.text", new Object[0]));
        this.jButton9.setName("jButton9");
        this.jButton9.setBounds(250, 90, -1, -1);
        this.jLayeredPane1.add((Component)this.jButton9, JLayeredPane.DEFAULT_LAYER);
        this.jButton5.setAction(actionMap.get("LoadModemUtilities"));
        this.jButton5.setText(resourceMap.getString("jButton5.text", new Object[0]));
        this.jButton5.setName("jButton5");
        this.jButton5.setBounds(20, 160, 160, -1);
        this.jLayeredPane1.add((Component)this.jButton5, JLayeredPane.DEFAULT_LAYER);
        this.jSeparator1.setName("jSeparator1");
        this.jSeparator1.setBounds(30, 50, 500, 20);
        this.jLayeredPane1.add((Component)this.jSeparator1, JLayeredPane.DEFAULT_LAYER);
        this.jScrollBar1.setName("jScrollBar1");
        this.jScrollBar1.setBounds(530, 130, -1, 220);
        this.jLayeredPane1.add((Component)this.jScrollBar1, JLayeredPane.DEFAULT_LAYER);
        this.jScrollPane1.setName("jScrollPane1");
        this.jScrollPane1.setVerticalScrollBar(this.jScrollBar1);
        this.jTextPane1.setEditable(false);
        this.jTextPane1.setName("jTextPane1");
        this.jScrollPane1.setViewportView(this.jTextPane1);
        this.jScrollPane1.setBounds(200, 130, 330, 220);
        this.jLayeredPane1.add((Component)this.jScrollPane1, JLayeredPane.DEFAULT_LAYER);
        this.jCheckBox1.setText(resourceMap.getString("jCheckBox1.text", new Object[0]));
        this.jCheckBox1.setName("jCheckBox1");
        this.jCheckBox1.setBounds(20, 90, 120, -1);
        this.jLayeredPane1.add((Component)this.jCheckBox1, JLayeredPane.DEFAULT_LAYER);
        this.jButton12.setAction(actionMap.get("rtnReset"));
        this.jButton12.setText(resourceMap.getString("jButton12.text", new Object[0]));
        this.jButton12.setName("jButton12");
        this.jButton12.setBounds(20, 220, 160, -1);
        this.jLayeredPane1.add((Component)this.jButton12, JLayeredPane.DEFAULT_LAYER);
        this.jButton6.setAction(actionMap.get("novacomDeviceInfo"));
        this.jButton6.setText(resourceMap.getString("jButton6.text", new Object[0]));
        this.jButton6.setName("jButton6");
        this.jButton6.setBounds(20, 250, 160, -1);
        this.jLayeredPane1.add((Component)this.jButton6, JLayeredPane.DEFAULT_LAYER);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLayeredPane1, -1, 560, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLayeredPane1, -1, 408, Short.MAX_VALUE));
        this.pack();
    }

    private void formKeyPressed(KeyEvent evt) {
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        this.jTextPane1.setText("");
    }

    private void jCheckBox2MouseClicked(MouseEvent evt) {
    }

    private void jCheckBox2ActionPerformed(ActionEvent evt) {
        this.addText("\nExtending app scan locations...", null);
        this.processConf(this.jCheckBox2.isSelected());
        Preferences.userRoot().putBoolean("ExtendScan", this.jCheckBox1.isSelected());
        this.addText("\n--------------------", null);
    }

    private void jCheckBox2KeyTyped(KeyEvent evt) {
    }

    private void formWindowClosing(WindowEvent evt) {
    }
}

