/*
 * Decompiled with CFR 0.152.
 */
package ca.canucksoftware;

import ca.canucksoftware.AppInfoBox;
import ca.canucksoftware.AppInfoEntry;
import ca.canucksoftware.Download;
import ca.canucksoftware.ManageFeeds;
import ca.canucksoftware.NovacomConnection;
import ca.canucksoftware.PackageFeed;
import ca.canucksoftware.WebOSQuickInstallApp;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Timer;
import java.util.TimerTask;
import java.util.prefs.Preferences;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLayeredPane;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import org.jdesktop.application.Action;
import org.jdesktop.application.Application;
import org.jdesktop.application.ApplicationActionMap;
import org.jdesktop.application.ResourceMap;

public class IpkgFeed
extends JDialog {
    public boolean dontOpen;
    private int currIndex;
    private ArrayList<String> feedTitles;
    private ArrayList<String> feedUrls;
    private AppInfoBox infoBox;
    private NovacomConnection novaCon;
    private ArrayList<PackageFeed> feeds;
    private PackageFeed userApps;
    private DefaultTableModel modTable;
    private Timer t;
    private boolean appsListLoaded;
    private int listLoadTries;
    private JButton closeButton;
    private JButton jButton1;
    private JComboBox jComboBox1;
    private JLayeredPane jLayeredPane1;
    private JLayeredPane jLayeredPane2;
    private JScrollPane jScrollPane1;
    private JTable jTable1;

    public IpkgFeed(Frame parent) {
        super(parent);
        this.initComponents();
        this.feedTitles = new ArrayList(0);
        this.feedUrls = new ArrayList(0);
        this.feeds = new ArrayList(0);
        this.feedTitles.add("PreCentral App Gallery Feed");
        this.feedUrls.add("http://ipkg.preware.org/feeds/precentral/Packages.gz");
        this.feeds.add(null);
        this.feedTitles.add("WebOS-Internals Feed (all)");
        this.feedUrls.add("http://ipkg.preware.org/feeds/webos-internals/all/Packages.gz");
        this.feeds.add(null);
        this.feedTitles.add("WebOS-Internals Feed (Pre)");
        this.feedUrls.add("http://ipkg.preware.org/feeds/webos-internals/armv7/Packages.gz");
        this.feeds.add(null);
        this.feedTitles.add("WebOS-Internals Feed (Pixi)");
        this.feedUrls.add("http://ipkg.preware.org/feeds/webos-internals/armv6/Packages.gz");
        this.feeds.add(null);
        this.feedTitles.add("WebOS-Internals Feed (Emulator)");
        this.feedUrls.add("http://ipkg.preware.org/feeds/webos-internals/i686/Packages.gz");
        this.feeds.add(null);
        this.addOtherFeeds();
        this.appsListLoaded = false;
        this.currIndex = 0;
        this.getRootPane().setDefaultButton(this.closeButton);
        this.dontOpen = false;
        this.modTable = (DefaultTableModel)this.jTable1.getModel();
        this.modTable.addRow(new Object[]{"", "Loading list...", Boolean.FALSE});
        this.getContentPane().requestFocus();
        this.novaCon = new NovacomConnection();
        this.jComboBox1.setEnabled(false);
        this.jButton1.setEnabled(false);
        this.t = new Timer();
        this.listLoadTries = 0;
        this.novaCon.connect(true);
        this.t.schedule((TimerTask)new DoLoad(), 50L);
    }

    private void addOtherFeeds() {
        String data = Preferences.userRoot().get("otherFeeds", "");
        if (!data.equals("")) {
            String[] elements = data.split("\n");
            for (int i = 0; i < elements.length; ++i) {
                this.feedTitles.add(elements[i]);
                this.jComboBox1.addItem(elements[i]);
                this.feedUrls.add(elements[++i]);
                this.feeds.add(null);
            }
        }
        this.jComboBox1.addItem("Manage custom feeds...");
    }

    private void loadData() {
        if (this.feeds.get(this.currIndex) == null) {
            this.feeds.set(this.currIndex, PackageFeed.downloadFeed(this.feedUrls.get(this.currIndex), this.novaCon));
            if (this.feeds.get((int)this.currIndex).errorDownloading) {
                this.feeds.set(this.currIndex, null);
            }
        }
        while (this.modTable.getRowCount() > 0) {
            this.modTable.removeRow(0);
        }
        if (this.feeds.get(this.currIndex) != null) {
            if (!this.feeds.get((int)this.currIndex).errorDownloading) {
                this.jComboBox1.setEnabled(true);
                this.jButton1.setEnabled(true);
                this.feeds.get(this.currIndex).sort(true);
                for (int i = 0; i < this.feeds.get((int)this.currIndex).apps.size(); ++i) {
                    this.modTable.addRow(new Object[]{"", "<html>" + this.feeds.get((int)this.currIndex).apps.get((int)i).name, Boolean.FALSE});
                }
            }
        } else {
            JOptionPane.showMessageDialog(this.rootPane, "ERROR: Invalid feed url.");
        }
        this.t.schedule((TimerTask)new DoListApps(), 150L);
    }

    private void loadAppTable() {
        this.userApps = this.novaCon.getAppsFeed(this.novaCon.offlineRoot + "/usr/lib/ipkg/status");
        if (this.userApps != null) {
            this.jComboBox1.setEnabled(true);
            this.jButton1.setEnabled(true);
            this.appsListLoaded = true;
            this.userApps.sort(true);
            for (int i = 0; i < this.userApps.apps.size(); ++i) {
                for (int k = 0; k < this.feeds.get((int)this.currIndex).apps.size(); ++k) {
                    if (!this.feeds.get((int)this.currIndex).apps.get((int)k).id.equalsIgnoreCase(this.userApps.apps.get((int)i).id) || !this.feeds.get((int)this.currIndex).apps.get(k).isNewerVersion(this.userApps.apps.get(i))) continue;
                    this.modTable.setValueAt("<html><strong>++</strong>", k, 0);
                }
            }
        }
    }

    @Action
    public void download() {
        ArrayList<String> urls = new ArrayList<String>(0);
        ArrayList<String> dests = new ArrayList<String>(0);
        ArrayList<Integer> sizes = new ArrayList<Integer>(0);
        this.getContentPane().requestFocus();
        if (this.jTable1.getRowCount() > 0) {
            int i;
            for (i = 0; i < this.modTable.getRowCount(); ++i) {
                Boolean b = (Boolean)this.modTable.getValueAt(i, 2);
                if (b != Boolean.TRUE) continue;
                this.modTable.setValueAt(Boolean.FALSE, i, 2);
                AppInfoEntry curr = this.feeds.get((int)this.currIndex).apps.get(i);
                if (curr.file.equals(curr.UNKNOWN)) break;
                urls.add(this.formatURL(this.feedUrls.get(this.currIndex)) + curr.file);
                String file = curr.file.substring(curr.file.lastIndexOf("/") + 1);
                dests.add(WebOSQuickInstallApp.getDir() + File.separatorChar + "Install" + File.separatorChar + file);
                if (curr.size.equals(curr.UNKNOWN)) {
                    sizes.add(new Integer(0));
                    continue;
                }
                sizes.add(new Integer(Integer.parseInt(this.feeds.get((int)this.currIndex).apps.get((int)i).size) / 1024));
            }
            int[] iSizes = new int[sizes.size()];
            for (i = 0; i < sizes.size(); ++i) {
                iSizes[i] = (Integer)sizes.get(i);
            }
            JFrame mainFrame = WebOSQuickInstallApp.getApplication().getMainFrame();
            Download dlBox = new Download((Frame)mainFrame, urls.toArray(new String[urls.size()]), dests.toArray(new String[dests.size()]), iSizes);
            dlBox.setLocationRelativeTo(mainFrame);
            WebOSQuickInstallApp.getApplication().show(dlBox);
        }
    }

    private String formatURL(String url) {
        return url.substring(0, url.lastIndexOf(47) + 1);
    }

    @Action
    public void closeFeed() {
        this.getContentPane().requestFocus();
        this.dispose();
    }

    private void launchInfo(int index) {
        if (index > -1) {
            JFrame mainFrame = WebOSQuickInstallApp.getApplication().getMainFrame();
            this.infoBox = new AppInfoBox((Frame)mainFrame, this.feeds.get((int)this.currIndex).apps.get(index));
            this.infoBox.setLocationRelativeTo(mainFrame);
            WebOSQuickInstallApp.getApplication().show(this.infoBox);
        }
    }

    private void initComponents() {
        this.jLayeredPane1 = new JLayeredPane();
        this.closeButton = new JButton();
        this.jLayeredPane2 = new JLayeredPane();
        this.jScrollPane1 = new JScrollPane();
        this.jTable1 = new JTable();
        this.jComboBox1 = new JComboBox();
        this.jButton1 = new JButton();
        this.setDefaultCloseOperation(2);
        ResourceMap resourceMap = Application.getInstance(WebOSQuickInstallApp.class).getContext().getResourceMap(IpkgFeed.class);
        this.setTitle(resourceMap.getString("title", new Object[0]));
        this.setModal(true);
        this.setName("aboutBox");
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                IpkgFeed.this.formWindowClosing(evt);
            }
        });
        this.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent evt) {
                IpkgFeed.this.formKeyPressed(evt);
            }
        });
        this.jLayeredPane1.setName("jLayeredPane1");
        this.jLayeredPane1.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                IpkgFeed.this.jLayeredPane1MouseClicked(evt);
            }
        });
        this.jLayeredPane1.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent evt) {
                IpkgFeed.this.jLayeredPane1KeyTyped(evt);
            }
        });
        ApplicationActionMap actionMap = Application.getInstance(WebOSQuickInstallApp.class).getContext().getActionMap(IpkgFeed.class, this);
        this.closeButton.setAction(actionMap.get("closeFeed"));
        this.closeButton.setText(resourceMap.getString("closeButton.text", new Object[0]));
        this.closeButton.setName("closeButton");
        this.closeButton.setBounds(130, 440, 77, 23);
        this.jLayeredPane1.add((Component)this.closeButton, JLayeredPane.DEFAULT_LAYER);
        this.jLayeredPane2.setName("jLayeredPane2");
        this.jScrollPane1.setName("jScrollPane1");
        this.jTable1.setModel(new DefaultTableModel(new Object[0][], new String[]{"", "Application", ""}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{String.class, String.class, Boolean.class};
                this.canEdit = new boolean[]{false, false, true};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.jTable1.setFillsViewportHeight(true);
        this.jTable1.setFocusable(false);
        this.jTable1.setName("jTable1");
        this.jTable1.setSelectionMode(0);
        this.jTable1.setShowVerticalLines(false);
        this.jTable1.getTableHeader().setResizingAllowed(false);
        this.jTable1.getTableHeader().setReorderingAllowed(false);
        this.jTable1.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                IpkgFeed.this.jTable1MouseClicked(evt);
            }

            public void mousePressed(MouseEvent evt) {
                IpkgFeed.this.jTable1MousePressed(evt);
            }

            public void mouseReleased(MouseEvent evt) {
                IpkgFeed.this.jTable1MouseReleased(evt);
            }
        });
        this.jTable1.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent evt) {
                IpkgFeed.this.jTable1KeyTyped(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jTable1);
        this.jTable1.getColumnModel().getColumn(0).setPreferredWidth(35);
        this.jTable1.getColumnModel().getColumn(0).setHeaderValue(resourceMap.getString("jTable1.columnModel.title2", new Object[0]));
        this.jTable1.getColumnModel().getColumn(1).setPreferredWidth(250);
        this.jTable1.getColumnModel().getColumn(1).setHeaderValue(resourceMap.getString("jTable1.columnModel.title0", new Object[0]));
        this.jTable1.getColumnModel().getColumn(2).setPreferredWidth(50);
        this.jTable1.getColumnModel().getColumn(2).setHeaderValue(resourceMap.getString("jTable1.columnModel.title1", new Object[0]));
        this.jScrollPane1.setBounds(10, 40, 300, 330);
        this.jLayeredPane2.add((Component)this.jScrollPane1, JLayeredPane.DEFAULT_LAYER);
        this.jComboBox1.setFont(resourceMap.getFont("jComboBox1.font"));
        this.jComboBox1.setModel(new DefaultComboBoxModel<String>(new String[]{"PreCentral App Gallery Feed", "WebOS-Internals Feed (all)", "WebOS-Internals Feed (Pre)", "WebOS-Internals Feed (Pixi)", "WebOS-Internals Feed (Emulator)"}));
        this.jComboBox1.setName("jComboBox1");
        this.jComboBox1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                IpkgFeed.this.jComboBox1ActionPerformed(evt);
            }
        });
        this.jComboBox1.setBounds(10, 0, 300, 30);
        this.jLayeredPane2.add((Component)this.jComboBox1, JLayeredPane.DEFAULT_LAYER);
        this.jButton1.setAction(actionMap.get("download"));
        this.jButton1.setFont(resourceMap.getFont("jButton1.font"));
        this.jButton1.setText(resourceMap.getString("jButton1.text", new Object[0]));
        this.jButton1.setName("jButton1");
        this.jButton1.setBounds(200, 380, 110, 30);
        this.jLayeredPane2.add((Component)this.jButton1, JLayeredPane.DEFAULT_LAYER);
        this.jLayeredPane2.setBounds(10, 10, 320, 410);
        this.jLayeredPane1.add((Component)this.jLayeredPane2, JLayeredPane.DEFAULT_LAYER);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLayeredPane1, -2, 341, -2));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLayeredPane1, -2, 471, -2));
        this.pack();
    }

    private void formKeyPressed(KeyEvent evt) {
    }

    private void jTable1MouseClicked(MouseEvent evt) {
    }

    private void jTable1KeyTyped(KeyEvent evt) {
    }

    private void jLayeredPane1KeyTyped(KeyEvent evt) {
    }

    private void jLayeredPane1MouseClicked(MouseEvent evt) {
    }

    private void jTable1MousePressed(MouseEvent evt) {
        int i = this.jTable1.rowAtPoint(evt.getPoint());
        if (i > -1 && (this.jTable1.columnAtPoint(evt.getPoint()) == 0 || this.jTable1.columnAtPoint(evt.getPoint()) == 1)) {
            this.launchInfo(i);
        }
        this.jTable1.removeRowSelectionInterval(this.jTable1.getSelectedRow(), this.jTable1.getSelectedRow());
    }

    private void jTable1MouseReleased(MouseEvent evt) {
        this.jTable1.removeRowSelectionInterval(this.jTable1.getSelectedRow(), this.jTable1.getSelectedRow());
    }

    private void formWindowClosing(WindowEvent evt) {
        this.novaCon.close();
    }

    private void jComboBox1ActionPerformed(ActionEvent evt) {
        int i = this.jComboBox1.getSelectedIndex();
        if (i == this.feedUrls.size()) {
            JFrame mainFrame = WebOSQuickInstallApp.getApplication().getMainFrame();
            ManageFeeds custFeeds = new ManageFeeds(mainFrame);
            custFeeds.setLocationRelativeTo(mainFrame);
            WebOSQuickInstallApp.getApplication().show(custFeeds);
            i = 0;
            while (this.jComboBox1.getItemCount() > 5) {
                this.jComboBox1.removeItemAt(5);
            }
            this.addOtherFeeds();
            this.currIndex = 0;
            this.jComboBox1.setSelectedIndex(this.currIndex);
            this.loadData();
        } else if (i > -1 && i < this.feedUrls.size()) {
            this.currIndex = i;
            this.loadData();
        }
        this.getContentPane().requestFocus();
    }

    class DoListApps
    extends TimerTask {
        DoListApps() {
        }

        public void run() {
            IpkgFeed.this.loadAppTable();
            IpkgFeed.this.listLoadTries++;
            if (!IpkgFeed.this.appsListLoaded && IpkgFeed.this.listLoadTries < 15) {
                IpkgFeed.this.t.schedule((TimerTask)new DoListApps(), 150L);
            }
        }
    }

    class DoLoad
    extends TimerTask {
        DoLoad() {
        }

        public void run() {
            IpkgFeed.this.novaCon.getWebOSVersion();
            IpkgFeed.this.loadData();
        }
    }
}

