/*
 * Decompiled with CFR 0.152.
 */
package ca.canucksoftware;

import ca.canucksoftware.NovacomConnection;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import org.json.JSONArray;
import org.json.JSONObject;

public class KeyboardConfig {
    private File configF;
    private JSONObject json;
    private JSONArray themes;
    private NovacomConnection novaCon;

    public KeyboardConfig(File f, NovacomConnection nc) {
        this.configF = f;
        this.novaCon = nc;
        this.readJSON();
    }

    public void readJSON() {
        String content = "";
        try {
            BufferedReader br = new BufferedReader(new FileReader(this.configF));
            String line = br.readLine();
            while (line != null) {
                content = content + line;
                line = br.readLine();
            }
            br.close();
            this.json = new JSONObject(content.trim());
            this.themes = this.json.has("installed_themes") ? this.json.getJSONArray("installed_themes") : new JSONArray();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "ERROR: " + e.getMessage());
        }
    }

    public void setHaptic(boolean val) {
        try {
            if (val) {
                this.json.put("haptic", 50);
            } else {
                this.json.put("haptic", 0);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean getHaptic() {
        boolean result = false;
        if (this.json.has("haptic")) {
            try {
                result = this.json.getInt("haptic") != 0;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    public void setSound(File f) {
        try {
            if (f == null) {
                this.json.put("clickFile", "");
            } else if (this.novaCon.sendFile(f, "/media/internal/virtual-keyboard/.sounds/" + this.novaCon.getFilename(f))) {
                this.json.put("clickFile", this.novaCon.getFilename(f));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setSound(String s) {
        try {
            if (s == null) {
                this.json.put("clickFile", "");
            } else {
                this.json.put("clickFile", s);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getSound() {
        String result = "";
        try {
            if (this.json.has("clickFile")) {
                result = this.json.getString("clickFile");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public int getThemeCount() {
        return this.themes.length();
    }

    public String getThemeAt(int i) {
        String result = null;
        try {
            JSONObject curr = (JSONObject)this.themes.get(i);
            if (curr.has("value")) {
                result = curr.getString("value");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public String getThemeByLabel(String label) {
        String result = null;
        try {
            for (int i = 0; i < this.themes.length(); ++i) {
                JSONObject curr = (JSONObject)this.themes.get(i);
                if (!curr.has("label") || !curr.getString("label").equalsIgnoreCase(label) || !curr.has("value")) continue;
                result = curr.getString("value");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public String[] getThemeLabels() {
        String[] result = null;
        try {
            String s = this.getTheme();
            if (!this.inThemesList(s)) {
                JSONObject newJson = new JSONObject();
                newJson.put("label", s);
                newJson.put("value", s);
                this.themes.put(newJson);
            }
            result = new String[this.themes.length()];
            for (int i = 0; i < result.length; ++i) {
                JSONObject curr = (JSONObject)this.themes.get(i);
                if (!curr.has("label")) continue;
                result[i] = curr.getString("label");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public boolean inThemesList(String value) {
        boolean result = false;
        for (int i = 0; i < this.themes.length(); ++i) {
            try {
                JSONObject curr = (JSONObject)this.themes.get(i);
                if (!curr.has("value") || !curr.getString("value").equalsIgnoreCase(value)) continue;
                result = true;
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return result;
    }

    public boolean setTheme(String s) {
        boolean result = false;
        try {
            if (s != null) {
                if (this.novaCon.fileExists("/media/internal/virtual-keyboard/.themes/" + s + "/theme_config.json")) {
                    if (!this.inThemesList(s)) {
                        JSONObject newJson = new JSONObject();
                        newJson.put("label", s);
                        newJson.put("value", s);
                        this.themes.put(newJson);
                    }
                    this.json.put("theme", s);
                    result = true;
                } else {
                    JOptionPane.showMessageDialog(null, "ERROR: Theme not found on device:\n\n/media/internal/virtual-keyboard/.themes/" + s);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public String getTheme() {
        String result = "";
        try {
            if (this.json.has("theme")) {
                result = this.json.getString("theme");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public void writeJSON() {
        try {
            this.configF.delete();
            BufferedWriter bw = new BufferedWriter(new FileWriter(this.configF));
            bw.write(this.json.toString());
            bw.newLine();
            bw.flush();
            bw.close();
            this.novaCon.sendFile(this.configF, "/media/internal/virtual-keyboard/kb_config.json");
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "ERROR: " + e.getMessage());
        }
    }

    public FileFilter getSoundFilter() {
        return new SoundChooseFilter();
    }

    class SoundChooseFilter
    extends FileFilter {
        private final String[] okFileExtensions = new String[]{"wav"};

        SoundChooseFilter() {
        }

        public boolean accept(File f) {
            for (String extension : this.okFileExtensions) {
                if (!f.getName().toLowerCase().endsWith(extension) && !f.isDirectory()) continue;
                return true;
            }
            return false;
        }

        public String getDescription() {
            return "Sound files (*.wav)";
        }
    }
}

