/*
 * Decompiled with CFR 0.152.
 */
package ca.canucksoftware;

import ca.canucksoftware.AboutBox;
import ca.canucksoftware.DeleteFile;
import ca.canucksoftware.DeviceManagement;
import ca.canucksoftware.IpkgFeed;
import ca.canucksoftware.LinuxCommandline;
import ca.canucksoftware.Options;
import ca.canucksoftware.ReceiveFile;
import ca.canucksoftware.SendFile;
import ca.canucksoftware.ThemeChooser;
import ca.canucksoftware.Transfer;
import ca.canucksoftware.Tweaks;
import ca.canucksoftware.Usage;
import ca.canucksoftware.Versioning;
import ca.canucksoftware.WebOSQuickInstallApp;
import com.palm.nova.installer.core.DesktopDriversMgr;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Timer;
import java.util.TimerTask;
import java.util.prefs.Preferences;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.border.LineBorder;
import javax.swing.table.DefaultTableModel;
import net.iharder.dnd.FileDrop;
import org.jdesktop.application.Action;
import org.jdesktop.application.Application;
import org.jdesktop.application.ApplicationActionMap;
import org.jdesktop.application.FrameView;
import org.jdesktop.application.ResourceMap;
import org.jdesktop.application.SingleFrameApplication;
import org.jdesktop.application.TaskMonitor;

public class MainView
extends FrameView {
    public ArrayList<File> installApps;
    public DefaultTableModel modTable;
    public String installDir;
    public Image bg;
    private ResourceMap resourceMap;
    private DesktopDriversMgr driverMgr;
    private Timer t;
    private String fcPath;
    private JButton jButton1;
    private JButton jButton2;
    private JButton jButton3;
    private JButton jButton4;
    private JButton jButton5;
    private JLabel jLabel1;
    private JLayeredPane jLayeredPane1;
    private JLayeredPane jLayeredPane3;
    private JLayeredPane jLayeredPane7;
    private JMenu jMenu1;
    private JMenuItem jMenuItem1;
    private JMenuItem jMenuItem10;
    private JMenuItem jMenuItem11;
    private JMenuItem jMenuItem2;
    private JMenuItem jMenuItem3;
    private JMenuItem jMenuItem4;
    private JMenuItem jMenuItem5;
    private JMenuItem jMenuItem6;
    private JMenuItem jMenuItem7;
    private JMenuItem jMenuItem8;
    private JMenuItem jMenuItem9;
    private JScrollPane jScrollPane2;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JSeparator jSeparator3;
    private JTable jTable1;
    public JPanel mainPanel;
    private JMenuBar menuBar;
    private JProgressBar progressBar;
    private JLabel statusAnimationLabel;
    private JLabel statusMessageLabel;
    private JPanel statusPanel;
    private final javax.swing.Timer messageTimer;
    private final javax.swing.Timer busyIconTimer;
    private final Icon idleIcon;
    private final Icon[] busyIcons = new Icon[15];
    private int busyIconIndex = 0;
    private JDialog aboutBox;
    private ThemeChooser themer;
    private Options options;
    private IpkgFeed repository;
    private JDialog custTransfer;
    private Tweaks tweaks;
    private DeviceManagement manage;
    private JDialog usage;
    private Transfer transfer;
    private LinuxCommandline cmdline;

    public MainView(SingleFrameApplication app) {
        super(app);
        this.resourceMap = this.getResourceMap();
        this.bg = this.resourceMap.getImageIcon("background").getImage();
        this.initComponents();
        this.getStatusBar().hide();
        this.jButton2.setCursor(Cursor.getPredefinedCursor(12));
        this.fcPath = Preferences.userRoot().get("fcPath", null);
        this.getFrame().setIconImage(this.resourceMap.getImageIcon("icon").getImage());
        this.jTable1.setGridColor(Color.CYAN);
        this.modTable = (DefaultTableModel)this.jTable1.getModel();
        File[] files = this.loadList();
        if (files != null) {
            this.installApps = new ArrayList<File>(Arrays.asList(files));
            this.displayList();
        } else {
            this.installApps = new ArrayList(0);
        }
        new FileDrop(this.jTable1, new FileDrop.Listener(){

            public void filesDropped(File[] files) {
                for (int i = 0; i < files.length; ++i) {
                    MainView.this.addFile(files[i]);
                }
            }
        });
        int messageTimeout = this.resourceMap.getInteger("StatusBar.messageTimeout");
        this.messageTimer = new javax.swing.Timer(messageTimeout, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MainView.this.statusMessageLabel.setText("");
            }
        });
        this.messageTimer.setRepeats(false);
        int busyAnimationRate = this.resourceMap.getInteger("StatusBar.busyAnimationRate");
        for (int i = 0; i < this.busyIcons.length; ++i) {
            this.busyIcons[i] = this.resourceMap.getIcon("StatusBar.busyIcons[" + i + "]");
        }
        this.busyIconTimer = new javax.swing.Timer(busyAnimationRate, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MainView.this.busyIconIndex = (MainView.this.busyIconIndex + 1) % MainView.this.busyIcons.length;
                MainView.this.statusAnimationLabel.setIcon(MainView.this.busyIcons[MainView.this.busyIconIndex]);
            }
        });
        this.idleIcon = this.resourceMap.getIcon("StatusBar.idleIcon");
        this.statusAnimationLabel.setIcon(this.idleIcon);
        this.progressBar.setVisible(false);
        TaskMonitor taskMonitor = new TaskMonitor(this.getApplication().getContext());
        taskMonitor.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                String propertyName = evt.getPropertyName();
                if ("started".equals(propertyName)) {
                    if (!MainView.this.busyIconTimer.isRunning()) {
                        MainView.this.statusAnimationLabel.setIcon(MainView.this.busyIcons[0]);
                        MainView.this.busyIconIndex = 0;
                        MainView.this.busyIconTimer.start();
                    }
                    MainView.this.progressBar.setVisible(true);
                    MainView.this.progressBar.setIndeterminate(true);
                } else if ("done".equals(propertyName)) {
                    MainView.this.busyIconTimer.stop();
                    MainView.this.statusAnimationLabel.setIcon(MainView.this.idleIcon);
                    MainView.this.progressBar.setVisible(false);
                    MainView.this.progressBar.setValue(0);
                } else if ("message".equals(propertyName)) {
                    String text = (String)evt.getNewValue();
                    MainView.this.statusMessageLabel.setText(text == null ? "" : text);
                    MainView.this.messageTimer.restart();
                } else if ("progress".equals(propertyName)) {
                    int value = (Integer)evt.getNewValue();
                    MainView.this.progressBar.setVisible(true);
                    MainView.this.progressBar.setIndeterminate(false);
                    MainView.this.progressBar.setValue(value);
                }
            }
        });
        this.t = new Timer();
        if (Preferences.userRoot().getBoolean("firstTimeRun1.3", true)) {
            this.t.schedule((TimerTask)new DoFirstTimeSetup(), 100L);
            Preferences.userRoot().putBoolean("firstTimeRun1.3", false);
        }
        this.t.schedule((TimerTask)new DoDelayedLoad(), 100L);
    }

    public void drivers() {
        String osName = System.getProperty("os.name").toUpperCase();
        if (!osName.contains("LINUX") && !osName.contains("WINDOWS 7")) {
            this.driverMgr = new DesktopDriversMgr();
            this.driverMgr.checkAndInstallDrivers();
        } else if (osName.contains("LINUX") && !new File("/opt/Palm/novacom/novacomd").exists()) {
            if (JOptionPane.showConfirmDialog(this.mainPanel, "It is required to download Novacom for Linux. Would you like to do so now?", "Novacom Required", 0, 3) == 0) {
                try {
                    Desktop.getDesktop().browse(new URI("https://cdn.downloads.palm.com/sdkdownloads/1.3.1.314/sdkBinaries/palm-novacom_1.0.46_i386.deb"));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            System.exit(0);
        }
    }

    private File[] loadList() {
        String base = WebOSQuickInstallApp.getDir();
        File f = new File(base);
        this.installDir = "Install";
        try {
            this.installDir = f.getCanonicalPath() + File.separatorChar + this.installDir;
        }
        catch (Exception e) {
            // empty catch block
        }
        File dir = new File(this.installDir);
        File[] files = f.listFiles();
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                try {
                    if (files[i].getCanonicalPath().equals(dir.getCanonicalPath()) && files[i].isDirectory()) {
                        return files[i].listFiles(new WebOSFileFilter());
                    }
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        dir.mkdir();
        return null;
    }

    private void displayList() {
        while (this.modTable.getRowCount() > 0) {
            this.modTable.removeRow(0);
        }
        for (int i = 0; i < this.installApps.size(); ++i) {
            this.displayLine(this.installApps.get(i));
        }
    }

    private void displayLine(File current) {
        String size = current.length() < 1000L ? " " + current.length() + " Bytes" : (current.length() >= 1000L && current.length() < 1024000L ? " " + (int)(current.length() / 1024L * 10L) / 10 + " KB" : " " + (int)(current.length() / 1024L / 1024L * 10L) / 10 + " MB");
        String type = current.getName().toLowerCase().endsWith(".ipk") ? " WebOS App IPK" : (current.getName().toLowerCase().endsWith(".patch") ? " WebOS Patch File" : (current.getName().toLowerCase().endsWith(".diff") ? " WebOS Diff File" : " Unknown File"));
        this.modTable.addRow(new Object[]{" " + this.getFilename(current), size, type});
    }

    private boolean isPatch(String s) {
        return s.endsWith(".patch") || s.endsWith(".diff");
    }

    private String getFilename(File f) {
        String result = f.getName();
        if (result.lastIndexOf("/") != -1) {
            result = result.substring(result.lastIndexOf("/") + 1);
        }
        if (result.lastIndexOf("\\") != -1) {
            result = result.substring(result.lastIndexOf("\\") + 1);
        }
        return result;
    }

    private void addFile(File f) {
        File newF;
        if ((f.getName().toLowerCase().endsWith(".ipk") || f.getName().toLowerCase().endsWith(".patch") || f.getName().toLowerCase().endsWith(".diff")) && !(newF = new File(this.installDir + File.separatorChar + this.getFilename(f))).exists()) {
            try {
                MainView.copyFile(f, newF);
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(this.mainPanel, e.getMessage());
            }
            this.installApps.add(newF);
            this.displayLine(newF);
        }
    }

    public static void copyFile(File in, File out) throws Exception {
        FileInputStream fis = new FileInputStream(in);
        FileOutputStream fos = new FileOutputStream(out);
        try {
            byte[] buf = new byte[1024];
            int i = 0;
            while ((i = fis.read(buf)) != -1) {
                fos.write(buf, 0, i);
            }
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (fis != null) {
                fis.close();
            }
            if (fos != null) {
                fos.close();
            }
        }
    }

    private void addDialog() {
        JFileChooser fc = new JFileChooser();
        WebOSChooseFilter filter = new WebOSChooseFilter();
        fc.setAcceptAllFileFilterUsed(false);
        fc.setFileFilter(filter);
        fc.setMultiSelectionEnabled(true);
        if (this.fcPath != null) {
            fc.setCurrentDirectory(new File(this.fcPath));
        }
        fc.setDialogTitle("");
        this.disableNewFolderButton(fc);
        if (fc.showDialog(this.getFrame(), "Select") == 0) {
            File[] files = fc.getSelectedFiles();
            if (files.length > 0) {
                try {
                    Preferences.userRoot().put("fcPath", files[0].getParentFile().getCanonicalPath());
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            for (int i = 0; i < files.length; ++i) {
                this.addFile(files[i]);
            }
        }
    }

    private void disableNewFolderButton(Container c) {
        int len = c.getComponentCount();
        for (int i = 0; i < len; ++i) {
            Component comp = c.getComponent(i);
            if (comp instanceof JButton) {
                JButton b = (JButton)comp;
                Icon icon = b.getIcon();
                if (icon == null || icon != UIManager.getIcon("FileChooser.newFolderIcon") && icon != UIManager.getIcon("FileChooser.upFolderIcon")) continue;
                b.setEnabled(false);
                continue;
            }
            if (!(comp instanceof Container)) continue;
            this.disableNewFolderButton((Container)comp);
        }
    }

    private void removeFile() {
        int[] rows = this.jTable1.getSelectedRows();
        File[] files = new File[rows.length];
        for (int i = 0; i < rows.length; ++i) {
            files[i] = this.installApps.get(rows[i]);
        }
        for (int j = 0; j < files.length; ++j) {
            this.removeLine(files[j]);
        }
    }

    private void removeLine(File f) {
        this.installApps.remove(f);
        int row = this.findRowIndex(" " + this.getFilename(f));
        this.modTable.removeRow(row);
        if (!f.delete()) {
            System.gc();
            f.delete();
        }
    }

    private int findListIndex(String name) {
        int result = -1;
        for (int i = 0; i < this.installApps.size() && !this.getFilename(this.installApps.get(i)).equalsIgnoreCase(name); ++i) {
        }
        return result;
    }

    private int findRowIndex(String name) {
        int result = -1;
        for (int i = 0; i < this.jTable1.getRowCount(); ++i) {
            String s = (String)this.modTable.getValueAt(i, 0);
            if (!name.equals(s)) continue;
            result = i;
        }
        return result;
    }

    private void cleanup() {
        while (!this.transfer.installedList.isEmpty()) {
            File f = this.transfer.installedList.get(0);
            if (this.installApps.contains(f)) {
                this.removeLine(f);
            }
            this.transfer.installedList.remove(0);
        }
    }

    @Action
    public void showOptions() {
        JFrame mainFrame = WebOSQuickInstallApp.getApplication().getMainFrame();
        this.options = new Options(mainFrame);
        this.options.setLocationRelativeTo(mainFrame);
        if (!this.options.dontOpen) {
            WebOSQuickInstallApp.getApplication().show(this.options);
        }
    }

    @Action
    public void showManagement() {
        JFrame mainFrame = WebOSQuickInstallApp.getApplication().getMainFrame();
        this.manage = new DeviceManagement((Frame)mainFrame, this.resourceMap);
        this.manage.setLocationRelativeTo(mainFrame);
        if (!this.manage.dontOpen) {
            WebOSQuickInstallApp.getApplication().show(this.manage);
        }
    }

    @Action
    public void showTweaks() {
        if (!Preferences.userRoot().getBoolean("tweakWarningShown", false)) {
            JOptionPane.showMessageDialog(this.mainPanel, "<html><body width=\"400px\">WARNING: These tweaks are based on patches submitted to www.webos-internals.org (full patch credits can be found there) and are current for your version of webOS. On various tweaks, it may appear like your device has reset, but don't worry, it hasn't; it's just rebooting the system gui (a luna restart). As always with these kinds of things, use at your own risk. You will not see this message again.</body>");
            Preferences.userRoot().putBoolean("tweakWarningShown", true);
        }
        JFrame mainFrame = WebOSQuickInstallApp.getApplication().getMainFrame();
        this.tweaks = new Tweaks(mainFrame);
        this.tweaks.setLocationRelativeTo(mainFrame);
        if (!this.tweaks.dontOpen) {
            WebOSQuickInstallApp.getApplication().show(this.tweaks);
        }
    }

    @Action
    public void showUsage() {
        if (this.usage == null) {
            JFrame mainFrame = WebOSQuickInstallApp.getApplication().getMainFrame();
            this.usage = new Usage(mainFrame);
            this.usage.setLocationRelativeTo(mainFrame);
        }
        WebOSQuickInstallApp.getApplication().show(this.usage);
    }

    @Action
    public void showDisclaimer() {
        JOptionPane.showMessageDialog(this.mainPanel, "<html><body width=\"400px\">This program is intended for use with WebOS applications that are in-testing, which under section 4.2 of the Palm SDK License Agreement allows for such unapproved applications to be installed on Palm devices.  By using this program, the user understands that webOS applications installed may be dangerous and have not been approved for safety or stability by Palm Inc and could void your device's warranty.  Installing webOS applications are done so at your own risk and neither the developer of WebOS Quick Install, nor Palm Inc can be held liable.</body>", "DISCLAIMER", 1);
    }

    @Action
    public void showAboutBox() {
        if (this.aboutBox == null) {
            JFrame mainFrame = WebOSQuickInstallApp.getApplication().getMainFrame();
            this.aboutBox = new AboutBox(mainFrame);
            this.aboutBox.setLocationRelativeTo(mainFrame);
        }
        WebOSQuickInstallApp.getApplication().show(this.aboutBox);
    }

    @Action
    public void openRepository() {
        JFrame mainFrame = WebOSQuickInstallApp.getApplication().getMainFrame();
        this.repository = new IpkgFeed(mainFrame);
        this.repository.setLocationRelativeTo(mainFrame);
        if (!this.repository.dontOpen) {
            WebOSQuickInstallApp.getApplication().show(this.repository);
            File[] files = this.loadList();
            if (files != null) {
                this.installApps = new ArrayList<File>(Arrays.asList(files));
                this.displayList();
            } else {
                this.installApps = new ArrayList(0);
            }
        }
    }

    private void showTransfer() {
        JFrame mainFrame = WebOSQuickInstallApp.getApplication().getMainFrame();
        this.transfer = new Transfer((Frame)mainFrame, this.installApps);
        this.transfer.setLocationRelativeTo(mainFrame);
        WebOSQuickInstallApp.getApplication().show(this.transfer);
    }

    @Action
    public void showSend() {
        JFrame mainFrame = WebOSQuickInstallApp.getApplication().getMainFrame();
        this.custTransfer = new SendFile(mainFrame);
        this.custTransfer.setLocationRelativeTo(mainFrame);
        WebOSQuickInstallApp.getApplication().show(this.custTransfer);
    }

    @Action
    public void showReceive() {
        JFrame mainFrame = WebOSQuickInstallApp.getApplication().getMainFrame();
        this.custTransfer = new ReceiveFile(mainFrame);
        this.custTransfer.setLocationRelativeTo(mainFrame);
        WebOSQuickInstallApp.getApplication().show(this.custTransfer);
    }

    @Action
    public void showDelete() {
        JFrame mainFrame = WebOSQuickInstallApp.getApplication().getMainFrame();
        this.custTransfer = new DeleteFile(mainFrame);
        this.custTransfer.setLocationRelativeTo(mainFrame);
        WebOSQuickInstallApp.getApplication().show(this.custTransfer);
    }

    @Action
    public void showCommandline() {
        JFrame mainFrame = WebOSQuickInstallApp.getApplication().getMainFrame();
        this.cmdline = new LinuxCommandline(mainFrame);
        this.cmdline.setLocationRelativeTo(mainFrame);
        if (!this.cmdline.dontOpen) {
            WebOSQuickInstallApp.getApplication().show(this.cmdline);
        }
    }

    private void initComponents() {
        this.mainPanel = new ImagePanel(this.bg);
        this.jLayeredPane1 = new JLayeredPane();
        this.jButton2 = new JButton();
        this.jButton3 = new JButton();
        this.jLayeredPane3 = new JLayeredPane();
        this.jLabel1 = new JLabel();
        this.jLayeredPane7 = new JLayeredPane();
        this.jScrollPane2 = new JScrollPane();
        this.jTable1 = new JTable();
        this.jButton5 = new JButton();
        this.jButton1 = new JButton();
        this.jButton4 = new JButton();
        this.menuBar = new JMenuBar();
        JMenu fileMenu = new JMenu();
        this.jMenuItem1 = new JMenuItem();
        this.jMenuItem4 = new JMenuItem();
        this.jSeparator2 = new JSeparator();
        JMenuItem exitMenuItem = new JMenuItem();
        this.jMenu1 = new JMenu();
        this.jMenuItem6 = new JMenuItem();
        this.jMenuItem7 = new JMenuItem();
        this.jMenuItem9 = new JMenuItem();
        this.jSeparator3 = new JSeparator();
        this.jMenuItem5 = new JMenuItem();
        this.jMenuItem10 = new JMenuItem();
        this.jMenuItem8 = new JMenuItem();
        this.jSeparator1 = new JSeparator();
        this.jMenuItem11 = new JMenuItem();
        JMenu helpMenu = new JMenu();
        this.jMenuItem3 = new JMenuItem();
        this.jMenuItem2 = new JMenuItem();
        JMenuItem aboutMenuItem = new JMenuItem();
        this.statusPanel = new JPanel();
        JSeparator statusPanelSeparator = new JSeparator();
        this.statusMessageLabel = new JLabel();
        this.statusAnimationLabel = new JLabel();
        this.progressBar = new JProgressBar();
        this.mainPanel.setBackground(null);
        this.mainPanel.setName("mainPanel");
        this.mainPanel.setOpaque(false);
        this.mainPanel.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                MainView.this.mainPanelMouseClicked(evt);
            }
        });
        this.mainPanel.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent evt) {
                MainView.this.mainPanelKeyPressed(evt);
            }

            public void keyReleased(KeyEvent evt) {
                MainView.this.mainPanelKeyReleased(evt);
            }

            public void keyTyped(KeyEvent evt) {
                MainView.this.mainPanelKeyTyped(evt);
            }
        });
        this.jLayeredPane1.setName("jLayeredPane1");
        this.jLayeredPane1.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent evt) {
                MainView.this.jLayeredPane1KeyPressed(evt);
            }
        });
        ResourceMap resourceMap = Application.getInstance(WebOSQuickInstallApp.class).getContext().getResourceMap(MainView.class);
        this.jButton2.setIcon(resourceMap.getIcon("jButton2.icon"));
        this.jButton2.setText(resourceMap.getString("jButton2.text", new Object[0]));
        this.jButton2.setBorderPainted(false);
        this.jButton2.setContentAreaFilled(false);
        this.jButton2.setName("jButton2");
        this.jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainView.this.jButton2ActionPerformed(evt);
            }
        });
        this.jButton2.setBounds(20, 261, 130, 60);
        this.jLayeredPane1.add((Component)this.jButton2, JLayeredPane.DEFAULT_LAYER);
        this.jButton3.setBackground(resourceMap.getColor("jButton3.background"));
        this.jButton3.setFont(resourceMap.getFont("jButton3.font"));
        this.jButton3.setText(resourceMap.getString("jButton3.text", new Object[0]));
        this.jButton3.setHorizontalTextPosition(0);
        this.jButton3.setName("jButton3");
        this.jButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainView.this.jButton3ActionPerformed(evt);
            }
        });
        this.jButton3.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent evt) {
                MainView.this.jButton3KeyPressed(evt);
            }
        });
        this.jButton3.setBounds(253, 270, 140, 33);
        this.jLayeredPane1.add((Component)this.jButton3, JLayeredPane.DEFAULT_LAYER);
        this.jLayeredPane3.setName("jLayeredPane3");
        this.jLayeredPane3.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent evt) {
                MainView.this.jLayeredPane3KeyPressed(evt);
            }
        });
        this.jLabel1.setIcon(resourceMap.getIcon("jLabel1.icon"));
        this.jLabel1.setText(resourceMap.getString("jLabel1.text", new Object[0]));
        this.jLabel1.setName("jLabel1");
        this.jLabel1.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                MainView.this.jLabel1MouseClicked(evt);
            }
        });
        this.jLabel1.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent evt) {
                MainView.this.jLabel1KeyPressed(evt);
            }
        });
        this.jLabel1.setBounds(20, 10, 150, 160);
        this.jLayeredPane3.add((Component)this.jLabel1, JLayeredPane.DEFAULT_LAYER);
        this.jLayeredPane3.setBounds(470, 160, 170, 180);
        this.jLayeredPane1.add((Component)this.jLayeredPane3, JLayeredPane.DEFAULT_LAYER);
        this.jLayeredPane7.setBorder(BorderFactory.createTitledBorder(new LineBorder(resourceMap.getColor("jLayeredPane7.border.border.lineColor"), 1, true), resourceMap.getString("jLayeredPane7.border.title", new Object[0])));
        this.jLayeredPane7.setName("jLayeredPane7");
        this.jLayeredPane7.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent evt) {
                MainView.this.jLayeredPane7KeyPressed(evt);
            }
        });
        this.jScrollPane2.setAutoscrolls(true);
        this.jScrollPane2.setName("jScrollPane2");
        this.jScrollPane2.setPreferredSize(new Dimension(485, 191));
        this.jTable1.setBackground(resourceMap.getColor("tableFiles.background"));
        this.jTable1.setFont(resourceMap.getFont("tableFiles.font"));
        this.jTable1.setModel(new DefaultTableModel(new Object[0][], new String[]{"Name", "Size", "Type"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{String.class, String.class, String.class};
                this.canEdit = new boolean[]{false, false, false};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.jTable1.setFillsViewportHeight(true);
        this.jTable1.setFocusable(false);
        this.jTable1.setMaximumSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
        this.jTable1.setMinimumSize(new Dimension(45, 45));
        this.jTable1.setName("tableFiles");
        this.jTable1.setRowHeight(20);
        this.jTable1.setSelectionMode(2);
        this.jTable1.getTableHeader().setReorderingAllowed(false);
        this.jTable1.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                MainView.this.jTable1MouseClicked(evt);
            }
        });
        this.jTable1.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent evt) {
                MainView.this.jTable1KeyPressed(evt);
            }
        });
        this.jScrollPane2.setViewportView(this.jTable1);
        this.jTable1.getColumnModel().getColumn(0).setResizable(false);
        this.jTable1.getColumnModel().getColumn(0).setPreferredWidth(350);
        this.jTable1.getColumnModel().getColumn(0).setHeaderValue(resourceMap.getString("tableFiles.columnModel.title0", new Object[0]));
        this.jTable1.getColumnModel().getColumn(1).setResizable(false);
        this.jTable1.getColumnModel().getColumn(1).setPreferredWidth(125);
        this.jTable1.getColumnModel().getColumn(1).setHeaderValue(resourceMap.getString("tableFiles.columnModel.title1", new Object[0]));
        this.jTable1.getColumnModel().getColumn(2).setResizable(false);
        this.jTable1.getColumnModel().getColumn(2).setPreferredWidth(250);
        this.jTable1.getColumnModel().getColumn(2).setHeaderValue(resourceMap.getString("tableFiles.columnModel.title2", new Object[0]));
        this.jScrollPane2.setBounds(20, 30, 485, 191);
        this.jLayeredPane7.add((Component)this.jScrollPane2, JLayeredPane.DEFAULT_LAYER);
        ApplicationActionMap actionMap = Application.getInstance(WebOSQuickInstallApp.class).getContext().getActionMap(MainView.class, this);
        this.jButton5.setAction(actionMap.get("openRepository"));
        this.jButton5.setBackground(resourceMap.getColor("jButton5.background"));
        this.jButton5.setIcon(resourceMap.getIcon("jButton5.icon"));
        this.jButton5.setIconTextGap(0);
        this.jButton5.setMargin(new Insets(0, 0, 0, 0));
        this.jButton5.setMaximumSize(new Dimension(36, 33));
        this.jButton5.setMinimumSize(new Dimension(36, 33));
        this.jButton5.setName("jButton5");
        this.jButton5.setPreferredSize(new Dimension(36, 33));
        this.jButton5.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainView.this.jButton5ActionPerformed(evt);
            }
        });
        this.jButton5.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent evt) {
                MainView.this.jButton5KeyPressed(evt);
            }
        });
        this.jButton5.setBounds(520, 120, 40, 30);
        this.jLayeredPane7.add((Component)this.jButton5, JLayeredPane.DEFAULT_LAYER);
        this.jButton1.setBackground(resourceMap.getColor("jButton1.background"));
        this.jButton1.setIcon(resourceMap.getIcon("jButton1.icon"));
        this.jButton1.setText(resourceMap.getString("jButton1.text", new Object[0]));
        this.jButton1.setIconTextGap(0);
        this.jButton1.setMargin(new Insets(0, 0, 0, 0));
        this.jButton1.setMaximumSize(new Dimension(36, 33));
        this.jButton1.setMinimumSize(new Dimension(36, 33));
        this.jButton1.setName("jButton1");
        this.jButton1.setPreferredSize(new Dimension(36, 33));
        this.jButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainView.this.jButton1ActionPerformed(evt);
            }
        });
        this.jButton1.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent evt) {
                MainView.this.jButton1KeyPressed(evt);
            }
        });
        this.jButton1.setBounds(520, 30, 40, 30);
        this.jLayeredPane7.add((Component)this.jButton1, JLayeredPane.DEFAULT_LAYER);
        this.jButton4.setBackground(resourceMap.getColor("jButton4.background"));
        this.jButton4.setIcon(resourceMap.getIcon("jButton4.icon"));
        this.jButton4.setIconTextGap(0);
        this.jButton4.setMargin(new Insets(0, 0, 0, 0));
        this.jButton4.setMaximumSize(new Dimension(36, 33));
        this.jButton4.setMinimumSize(new Dimension(36, 33));
        this.jButton4.setName("jButton4");
        this.jButton4.setPreferredSize(new Dimension(36, 33));
        this.jButton4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainView.this.jButton4ActionPerformed(evt);
            }
        });
        this.jButton4.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent evt) {
                MainView.this.jButton4KeyPressed(evt);
            }
        });
        this.jButton4.setBounds(520, 70, 40, 30);
        this.jLayeredPane7.add((Component)this.jButton4, JLayeredPane.DEFAULT_LAYER);
        this.jLayeredPane7.setBounds(10, 10, 620, 240);
        this.jLayeredPane1.add((Component)this.jLayeredPane7, JLayeredPane.DEFAULT_LAYER);
        GroupLayout mainPanelLayout = new GroupLayout(this.mainPanel);
        this.mainPanel.setLayout(mainPanelLayout);
        mainPanelLayout.setHorizontalGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLayeredPane1, -1, 644, Short.MAX_VALUE));
        mainPanelLayout.setVerticalGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, mainPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.jLayeredPane1, -1, 346, Short.MAX_VALUE)));
        this.menuBar.setName("menuBar");
        fileMenu.setText(resourceMap.getString("fileMenu.text", new Object[0]));
        fileMenu.setName("fileMenu");
        this.jMenuItem1.setText(resourceMap.getString("jMenuItem1.text", new Object[0]));
        this.jMenuItem1.setName("jMenuItem1");
        this.jMenuItem1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainView.this.jMenuItem1ActionPerformed(evt);
            }
        });
        fileMenu.add(this.jMenuItem1);
        this.jMenuItem4.setAction(actionMap.get("showOptions"));
        this.jMenuItem4.setText(resourceMap.getString("jMenuItem4.text", new Object[0]));
        this.jMenuItem4.setName("jMenuItem4");
        fileMenu.add(this.jMenuItem4);
        this.jSeparator2.setName("jSeparator2");
        fileMenu.add(this.jSeparator2);
        exitMenuItem.setAction(actionMap.get("quit"));
        exitMenuItem.setName("exitMenuItem");
        exitMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainView.this.exitMenuItemActionPerformed(evt);
            }
        });
        fileMenu.add(exitMenuItem);
        this.menuBar.add(fileMenu);
        this.jMenu1.setText(resourceMap.getString("jMenu1.text", new Object[0]));
        this.jMenu1.setName("jMenu1");
        this.jMenuItem6.setAction(actionMap.get("showSend"));
        this.jMenuItem6.setText(resourceMap.getString("jMenuItem6.text", new Object[0]));
        this.jMenuItem6.setName("jMenuItem6");
        this.jMenu1.add(this.jMenuItem6);
        this.jMenuItem7.setAction(actionMap.get("showReceive"));
        this.jMenuItem7.setText(resourceMap.getString("jMenuItem7.text", new Object[0]));
        this.jMenuItem7.setName("jMenuItem7");
        this.jMenu1.add(this.jMenuItem7);
        this.jMenuItem9.setAction(actionMap.get("showDelete"));
        this.jMenuItem9.setText(resourceMap.getString("jMenuItem9.text", new Object[0]));
        this.jMenuItem9.setName("jMenuItem9");
        this.jMenu1.add(this.jMenuItem9);
        this.jSeparator3.setName("jSeparator3");
        this.jMenu1.add(this.jSeparator3);
        this.jMenuItem5.setAction(actionMap.get("showManagement"));
        this.jMenuItem5.setText(resourceMap.getString("jMenuItem5.text", new Object[0]));
        this.jMenuItem5.setName("jMenuItem5");
        this.jMenu1.add(this.jMenuItem5);
        this.jMenuItem10.setText(resourceMap.getString("jMenuItem10.text", new Object[0]));
        this.jMenuItem10.setName("jMenuItem10");
        this.jMenuItem10.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainView.this.jMenuItem10ActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.jMenuItem10);
        this.jMenuItem8.setAction(actionMap.get("showTweaks"));
        this.jMenuItem8.setText(resourceMap.getString("jMenuItem8.text", new Object[0]));
        this.jMenuItem8.setName("jMenuItem8");
        this.jMenu1.add(this.jMenuItem8);
        this.jSeparator1.setName("jSeparator1");
        this.jMenu1.add(this.jSeparator1);
        this.jMenuItem11.setAction(actionMap.get("showCommandline"));
        this.jMenuItem11.setText(resourceMap.getString("jMenuItem11.text", new Object[0]));
        this.jMenuItem11.setName("jMenuItem11");
        this.jMenu1.add(this.jMenuItem11);
        this.menuBar.add(this.jMenu1);
        helpMenu.setText(resourceMap.getString("helpMenu.text", new Object[0]));
        helpMenu.setName("helpMenu");
        this.jMenuItem3.setAction(actionMap.get("showUsage"));
        this.jMenuItem3.setText(resourceMap.getString("jMenuItem3.text", new Object[0]));
        this.jMenuItem3.setName("jMenuItem3");
        helpMenu.add(this.jMenuItem3);
        this.jMenuItem2.setAction(actionMap.get("showDisclaimer"));
        this.jMenuItem2.setText(resourceMap.getString("jMenuItem2.text", new Object[0]));
        this.jMenuItem2.setName("jMenuItem2");
        helpMenu.add(this.jMenuItem2);
        aboutMenuItem.setAction(actionMap.get("showAboutBox"));
        aboutMenuItem.setText(resourceMap.getString("aboutMenuItem.text", new Object[0]));
        aboutMenuItem.setName("aboutMenuItem");
        aboutMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainView.this.aboutMenuItemActionPerformed(evt);
            }
        });
        helpMenu.add(aboutMenuItem);
        this.menuBar.add(helpMenu);
        this.statusPanel.setName("statusPanel");
        statusPanelSeparator.setName("statusPanelSeparator");
        this.statusMessageLabel.setName("statusMessageLabel");
        this.statusAnimationLabel.setHorizontalAlignment(2);
        this.statusAnimationLabel.setName("statusAnimationLabel");
        this.progressBar.setName("progressBar");
        GroupLayout statusPanelLayout = new GroupLayout(this.statusPanel);
        this.statusPanel.setLayout(statusPanelLayout);
        statusPanelLayout.setHorizontalGroup(statusPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(statusPanelSeparator, -1, 644, Short.MAX_VALUE).addGroup(statusPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.statusMessageLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 474, Short.MAX_VALUE).addComponent(this.progressBar, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.statusAnimationLabel).addContainerGap()));
        statusPanelLayout.setVerticalGroup(statusPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(statusPanelLayout.createSequentialGroup().addComponent(statusPanelSeparator, -2, 2, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(statusPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.statusMessageLabel).addComponent(this.statusAnimationLabel).addComponent(this.progressBar, -2, -1, -2)).addGap(3, 3, 3)));
        this.setComponent(this.mainPanel);
        this.setMenuBar(this.menuBar);
        this.setStatusBar(this.statusPanel);
    }

    private void mainPanelMouseClicked(MouseEvent evt) {
        int[] rows = this.jTable1.getSelectedRows();
        this.mainPanel.requestFocus();
        if (rows.length > 0) {
            this.jTable1.removeRowSelectionInterval(rows[0], rows[rows.length - 1]);
        }
    }

    private void jMenuItem1ActionPerformed(ActionEvent evt) {
        this.addDialog();
    }

    private void mainPanelKeyTyped(KeyEvent evt) {
    }

    private void mainPanelKeyReleased(KeyEvent evt) {
        if (evt.getKeyCode() == 127) {
            this.removeFile();
        }
    }

    private void jButton3KeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 127) {
            this.removeFile();
        }
    }

    private void jButton3ActionPerformed(ActionEvent evt) {
        if (this.modTable.getRowCount() > 0) {
            this.showTransfer();
            this.cleanup();
        }
        this.mainPanel.requestFocus();
    }

    private void aboutMenuItemActionPerformed(ActionEvent evt) {
    }

    private void jButton1KeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 127) {
            this.removeFile();
        }
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        this.addDialog();
        this.mainPanel.requestFocus();
    }

    private void jTable1KeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 127) {
            this.removeFile();
        }
    }

    private void jTable1MouseClicked(MouseEvent evt) {
    }

    private void mainPanelKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 127) {
            this.removeFile();
        }
    }

    private void jLayeredPane7KeyPressed(KeyEvent evt) {
        this.mainPanel.requestFocus();
    }

    private void jLayeredPane1KeyPressed(KeyEvent evt) {
        this.mainPanel.requestFocus();
    }

    private void jLabel1KeyPressed(KeyEvent evt) {
        this.mainPanel.requestFocus();
    }

    private void jLayeredPane3KeyPressed(KeyEvent evt) {
        this.mainPanel.requestFocus();
    }

    private void jButton4ActionPerformed(ActionEvent evt) {
        this.removeFile();
        this.mainPanel.requestFocus();
    }

    private void jButton4KeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 127) {
            this.removeFile();
        }
    }

    private void jButton5ActionPerformed(ActionEvent evt) {
        this.mainPanel.requestFocus();
    }

    private void jButton5KeyPressed(KeyEvent evt) {
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        try {
            Desktop.getDesktop().browse(new URI("http://www.precentral.net/homebrew-apps?order=created&sort=desc"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void jLabel1MouseClicked(MouseEvent evt) {
    }

    private void exitMenuItemActionPerformed(ActionEvent evt) {
    }

    private void jMenuItem10ActionPerformed(ActionEvent evt) {
        JFrame mainFrame = WebOSQuickInstallApp.getApplication().getMainFrame();
        this.themer = new ThemeChooser(mainFrame);
        this.themer.setLocationRelativeTo(mainFrame);
        if (!this.themer.dontOpen) {
            WebOSQuickInstallApp.getApplication().show(this.themer);
        }
    }

    class WebOSFileFilter
    implements FileFilter {
        private final String[] okFileExtensions = new String[]{".ipk", ".diff", ".patch"};

        WebOSFileFilter() {
        }

        public boolean accept(File file) {
            for (String extension : this.okFileExtensions) {
                if (!file.getName().toLowerCase().endsWith(extension)) continue;
                return true;
            }
            return false;
        }
    }

    class WebOSChooseFilter
    extends javax.swing.filechooser.FileFilter {
        private final String[] okFileExtensions = new String[]{".ipk", ".diff", ".patch"};

        WebOSChooseFilter() {
        }

        public boolean accept(File f) {
            for (String extension : this.okFileExtensions) {
                if (!f.getName().toLowerCase().endsWith(extension) && !f.isDirectory()) continue;
                return true;
            }
            return false;
        }

        public String getDescription() {
            return "WebOS Installables (*.ipk, *.patch, *.diff)";
        }
    }

    class DoFirstTimeSetup
    extends TimerTask {
        DoFirstTimeSetup() {
        }

        public void run() {
            String s = (String)JOptionPane.showInputDialog(null, "Which device would you like to use (this can be changed later in Options):", "First-time Setup", 1, null, new Object[]{"Emulator", "USB Device"}, "USB Device");
            Preferences.userRoot().putBoolean("useEmulator", s.equalsIgnoreCase("Emulator"));
            MainView.this.drivers();
        }
    }

    class DoDelayedLoad
    extends TimerTask {
        DoDelayedLoad() {
        }

        public void run() {
            if (Versioning.isTimeToCheck()) {
                Versioning.checkForUpdates();
            }
        }
    }

    class ImagePanel
    extends JPanel {
        private Image img;

        public ImagePanel(String img) {
            this(new ImageIcon(img).getImage());
        }

        public ImagePanel(Image img) {
            this.img = img;
            Dimension size = new Dimension(img.getWidth(null), img.getHeight(null));
            this.setPreferredSize(size);
            this.setMinimumSize(size);
            this.setMaximumSize(size);
            this.setSize(size);
            this.setLayout(null);
        }

        public void paintComponent(Graphics g) {
            g.drawImage(this.img, 0, 0, null);
        }
    }
}

