/*
 * Decompiled with CFR 0.152.
 */
package ca.canucksoftware;

import ca.canucksoftware.AppInfoEntry;
import ca.canucksoftware.PackageFeed;
import com.palm.nova.installer.core.DeviceInfo;
import com.palm.novacom.INovacomController;
import com.palm.novacom.INovacomDevice;
import com.palm.novacom.INovacomStream;
import com.palm.novacom.NovaDeviceInfo;
import com.palm.novacom.Novacom;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.prefs.Preferences;
import javax.swing.JOptionPane;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NovacomConnection {
    private static INovacomDevice defaultDevice;
    private static Novacom Novacom;
    private NovaDeviceInfo[] devices = null;
    private INovacomController controller = Novacom.getController();
    public String offlineRoot = "/media/cryptofs/apps";
    public boolean connected = false;
    public boolean restartJava = false;
    public boolean restartLuna = false;
    public boolean restartDevice;
    private String version = null;

    public boolean connect(boolean surpressError1) {
        this.connected = this.findDevices(surpressError1);
        return this.connected;
    }

    private boolean findDevices(boolean surpressError1) {
        boolean success;
        block5: {
            success = false;
            try {
                this.devices = !Preferences.userRoot().getBoolean("useEmulator", false) ? this.controller.getDeviceListOnUsb() : this.controller.getDeviceList();
            }
            catch (Exception e) {
                if (surpressError1) break block5;
                JOptionPane.showMessageDialog(null, "ERROR 1:\n\n" + e.getMessage());
            }
        }
        if (this.devices != null && this.devices.length > 0) {
            success = this.connectToDevice();
        } else if (!surpressError1) {
            JOptionPane.showMessageDialog(null, "ERROR:\n\nNo device found.");
        }
        return success;
    }

    private boolean connectToDevice() {
        boolean success = false;
        try {
            defaultDevice = this.controller.connectToDevice(this.devices[0]);
            INovacomStream ins = defaultDevice.runProgram("/bin/mount", new String[]{"-o", "remount,rw", "/"});
            String msg = this.getMessage(ins);
            int returnCode = this.closeStream(ins);
            if (!Preferences.userRoot().getBoolean("useEmulator", false) && returnCode != 0) {
                JOptionPane.showMessageDialog(null, msg);
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "ERROR 2:\n\n" + e.getMessage());
        }
        if (defaultDevice != null) {
            success = true;
        } else {
            JOptionPane.showMessageDialog(null, "ERROR:\n\nUnable to connect.");
        }
        return success;
    }

    public boolean makeDir(String dir) {
        return this.makeDir(dir, false);
    }

    public boolean makeDir(String dir, boolean showError) {
        boolean success;
        block3: {
            success = false;
            if (this.connected) {
                try {
                    INovacomStream ins = defaultDevice.runProgram("/bin/mkdir", new String[]{"-p", dir});
                    String msg = this.getMessage(ins);
                    int returnCode = this.closeStream(ins);
                    success = true;
                }
                catch (Exception e) {
                    if (!showError) break block3;
                    JOptionPane.showMessageDialog(null, "ERROR 3:\n\n" + e.getMessage());
                }
            }
        }
        return success;
    }

    public boolean createFile(String path) {
        boolean success = false;
        if (this.connected) {
            try {
                INovacomStream ins = defaultDevice.runProgram("/bin/touch", new String[]{path});
                String msg = this.getMessage(ins);
                int returnCode = this.closeStream(ins);
                success = true;
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(null, "ERROR 3.5:\n\n" + e.getMessage());
            }
        }
        return success;
    }

    public List<String> listInstalled() {
        ArrayList<String> result = new ArrayList<String>();
        if (this.connected) {
            try {
                INovacomStream ins = defaultDevice.runProgram("/usr/bin/ipkg", new String[]{"-o", this.offlineRoot, "list_installed"});
                String line = ins.readLine();
                while (line != null && line.trim().length() != 0) {
                    String[] tokens = line.trim().split(" ");
                    result.add(tokens[0]);
                    line = ins.readLine();
                }
                int returnCode = this.closeStream(ins);
                if (returnCode != 0) {
                    result.clear();
                }
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(null, "ERROR 20:\n\n" + e.getMessage());
            }
        }
        return result;
    }

    public boolean fileExists(String file) {
        boolean result = false;
        if (this.connected) {
            try {
                INovacomStream ins = defaultDevice.runProgram("/bin/ls", new String[]{"-d", file});
                this.getMessage(ins);
                int returnCode = this.closeStream(ins);
                result = returnCode == 0;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return result;
    }

    private String md5sum(String file) {
        String result = "";
        if (this.connected) {
            try {
                INovacomStream ins = defaultDevice.runProgram("/usr/bin/md5sum", new String[]{file});
                result = this.getMessage(ins).split("\\s+")[0];
                int returnCode = this.closeStream(ins);
                if (returnCode != 0) {
                    result = "";
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return result;
    }

    public boolean runCmd(String app, String[] params) {
        return this.runCmd(app, params, true);
    }

    public boolean runCmd(String app, String[] params, boolean showError) {
        boolean success;
        block5: {
            success = false;
            if (this.connected) {
                try {
                    INovacomStream ins = defaultDevice.runProgram(app, params);
                    String msg = this.getMessage(ins);
                    int returnCode = this.closeStream(ins);
                    if (returnCode != 0 && showError) {
                        JOptionPane.showMessageDialog(null, "ERROR: " + msg);
                    } else {
                        success = true;
                    }
                }
                catch (Exception e) {
                    if (!showError) break block5;
                    JOptionPane.showMessageDialog(null, "ERROR 20:\n\n" + e.getMessage());
                }
            }
        }
        return success;
    }

    public boolean sendFile(File src, String dest) {
        byte[] buffer = new byte[65536];
        FileInputStream input = null;
        INovacomStream stream = null;
        boolean success = false;
        if (this.connected) {
            try {
                input = new FileInputStream(src);
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(null, "ERROR 4:\n\n" + e.getMessage());
            }
            if (input != null) {
                try {
                    stream = defaultDevice.putFile(dest);
                }
                catch (Exception e2) {
                    JOptionPane.showMessageDialog(null, "ERROR 5:\n\n" + e2.getMessage());
                }
                if (stream != null) {
                    try {
                        int count = 0;
                        while ((count = input.read(buffer)) != -1) {
                            stream.write(buffer, 0, count);
                        }
                        stream.flush();
                        stream.closeInput();
                        stream.closeOutput();
                        try {
                            stream.waitForReturnCode();
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        stream.close();
                        input.close();
                        success = true;
                    }
                    catch (Exception e3) {
                        JOptionPane.showMessageDialog(null, "ERROR 6:\n\n" + e3.getMessage());
                    }
                }
            }
        }
        return success;
    }

    public INovacomStream putFile(String file) {
        INovacomStream stream = null;
        if (this.connected) {
            try {
                stream = defaultDevice.putFile(file);
            }
            catch (Exception e2) {
                stream = null;
            }
        }
        return stream;
    }

    public INovacomStream getFile(String file) {
        INovacomStream stream = null;
        if (this.connected) {
            try {
                stream = defaultDevice.getFile(file);
            }
            catch (Exception e2) {
                stream = null;
            }
        }
        return stream;
    }

    public boolean receiveFile(String src, File dest, boolean surpressError) {
        byte[] buffer = new byte[65536];
        FileOutputStream output = null;
        INovacomStream stream = null;
        boolean success = false;
        if (this.connected) {
            try {
                output = new FileOutputStream(dest);
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(null, "ERROR 7:\n\n" + e.getMessage());
            }
            if (output != null) {
                block12: {
                    try {
                        stream = defaultDevice.getFile(src);
                    }
                    catch (Exception e2) {
                        stream = null;
                        if (surpressError) break block12;
                        JOptionPane.showMessageDialog(null, "ERROR 8:\n\n" + e2.getMessage());
                    }
                }
                if (stream != null) {
                    try {
                        int count = 0;
                        while ((count = stream.read(buffer)) > 0) {
                            output.write(buffer, 0, count);
                        }
                        output.flush();
                        stream.closeInput();
                        stream.closeOutput();
                        try {
                            stream.waitForReturnCode();
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        stream.close();
                        output.close();
                        success = true;
                    }
                    catch (Exception e3) {
                        JOptionPane.showMessageDialog(null, "ERROR 9:\n\n" + e3.getMessage());
                    }
                }
            }
        }
        return success;
    }

    public String getWebOSVersion() {
        INovacomStream stream = null;
        if (this.version == null || this.version.equalsIgnoreCase("unknown")) {
            this.version = "unknown";
            if (this.connected) {
                try {
                    stream = defaultDevice.getFile("/etc/palm-build-info");
                }
                catch (Exception e) {
                    stream = null;
                }
                if (stream != null) {
                    try {
                        String line = stream.readLine();
                        while (line != null && line.trim().length() > 0) {
                            String[] tokens;
                            if (line.startsWith("PRODUCT_VERSION_STRING=") && (tokens = (line = line.trim()).substring(line.indexOf("=")).split(" ")).length >= 3) {
                                this.version = tokens[2];
                            }
                            line = stream.readLine();
                        }
                        this.closeStream(stream);
                        if (this.version.equalsIgnoreCase("Albacore")) {
                            this.version = "1.4";
                        }
                    }
                    catch (Exception e3) {
                        this.version = "unknown";
                    }
                }
            }
        }
        return this.version;
    }

    public String getWebOSArch() {
        INovacomStream stream = null;
        String result = "????";
        if (this.connected) {
            try {
                stream = defaultDevice.runProgram("/bin/uname", new String[]{"-a"});
            }
            catch (Exception e) {
                result = null;
            }
            if (stream != null) {
                try {
                    String msg = this.getMessage(stream);
                    if (msg.contains("i686")) {
                        result = "i686";
                    } else if (msg.contains("armv6")) {
                        result = "armv6";
                    } else if (msg.contains("armv7")) {
                        result = "armv7";
                    }
                    this.closeStream(stream);
                }
                catch (Exception e3) {
                    result = "?.?.?";
                }
            }
        }
        return result;
    }

    public boolean backupFile(String file) {
        boolean success = false;
        if (this.connected) {
            try {
                INovacomStream ins = defaultDevice.runProgram("/bin/cp", new String[]{file, file + "BACKUP"});
                String msg = this.getMessage(ins);
                int returnCode = this.closeStream(ins);
                if (returnCode != 0) {
                    JOptionPane.showMessageDialog(null, "ERROR: " + msg);
                }
                success = true;
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(null, "ERROR 19:\n\n" + e.getMessage());
            }
        }
        return success;
    }

    public boolean backupExists(String file) {
        boolean exists = false;
        if (this.connected) {
            exists = this.fileExists(file + "BACKUP");
        }
        return exists;
    }

    public boolean deleteBackup(String file) {
        return this.delFile(file + "BACKUP");
    }

    public boolean restoreBackup(String file) {
        boolean success = false;
        String msg = "";
        if (this.connected) {
            try {
                INovacomStream ins = defaultDevice.runProgram("/bin/mv", new String[]{"-f", file + "BACKUP", file});
                msg = this.getMessage(ins);
                int returnCode = this.closeStream(ins);
                if (returnCode != 0) {
                    JOptionPane.showMessageDialog(null, "ERROR: " + msg);
                }
                success = true;
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(null, "ERROR 21:\n\n" + e.getMessage() + "\n\n" + msg);
            }
        }
        return success;
    }

    public boolean patch(String file, String[] key, String[] replace) {
        boolean patched = false;
        String tmpFilePath = System.getProperty("java.io.tmpdir");
        if (this.connected) {
            try {
                BufferedWriter newFile = new BufferedWriter(new FileWriter(tmpFilePath + "/" + this.getFilename(new File(file))));
                INovacomStream stream = defaultDevice.getFile(file);
                String line = stream.readLine();
                while (line != null && !line.equals("")) {
                    for (int i = 0; i < key.length; ++i) {
                        if (!line.contains(key[i])) continue;
                        patched = true;
                        line = replace[i];
                    }
                    newFile.write(line);
                    line = stream.readLine();
                }
                this.closeStream(stream);
                newFile.close();
            }
            catch (Exception e) {
                // empty catch block
            }
            File f = new File(tmpFilePath + "/" + this.getFilename(new File(file)));
            if (f.exists() && f.length() > 0L) {
                this.sendFile(f, file);
            }
        }
        return patched;
    }

    public JSONObject readJSONFile(String path) {
        INovacomStream stream = null;
        JSONObject result = null;
        String out = "";
        String line = null;
        int blankCount = 0;
        if (this.connected && (stream = this.getFile(path)) != null) {
            try {
                line = stream.readLine();
                while (line != null && blankCount <= 5) {
                    if (line.trim().length() == 0) {
                        ++blankCount;
                    } else {
                        out = out + line.trim();
                    }
                    if ((line = stream.readLine()) == null || line.trim().length() == 0) continue;
                    out = out + " ";
                }
                result = new JSONObject(out);
                stream.closeInput();
                stream.closeOutput();
                try {
                    stream.waitForReturnCode();
                }
                catch (Exception e) {
                    // empty catch block
                }
                stream.close();
            }
            catch (Exception e) {
                result = null;
            }
        }
        return result;
    }

    public PackageFeed getAppsFeed(String path) {
        File feedFile;
        PackageFeed feed = null;
        String tmpFilePath = System.getProperty("java.io.tmpdir");
        if (this.connected && this.receiveFile(path, feedFile = new File(tmpFilePath, "status"), true)) {
            feed = new PackageFeed(feedFile, this);
            feedFile.delete();
        }
        return feed;
    }

    public boolean install(String file) {
        boolean success;
        block6: {
            PackageFeed feed;
            success = false;
            if (this.connected && this.installIPK(file) && (feed = this.getAppsFeed(this.offlineRoot + "/usr/lib/ipkg/status")) != null) {
                int i = feed.indexOfNew();
                success = this.postinst(feed.apps.get((int)i).id);
                if (success) {
                    this.rescan();
                    try {
                        if (!this.fileExists(this.offlineRoot + "/usr/lib/ipkg/info/" + feed.apps.get((int)i).id + ".postinst")) break block6;
                        feed.apps.get(i).parseControl();
                        if (feed.apps.get((int)i).source.has("PostInstallFlags")) {
                            this.restartDevice |= feed.apps.get((int)i).source.getString("PostInstallFlags").equalsIgnoreCase("RestartDevice");
                            this.restartLuna |= feed.apps.get((int)i).source.getString("PostInstallFlags").equalsIgnoreCase("RestartLuna");
                            this.restartJava |= feed.apps.get((int)i).source.getString("PostInstallFlags").equalsIgnoreCase("RestartJava");
                        }
                    }
                    catch (Exception e) {}
                } else {
                    this.uninstall(feed.apps.get((int)i).id, false);
                    this.rescan();
                }
            }
        }
        return success;
    }

    private boolean installIPK(String file) {
        boolean success = false;
        try {
            INovacomStream ins = defaultDevice.runProgram("/usr/bin/ipkg", new String[]{"-o", this.offlineRoot, "-force-depends", "-force-reinstall", "install", file});
            String msg = this.getMessage(ins);
            int returnCode = this.closeStream(ins);
            if (returnCode != 0) {
                JOptionPane.showMessageDialog(null, "ERROR: An error occured while attempting to install " + this.getFilename(new File(file)) + "\n\n" + msg);
            }
            success = true;
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "ERROR 17:\n\n" + e.getMessage());
        }
        this.delFile(file);
        return success;
    }

    private boolean postinst(String app) {
        boolean b;
        int n;
        boolean success = true;
        String palmStyle = this.offlineRoot + "/.scripts/" + app + "/pmPostInstall.script";
        if (this.fileExists(palmStyle) && !this.isEmptyFile(palmStyle) && !this.md5sum(palmStyle).equals(this.md5sum(this.offlineRoot + "/usr/lib/ipkg/info/" + app + ".postinst"))) {
            success &= this.runIpkgScript(palmStyle);
        }
        if (this.fileExists(this.offlineRoot + "/usr/lib/ipkg/info/" + app + ".postinst") && ((n = !(b = Preferences.userRoot().getBoolean("noScriptPrompt", false)) ? this.scriptMsgBox(app, "postinst") : 0) == 0 || n == 1)) {
            success &= this.runIpkgScript(this.offlineRoot + "/usr/lib/ipkg/info/" + app + ".postinst");
        }
        if (!this.fileExists(palmStyle = this.offlineRoot + "/.scripts/" + app + "/pmPreRemove.script") && !this.isEmptyFile(palmStyle)) {
            this.makeDir(this.offlineRoot + "/.scripts/" + app + "/", false);
            this.runCmd("/bin/cp", new String[]{"-f", this.offlineRoot + "/usr/lib/ipkg/info/" + app + ".prerm", palmStyle}, false);
        }
        return success;
    }

    private String getIpkgOutput(INovacomStream ins) {
        String result = "";
        try {
            String line = ins.readLine();
            while (line != null && line.trim().length() != 0) {
                result = result + line;
                if (line.toLowerCase().contains("fail")) {
                    this.runCmd("/usr/bin/killall", new String[]{"luna-send"}, false);
                    break;
                }
                line = ins.readLine();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public void finishIpkgAction() {
        if (this.restartDevice) {
            this.restartDevice();
        } else {
            if (this.restartLuna) {
                this.reloadGUI();
            }
            if (this.restartJava) {
                this.reloadJava();
            }
        }
        this.restartDevice = false;
        this.restartLuna = false;
        this.restartJava = false;
    }

    private String getMessage(INovacomStream ins) {
        String result = "";
        try {
            String line = ins.readLine();
            while (line != null && line.trim().length() != 0) {
                result = result + line;
                line = ins.readLine();
            }
            if (result == null) {
                result = "";
            }
        }
        catch (Exception e) {
            result = "";
        }
        return result;
    }

    private int closeStream(INovacomStream ins) throws IOException {
        return this.closeStream(ins, true);
    }

    private int closeStream(INovacomStream ins, boolean wait) throws IOException {
        int result = 0;
        if (wait) {
            try {
                result = ins.waitForReturnCode();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        ins.closeInput();
        ins.closeOutput();
        ins.close();
        return result;
    }

    private int scriptMsgBox(String app, String scriptType) {
        Object[] options = new Object[]{"Yes, always", "Yes", "No"};
        int n = JOptionPane.showOptionDialog(null, "<html><body width=\"250px\">" + app + " is requesting to run a " + scriptType + " script. Allow?</body>", "Allow Script?", 1, 3, null, options, options[1]);
        if (n == 0) {
            Preferences.userRoot().putBoolean("noScriptPrompt", true);
        }
        return n;
    }

    public boolean uninstall(String id) {
        return this.uninstall(id, true);
    }

    public boolean uninstall(String id, boolean runPrerm) {
        boolean success = false;
        if (this.connected) {
            this.checkRemovalFlags(id);
            boolean contin = true;
            if (runPrerm) {
                contin = this.prerm(id);
            }
            if (contin) {
                try {
                    INovacomStream ins = defaultDevice.runProgram("/usr/bin/ipkg", new String[]{"-o", this.offlineRoot, "-force-depends", "remove", id});
                    String msg = this.getMessage(ins);
                    int returnCode = this.closeStream(ins);
                    if (returnCode != 0) {
                        JOptionPane.showMessageDialog(null, "ERROR: An error occured while attempting to uninstall " + id + "\n\n" + msg);
                    }
                    this.delEmptyDir(this.offlineRoot + "/usr/palm/applications/" + id);
                    this.rescan();
                    success = true;
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(null, "ERROR 18:\n\n" + e.getMessage());
                }
            }
        }
        return success;
    }

    private void checkRemovalFlags(String id) {
        AppInfoEntry app = new AppInfoEntry(this);
        app.id = id;
        app.parseControl();
        try {
            if (app.source.has("PostRemoveFlags")) {
                this.restartDevice |= app.source.getString("PostRemoveFlags").equalsIgnoreCase("RestartDevice");
                this.restartLuna |= app.source.getString("PostRemoveFlags").equalsIgnoreCase("RestartLuna");
                this.restartJava |= app.source.getString("PostRemoveFlags").equalsIgnoreCase("RestartJava");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private boolean prerm(String app) {
        boolean b;
        int n;
        boolean success = true;
        String palmStyle = this.offlineRoot + "/.scripts/" + app + "/pmPreRemove.script";
        if (this.fileExists(palmStyle) && !this.isEmptyFile(palmStyle) && !this.md5sum(palmStyle).equals(this.md5sum(this.offlineRoot + "/usr/lib/ipkg/info/" + app + ".prerm"))) {
            success &= this.runIpkgScript(palmStyle);
        }
        if (this.fileExists(this.offlineRoot + "/usr/lib/ipkg/info/" + app + ".prerm") && ((n = !(b = Preferences.userRoot().getBoolean("noScriptPrompt", false)) ? this.scriptMsgBox(app, "prerm") : 0) == 0 || n == 1)) {
            success &= this.runIpkgScript(this.offlineRoot + "/usr/lib/ipkg/info/" + app + ".prerm");
        }
        return success;
    }

    public String getFilename(File f) {
        String result = f.getName();
        if (result.lastIndexOf("/") != -1) {
            result = result.substring(result.lastIndexOf("/") + 1);
        }
        if (result.lastIndexOf("\\") != -1) {
            result = result.substring(result.lastIndexOf("\\") + 1);
        }
        return result;
    }

    public boolean isEmptyFile(String file) {
        boolean isEmpty = false;
        String msg = null;
        if (this.connected) {
            try {
                INovacomStream ins = defaultDevice.runProgram("/bin/ls", new String[]{"-s", file});
                msg = this.getMessage(ins);
                this.closeStream(ins);
                if (msg.trim().startsWith("0")) {
                    isEmpty = true;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return isEmpty;
    }

    public boolean runIpkgScript(String file) {
        boolean success = false;
        if (this.connected) {
            try {
                String tmpFilePath = System.getProperty("java.io.tmpdir");
                File tmp = new File(tmpFilePath, "ipkgScript.sh");
                if (tmp.exists()) {
                    tmp.delete();
                }
                BufferedWriter bw = new BufferedWriter(new FileWriter(tmp));
                bw.write("/bin/sh -c 'export IPKG_OFFLINE_ROOT=" + this.offlineRoot + " ; " + file + "'\n");
                bw.flush();
                bw.close();
                if (this.sendFile(tmp, "/tmp/ipkgScript.sh")) {
                    success = this.runScript("/tmp/ipkgScript.sh");
                    this.delFile("/tmp/ipkgScript.sh");
                }
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(null, "ERROR 10:\n\n" + e.getMessage());
            }
        }
        return success;
    }

    public boolean runScript(String file) {
        return this.runScript(file, true);
    }

    public boolean runScript(String file, boolean showError) {
        boolean success;
        block6: {
            success = false;
            if (this.connected) {
                try {
                    INovacomStream ins = defaultDevice.runProgram("/bin/sh", new String[]{file});
                    String msg = this.getMessage(ins);
                    int returnCode = this.closeStream(ins);
                    if (returnCode != 0 && showError) {
                        if (msg.contains("saving rejects to file")) {
                            msg = msg.substring(0, msg.indexOf("saving rejects to file"));
                            msg = msg + "see webos-patches.log for more details";
                        }
                        JOptionPane.showMessageDialog(null, "ERROR: An error occured while attempting to run " + file + "\n\n" + msg);
                    } else {
                        success = true;
                    }
                }
                catch (Exception e) {
                    if (!showError) break block6;
                    JOptionPane.showMessageDialog(null, "ERROR 10:\n\n" + e.getMessage());
                }
            }
        }
        return success;
    }

    public String processScript(String file) {
        String msg = null;
        if (this.connected) {
            try {
                INovacomStream ins = defaultDevice.runProgram("/bin/sh", new String[]{file});
                msg = this.getMessage(ins);
                this.closeStream(ins);
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(null, "ERROR 10:\n\n" + e.getMessage());
            }
        }
        return msg;
    }

    public DeviceInfo getDeviceInfo() {
        DeviceInfo di = null;
        if (this.connected) {
            try {
                di = new DeviceInfo(defaultDevice);
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(null, "ERROR 11:\n\n" + e.getMessage());
            }
        }
        return di;
    }

    public boolean delFile(String file) {
        boolean success = false;
        if (this.connected) {
            try {
                INovacomStream ins = defaultDevice.runProgram("/bin/rm", new String[]{"-f", file});
                String msg = this.getMessage(ins);
                int returnCode = this.closeStream(ins);
                if (returnCode != 0) {
                    // empty if block
                }
                success = true;
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(null, "ERROR 12:\n\n" + e.getMessage());
            }
        }
        return success;
    }

    public boolean delEmptyDir(String dir) {
        boolean success = false;
        if (this.connected) {
            try {
                INovacomStream ins = defaultDevice.runProgram("/bin/rmdir", new String[]{dir});
                String msg = this.getMessage(ins);
                int returnCode = this.closeStream(ins);
                if (returnCode != 0) {
                    // empty if block
                }
                success = true;
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(null, "ERROR 13:\n\n" + e.getMessage());
            }
        }
        return success;
    }

    public boolean delDir(String dir) {
        boolean success = false;
        if (this.connected) {
            try {
                INovacomStream ins = defaultDevice.runProgram("/bin/rm", new String[]{"-r", dir});
                String msg = this.getMessage(ins);
                int returnCode = this.closeStream(ins);
                if (returnCode != 0) {
                    // empty if block
                }
                success = true;
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(null, "ERROR 13:\n\n" + e.getMessage());
            }
        }
        return success;
    }

    public boolean rescan() {
        INovacomStream ins = null;
        boolean success = false;
        if (this.connected) {
            try {
                ins = defaultDevice.runProgram("/usr/bin/luna-send", new String[]{"palm://com.palm.applicationManager/rescan {}"});
                String msg = this.getMessage(ins);
                int returnCode = this.closeStream(ins);
                if (returnCode != 0) {
                    JOptionPane.showMessageDialog(null, "ERROR: " + msg);
                }
                success = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return success;
    }

    public boolean reloadJava() {
        INovacomStream ins = null;
        boolean success = false;
        if (this.connected) {
            try {
                ins = defaultDevice.runProgram("/usr/bin/killall", new String[]{"-9", "java"});
                String msg = this.getMessage(ins);
                int returnCode = this.closeStream(ins);
                if (returnCode != 0) {
                    JOptionPane.showMessageDialog(null, "ERROR: " + msg);
                }
                success = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return success;
    }

    public boolean reloadGUI() {
        INovacomStream ins = null;
        boolean success = false;
        if (this.connected) {
            try {
                ins = defaultDevice.runProgram("/usr/bin/killall", new String[]{"-HUP", "LunaSysMgr"});
                String msg = this.getMessage(ins);
                int returnCode = this.closeStream(ins);
                if (returnCode != 0) {
                    JOptionPane.showMessageDialog(null, "ERROR: " + msg);
                }
                success = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return success;
    }

    public boolean stopLuna() {
        INovacomStream ins = null;
        boolean success = false;
        if (this.connected) {
            try {
                ins = defaultDevice.runProgram("/sbin/initctl", new String[]{"stop", "LunaSysMgr"});
                String msg = this.getMessage(ins);
                int returnCode = this.closeStream(ins);
                if (returnCode != 0) {
                    JOptionPane.showMessageDialog(null, "ERROR: " + msg);
                }
                success = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return success;
    }

    public boolean startLuna() {
        INovacomStream ins = null;
        boolean success = false;
        if (this.connected) {
            try {
                ins = defaultDevice.runProgram("/sbin/initctl", new String[]{"start", "LunaSysMgr"});
                String msg = this.getMessage(ins);
                int returnCode = this.closeStream(ins);
                if (returnCode != 0) {
                    JOptionPane.showMessageDialog(null, "ERROR: " + msg);
                }
                success = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return success;
    }

    public boolean restartDevice() {
        String tmpFilePath = System.getProperty("java.io.tmpdir");
        INovacomStream ins = null;
        boolean success = false;
        if (this.connected) {
            try {
                File script = new File(tmpFilePath, "restartScript");
                BufferedWriter bw = new BufferedWriter(new FileWriter(script));
                bw.write("sleep 0.1\nkillall -INT novacomd\nreboot\n");
                bw.flush();
                bw.close();
                this.sendFile(script, "/tmp/restartDevice.sh");
                script.delete();
                ins = defaultDevice.runProgram("/bin/sh", new String[]{"/tmp/restartDevice.sh"});
                ins.closeInput();
                ins.closeOutput();
                ins.close();
                success = true;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return success;
    }

    public boolean close() {
        INovacomStream ins = null;
        boolean success = false;
        try {
            ins = defaultDevice.runProgram("/bin/mount", new String[]{"-o", "remount,ro", "/"});
            String msg = this.getMessage(ins);
            int returnCode = this.closeStream(ins);
            if (!Preferences.userRoot().getBoolean("useEmulator", false) && returnCode != 0) {
                JOptionPane.showMessageDialog(null, msg);
            }
            success = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        defaultDevice.close();
        return success;
    }
}

