/*
 * Decompiled with CFR 0.152.
 */
package ca.canucksoftware;

import ca.canucksoftware.AppInfoEntry;
import ca.canucksoftware.NovacomConnection;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.zip.GZIPInputStream;
import javax.swing.JOptionPane;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PackageFeed {
    private final String UNKNOWN_CATEGORY = "Unknown";
    public ArrayList<AppInfoEntry> apps;
    public ArrayList<String> categories;
    private File feedFile;
    private boolean gzFeed;
    private NovacomConnection novaCon;
    public boolean errorDownloading;

    public PackageFeed() {
        this.errorDownloading = true;
    }

    public PackageFeed(File f, NovacomConnection nc) {
        this.errorDownloading = false;
        this.feedFile = f;
        this.novaCon = nc;
        this.gzFeed = false;
        this.apps = new ArrayList(0);
        this.categories = new ArrayList(0);
        this.categories.add("-All-");
        if (f != null) {
            if (f.getName().endsWith(".gz")) {
                this.gzFeed = true;
            }
            this.scan();
        }
    }

    public void scan() {
        BufferedReader input;
        this.apps.clear();
        this.categories.clear();
        try {
            input = this.gzFeed ? new BufferedReader(new InputStreamReader(new GZIPInputStream(new FileInputStream(this.feedFile)))) : new BufferedReader(new FileReader(this.feedFile));
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "Error finding package list");
            input = null;
        }
        if (input != null) {
            try {
                String line = input.readLine();
                while (line != null) {
                    String cat;
                    boolean blockRead = false;
                    AppInfoEntry curr = null;
                    curr = new AppInfoEntry(this.novaCon);
                    line = line.trim();
                    while (!line.equals("")) {
                        String[] elements;
                        if (!line.endsWith(":") && (elements = line.split(" ")).length > 1) {
                            if (elements[0].startsWith("Package")) {
                                curr.id = elements[1];
                            } else if (elements[0].startsWith("Description")) {
                                curr.name = line.substring(line.indexOf(":") + 2);
                            } else if (elements[0].startsWith("Version")) {
                                curr.version = elements[1];
                            } else if (elements[0].startsWith("Maintainer")) {
                                curr.developer = line.substring(line.indexOf(":") + 2);
                            } else if (elements[0].startsWith("Size")) {
                                curr.size = elements[1];
                            } else if (elements[0].startsWith("Installed-Time")) {
                                curr.installTime = elements[1];
                            } else if (elements[0].startsWith("Filename")) {
                                curr.file = line.substring(line.indexOf(":") + 2);
                            } else if (elements[0].startsWith("Status")) {
                                curr.status = line.substring(line.indexOf(":") + 2);
                            } else if (elements[0].startsWith("Source")) {
                                try {
                                    curr.source = new JSONObject(line.substring(line.indexOf(":") + 2));
                                }
                                catch (Exception e) {
                                    JOptionPane.showMessageDialog(null, "Error reading source JSON of " + curr.id + "\n\nPlease contact the feed owner to " + "get them to fix the error.");
                                }
                            }
                        }
                        line = input.readLine();
                        blockRead = true;
                    }
                    if (!(!blockRead || curr.status.contains("not-installed") || curr.status.contains("Not-installed") || curr.status.contains("deinstall") || curr.status.contains("Deinstall"))) {
                        this.apps.add(curr);
                    }
                    if (curr.source != null && curr.source.has("Category") && !this.categories.contains(cat = curr.source.getString("Category"))) {
                        this.categories.add(cat);
                    }
                    line = input.readLine();
                }
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(null, "Error reading package list");
            }
        }
        if (input != null) {
            try {
                input.close();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    public String findUrlByPackage(String id) {
        String result = null;
        for (int i = 0; i < this.apps.size(); ++i) {
            AppInfoEntry curr = this.apps.get(i);
            if (!curr.id.equalsIgnoreCase(id)) continue;
            result = curr.file;
            break;
        }
        return result;
    }

    public void mergeFeed(PackageFeed feed) {
        for (int i = 0; i < feed.categories.size(); ++i) {
            if (this.categories.contains(feed.categories.get(i))) continue;
            this.categories.add(feed.categories.get(i));
        }
        this.apps.addAll(feed.apps);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static PackageFeed downloadFeed(String url, NovacomConnection nc) {
        byte[] buffer = new byte[65536];
        PackageFeed feed = null;
        FileOutputStream output = null;
        String tmpFilePath = System.getProperty("java.io.tmpdir");
        File dl = new File(tmpFilePath + "/feed");
        InputStream stream = null;
        if (PackageFeed.urlExists(url)) {
            try {
                output = new FileOutputStream(dl);
                stream = url.endsWith(".gz") ? new GZIPInputStream(new URL(url).openStream()) : new URL(url).openStream();
                if (output == null || stream == null) return feed;
                int count = 0;
                while ((count = stream.read(buffer)) > 0) {
                    output.write(buffer, 0, count);
                }
                output.flush();
                output.close();
                stream.close();
                feed = new PackageFeed(new File(tmpFilePath + "/feed"), nc);
                dl.delete();
                for (int i = 0; i < feed.apps.size(); ++i) {
                    AppInfoEntry curr = feed.apps.get(i);
                    if (!curr.file.equals(curr.UNKNOWN)) continue;
                    feed.apps.remove(i);
                    --i;
                }
                return feed;
            }
            catch (Exception e) {
                dl.delete();
                feed = new PackageFeed();
                JOptionPane.showMessageDialog(null, "Error downloading package feed");
                return feed;
            }
        } else {
            feed = new PackageFeed();
            JOptionPane.showMessageDialog(null, "Cannot connect to package feed:\n\n" + url);
        }
        return feed;
    }

    private static boolean urlExists(String URLName) {
        boolean result = false;
        try {
            HttpURLConnection.setFollowRedirects(false);
            HttpURLConnection con = (HttpURLConnection)new URL(URLName).openConnection();
            con.setInstanceFollowRedirects(false);
            con.setConnectTimeout(3000);
            con.setReadTimeout(3000);
            con.setRequestMethod("HEAD");
            result = con.getResponseCode() == 200;
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    public void sort(boolean ascending) {
        Collections.sort(this.categories);
        Collections.sort(this.apps, new AppSorter(ascending));
    }

    public AppInfoEntry getAppInfo(String id) {
        AppInfoEntry result = null;
        for (int i = 0; i < this.apps.size(); ++i) {
            if (!this.apps.get((int)i).id.equalsIgnoreCase(id)) continue;
            result = this.apps.get(i);
            break;
        }
        return result;
    }

    public int indexOfNew() {
        int index = -1;
        long time = 0L;
        for (int i = 0; i < this.apps.size(); ++i) {
            long temp;
            AppInfoEntry curr = this.apps.get(i);
            if (curr.installTime.equalsIgnoreCase(curr.UNKNOWN) || time >= (temp = Long.parseLong(this.apps.get((int)i).installTime))) continue;
            time = temp;
            index = i;
        }
        return index;
    }

    public ArrayList<AppInfoEntry> getAppsByCategory(String category) {
        ArrayList<AppInfoEntry> result;
        if (category.equalsIgnoreCase("-All-")) {
            result = this.apps;
        } else {
            result = new ArrayList(0);
            for (int i = 0; i < this.apps.size(); ++i) {
                AppInfoEntry curr = this.apps.get(i);
                if (curr.source == null) {
                    if (!category.equalsIgnoreCase("Unknown")) continue;
                    result.add(curr);
                    continue;
                }
                if (curr.source.has("Category")) {
                    try {
                        String currCat = curr.source.getString("Category");
                        if (!category.equalsIgnoreCase(currCat)) continue;
                        result.add(curr);
                    }
                    catch (Exception e) {}
                    continue;
                }
                if (!category.equalsIgnoreCase("Unknown")) continue;
                result.add(curr);
            }
        }
        return result;
    }

    class AppSorter
    implements Comparator {
        boolean ascending;

        AppSorter(boolean ascending) {
            this.ascending = ascending;
        }

        public int compare(Object a, Object b) {
            int i;
            AppInfoEntry data1 = (AppInfoEntry)a;
            AppInfoEntry data2 = (AppInfoEntry)b;
            if (this.ascending) {
                i = data1.name.compareToIgnoreCase(data2.name);
                if (i == 0) {
                    i = data1.id.compareToIgnoreCase(data2.id);
                }
            } else {
                i = data2.name.compareToIgnoreCase(data1.name);
                if (i == 0) {
                    i = data2.id.compareToIgnoreCase(data1.id);
                }
            }
            return i;
        }
    }
}

