/*
 * Decompiled with CFR 0.152.
 */
package ca.canucksoftware;

public class PatchMeta {
    private String name = null;
    private String version = null;
    private String author = null;
    private String description = null;

    public void parseName(String s) {
        this.name = this.parseLine(s);
    }

    public void parseVersion(String s) {
        this.version = this.parseLine(s);
        String[] tokens = this.version.split("-");
        if (tokens.length == 2) {
            this.version = tokens[1];
        } else if (this.version.indexOf(".") > -1) {
            this.version = null;
        }
    }

    public void parseAuthor(String s) {
        this.author = this.parseLine(s);
    }

    public void parseDescription(String s) {
        this.description = this.parseLine(s);
    }

    private String parseLine(String s) {
        int i = s.indexOf(":");
        String result = null;
        if (i > -1) {
            result = s.substring(i + 1).trim();
        }
        return result;
    }

    public String getName(String file) {
        if (this.name == null) {
            this.name = file.substring(0, file.lastIndexOf("."));
        }
        return this.name;
    }

    public String getVersion(String webosVer) {
        String result = webosVer;
        result = this.version == null ? result + "-1" : result + "-" + this.version;
        return result;
    }

    public String getAuthor() {
        if (this.author == null) {
            this.author = "Unknown";
        }
        return this.author;
    }

    public String getDescription() {
        if (this.description == null) {
            this.description = "N/A";
        }
        return this.description;
    }
}

