/*
 * Decompiled with CFR 0.152.
 */
package ca.canucksoftware;

import ca.canucksoftware.NovacomConnection;
import ca.canucksoftware.PatchMeta;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.List;
import java.util.prefs.Preferences;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Patcher {
    public final String[][] MODS = new String[][]{{"org.webosinternals.patches.app-launcher-enable-add-delete-pages", "org.webosinternals.patches.app-launcher-4x4-icons-v1", "org.webosinternals.patches.browser-multi-mod", "org.webosinternals.patches.screen-lock-reduce-minimum-brightness", "org.webosinternals.patches.phone-enable-dialpad-vibration", "org.webosinternals.patches.phone-add-roam-control-to-prefs", "org.webosinternals.patches.phone-call-duration-in-call-log", "org.webosinternals.patches.calendar-default-to-month-view", "org.webosinternals.patches.top-bar-brightness-in-device-menu", "org.webosinternals.patches.email-read-delete-all", "org.webosinternals.patches.screen-lock-enable-led-notifications", "org.webosinternals.patches.sounds-and-alerts-disable-charging-alert-sounds", "org.webosinternals.patches.messaging-enable-landscape-messaging", "org.webosinternals.patches.youtube-video-downloads", "org.webosinternals.patches.messaging-character-counter", "org.webosinternals.patches.messaging-timestamps-clean", "org.webosinternals.patches.messaging-new-card-per-convo", "org.webosinternals.patches.misc-ad-blocker", "ca.canucksoftware.patches.keytoss-phone-slider", "change-user-agent"}, {"org.webosinternals.patches.app-launcher-hide-nascar-app", "org.webosinternals.patches.app-launcher-hide-nfl-app", "org.webosinternals.patches.app-launcher-hide-sprinttv-app", "org.webosinternals.patches.app-launcher-hide-musicplayer-app", "org.webosinternals.patches.top-bar-battery-percent-as-icon", "org.webosinternals.patches.clock-unhide-black-analog-theme", "ca.canucksoftware.patches.launcher-opacity", "org.webosinternals.patches.messaging-enable-personal-avatar"}};
    public final String BATTERY_ALT = "org.webosinternals.patches.top-bar-battery-percent-and-icon";
    private final String EPR = "http://ipkg.preware.org/feeds/webos-internals/all/org.webosinternals.emergency-patch-recovery_2.1.1_all.ipk";
    private final String POSTINST_URL = "http://tinyurl.com/yb4ayf7";
    private final String PRERM_URL = "http://tinyurl.com/ykupmwf";
    private String version;
    public String arch;
    private PatchMeta currMeta;
    private NovacomConnection novaCon;
    public boolean loaded;
    private List<String> patches;

    public Patcher(NovacomConnection nc) {
        this.novaCon = nc;
        this.loaded = false;
        this.patches = null;
        this.version = null;
        this.arch = null;
    }

    public void loadVersion() {
        this.version = this.novaCon.getWebOSVersion();
        this.loadArch();
    }

    private void loadArch() {
        if (this.arch == null) {
            this.arch = this.novaCon.getWebOSArch();
            if (this.arch.equalsIgnoreCase("????")) {
                this.arch = "all";
            }
        }
    }

    public boolean meetsRequirements() {
        boolean result = false;
        ArrayList<String> dlList = new ArrayList<String>();
        this.loadArch();
        if (!this.novaCon.fileExists(this.novaCon.offlineRoot + "/etc/ipkg/arch.conf")) {
            this.novaCon.makeDir(this.novaCon.offlineRoot + "/etc/ipkg", false);
            if (!this.arch.equals("all")) {
                this.novaCon.sendFile(this.extractFromJar("resources/arch/" + this.arch + ".conf"), this.novaCon.offlineRoot + "/etc/ipkg/arch.conf");
            } else {
                this.novaCon.runCmd("/bin/cp", new String[]{"-f", "/etc/ipkg/arch.conf", this.novaCon.offlineRoot + "/etc/ipkg/arch.conf"});
            }
        }
        if (!this.novaCon.fileExists(this.novaCon.offlineRoot + "/usr/bin/lsdiff")) {
            dlList.add("http://ipkg.preware.org/feeds/webos-internals/" + this.arch + "/org.webosinternals" + ".lsdiff_0.3.1_" + this.arch + ".ipk");
        }
        if (!this.novaCon.fileExists(this.novaCon.offlineRoot + "/usr/bin/patch")) {
            dlList.add("http://ipkg.preware.org/feeds/webos-internals/" + this.arch + "/org.webosinternals" + ".patch_2.5.9-3_" + this.arch + ".ipk");
        }
        if (dlList.size() > 0) {
            if (JOptionPane.showConfirmDialog(null, "<html><body width=\"300px\">Tweaking requires both GNU Patch and Lsdiff installed to function. One or both of these are missing from your device. Would you like to download and install them now?", "Required Component Missing", 0) == 0) {
                JOptionPane.showMessageDialog(null, "<html><body width=\"350px\">This may take upto a minute to complete, so please be patient. Click 'OK' to begin");
                boolean noError = true;
                for (int i = 0; i < dlList.size(); ++i) {
                    File f = this.downloadFile((String)dlList.get(i));
                    if (f != null) {
                        if (this.novaCon.sendFile(f, "/media/internal/.file.ipk")) {
                            this.novaCon.install("/media/internal/.file.ipk");
                            JOptionPane.showMessageDialog(null, ((String)dlList.get(i)).substring(((String)dlList.get(i)).lastIndexOf("/") + 1) + " downloaded and installed!");
                            continue;
                        }
                        noError = false;
                        continue;
                    }
                    noError = false;
                }
                this.novaCon.finishIpkgAction();
                result = noError;
            }
        } else {
            result = true;
        }
        return result;
    }

    public List<String> getPatchList() {
        return this.patches;
    }

    private File downloadFile(String url) {
        URLConnection urlCon = null;
        String tmpFilePath = System.getProperty("java.io.tmpdir");
        File result = new File(tmpFilePath, url.substring(url.lastIndexOf("/") + 1));
        try {
            int len;
            urlCon = new URL(url).openConnection();
            urlCon.setRequestProperty("Content-Type", "application/binary");
            BufferedInputStream bis = new BufferedInputStream(urlCon.getInputStream());
            BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(result));
            byte[] buf = new byte[1024];
            while ((len = bis.read(buf)) > 0) {
                bos.write(buf, 0, len);
            }
            bos.flush();
            bis.close();
            bos.close();
        }
        catch (Exception e) {
            result = null;
        }
        return result;
    }

    private File downloadPatch(String filename) {
        return this.downloadFile("http://ipkg.preware.org/feeds/webos-patches/" + this.version + "/" + filename);
    }

    public boolean installPatchFromFeed(String file, String id) {
        boolean success = false;
        this.patches.add(id);
        if (this.novaCon.sendFile(this.downloadPatch(file), "/media/internal/.patch.ipk") && this.novaCon.install("/media/internal/.patch.ipk")) {
            success = true;
        }
        return success;
    }

    public boolean uninstallPatch(String mod) {
        boolean b = this.novaCon.uninstall(mod);
        this.patches.remove(mod);
        return b;
    }

    public void loadInstalledList() {
        boolean updateFromLegacy = false;
        if (this.novaCon.fileExists("/media/cryptofs/apps/usr/lib/.webosinternals.patches/packages")) {
            updateFromLegacy = true;
            JOptionPane.showMessageDialog(null, "<html><body width=\"350px\">Please wait while WebOS Quick Install updates patch configuration for v3.0. This is a one-time process and should take a few minutes");
            if (!this.novaCon.fileExists("/var/usr/lib/.webosinternals.patches/backups")) {
                this.novaCon.makeDir("/var/usr/lib/.webosinternals.patches/", false);
                this.novaCon.createFile("/var/usr/lib/.webosinternals.patches/packages");
                this.novaCon.createFile("/var/usr/lib/.webosinternals.patches/backups");
            }
            this.fixPatchPartitionIssue();
        }
        this.patches = this.loadPatchPackages();
        if (updateFromLegacy || Preferences.userRoot().getBoolean("newTo3.0", true)) {
            Preferences.userRoot().putBoolean("newTo3.0", false);
            this.transitionToAUPT();
            JOptionPane.showMessageDialog(null, "<html>WebOS Quick Install is now ready for use. Enjoy! :)");
        }
        this.loaded = true;
    }

    private boolean fixPatchPartitionIssue() {
        String packages1 = "/var/usr/lib/.webosinternals.patches/packages";
        String packages2 = "/media/cryptofs/apps/usr/lib/.webosinternals.patches/packages";
        String backups1 = "/var/usr/lib/.webosinternals.patches/backups";
        String backups2 = "/media/cryptofs/apps/usr/lib/.webosinternals.patches/backups";
        String script = "/bin/cat " + packages2 + " >> " + packages1 + "\n" + "/bin/cat " + backups2 + " >> " + backups1 + "\n" + "/bin/rm -f " + packages2 + "\n/bin/rm -f " + backups2 + "\n" + "/bin/mv -f /media/cryptofs/apps/usr/lib/.webosinternals.patches/* " + "/var/usr/lib/.webosinternals.patches\n" + "/bin/rmdir /media/cryptofs/apps/usr/lib/.webosinternals.patches\n" + "exit 0";
        return this.doScript(script);
    }

    private void transitionToAUPT() {
        String patchTransition = "";
        String prermReplace = "";
        this.novaCon.sendFile(this.extractFromJar("resources/patchTransition"), "/tmp/patchTransition.sh");
        this.novaCon.sendFile(this.extractFromJar("resources/prerm"), "/tmp/prermBase.sh");
        for (int i = 0; i < this.patches.size(); ++i) {
            String curr = this.patches.get(i);
            if (!curr.startsWith("ca.canucksoftware.patches.")) continue;
            String base = curr.replaceFirst("ca.canucksoftware.patches.", "");
            patchTransition = patchTransition + "/bin/echo -e \"#!/bin/sh\\nAPP_DIR=\\$IPKG_OFFLINE_ROOT/usr/palm/applications/" + curr + "\\nPATCH_NAME=" + base + ".patch\\n\" > /tmp/" + curr + ".transition.sh\n/bin/cat " + "/tmp/patchTransition.sh >> /tmp/" + curr + ".transition.sh\n" + "/bin/chmod 777 /tmp/" + curr + ".transition.sh\n/bin/sh -c " + "'export IPKG_OFFLINE_ROOT=" + this.novaCon.offlineRoot + " ; /tmp/" + curr + ".transition.sh'\n/bin/rm -f /tmp/" + curr + ".transition.sh\n";
            patchTransition = patchTransition + "/bin/echo -e \"#!/bin/sh\\nAPP_DIR=\\$IPKG_OFFLINE_ROOT/usr/palm/applications/" + curr + "\\nPATCH_NAME=" + base + ".patch\\n\" > " + this.novaCon.offlineRoot + "/usr/lib/ipkg/info/" + curr + ".prerm\n/bin/cat /tmp/prermBase.sh >> " + this.novaCon.offlineRoot + "/usr/lib/ipkg/info/" + curr + ".prerm\n/bin/chmod 777 " + this.novaCon.offlineRoot + "/usr/lib/ipkg/info/" + curr + ".prerm\n";
        }
        try {
            Thread.sleep(100L);
            this.doScript(patchTransition);
            Thread.sleep(100L);
            this.doScript(prermReplace);
            Thread.sleep(100L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.novaCon.delFile("/tmp/patchTransition.sh");
        this.novaCon.delFile("/tmp/prermBase.sh");
        this.updateStatusPackageVersions();
    }

    private void updateStatusPackageVersions() {
        String tmpFilePath = System.getProperty("java.io.tmpdir");
        File status = new File(tmpFilePath, "status");
        this.novaCon.receiveFile(this.novaCon.offlineRoot + "/usr/lib/ipkg/status", status, false);
        StringBuffer sb = new StringBuffer();
        try {
            BufferedReader br = new BufferedReader(new FileReader(status));
            String line = br.readLine();
            while (line != null) {
                if (line.startsWith("Package: ca.canucksoftware.patches.")) {
                    sb.append(line + "\n");
                    line = br.readLine();
                    sb.append("Version: " + this.version + "-1\n");
                } else {
                    sb.append(line + "\n");
                }
                line = br.readLine();
            }
            br.close();
            BufferedWriter out = new BufferedWriter(new FileWriter(status));
            out.write(sb.toString());
            out.flush();
            out.close();
            this.novaCon.sendFile(status, this.novaCon.offlineRoot + "/usr/lib/ipkg/status");
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    private List<String> loadPatchPackages() {
        List<String> packages = this.novaCon.listInstalled();
        for (int i = 0; i < packages.size(); ++i) {
            if (packages.get(i).startsWith("ca.canucksoftware.patches.") || packages.get(i).startsWith("org.webosinternals.patches.")) continue;
            packages.remove(i);
            --i;
        }
        return packages;
    }

    public boolean isPatchInstalled(String patch) {
        return this.patches.contains(patch);
    }

    public File extractFromJar(String filename) {
        try {
            int nBytes;
            String tmpFilePath = System.getProperty("java.io.tmpdir");
            File efile = new File(tmpFilePath, filename.substring(filename.lastIndexOf("/") + 1));
            if (efile.exists()) {
                efile.delete();
            }
            BufferedInputStream in = new BufferedInputStream(super.getClass().getResourceAsStream(filename));
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(efile));
            byte[] buffer = new byte[2048];
            while ((nBytes = ((InputStream)in).read(buffer)) > 0) {
                ((OutputStream)out).write(buffer, 0, nBytes);
            }
            ((OutputStream)out).flush();
            ((OutputStream)out).close();
            ((InputStream)in).close();
            return efile;
        }
        catch (Exception e) {
            return null;
        }
    }

    public boolean installPatch(File patch) {
        boolean result = false;
        String name = this.novaCon.getFilename(patch);
        String base = name.substring(0, name.lastIndexOf(".")).toLowerCase().replaceAll("[^a-zA-Z0-9-]", "");
        String id = "ca.canucksoftware.patches." + base;
        id = this.uniqueID(id, 0);
        name = id.replaceFirst("ca.canucksoftware.patches.", "") + ".patch";
        this.currMeta = new PatchMeta();
        this.novaCon.makeDir(this.novaCon.offlineRoot + "/usr/palm/applications/" + id + "/", false);
        this.novaCon.makeDir(this.novaCon.offlineRoot + "/usr/lib/ipkg/info/", false);
        String patchDir = this.novaCon.offlineRoot + "/usr/palm/applications/" + id + "/" + name;
        this.parseMetaData(patch);
        if (this.novaCon.sendFile(patch, patchDir)) {
            this.novaCon.createFile(this.novaCon.offlineRoot + "/usr/palm/applications/" + id + "/" + "package_list");
            this.novaCon.makeDir("/var/usr/lib/.webosinternals.patches/", false);
            if (this.doPostinst(id, name)) {
                this.createIpkgEntry(id, patch, name);
                result = true;
            } else {
                this.novaCon.delFile(patchDir);
                this.novaCon.delFile(this.novaCon.offlineRoot + "/usr/palm/applications/" + id + "/" + "package_list");
                this.novaCon.delDir(this.novaCon.offlineRoot + "/usr/palm/applications/" + id + "/");
            }
        }
        return result;
    }

    private String uniqueID(String name, int i) {
        String s = i == 0 ? name : name + "-" + i;
        String result = !this.patches.contains(s) ? s : this.uniqueID(name, i + 1);
        return result;
    }

    private boolean doPostinst(String id, String name) {
        boolean result = false;
        String postinst_file = this.novaCon.offlineRoot + "/usr/lib/ipkg/info/" + id + ".postinst";
        String script = "/usr/bin/wget -q -O /tmp/postinst http://tinyurl.com/yb4ayf7\n/bin/chmod 777 /tmp/postinst\n/bin/sed -e 's|PATCH_NAME=|PATCH_NAME=" + name + "|' \\\n-e 's|APP_DIR=|APP_DIR=$IPKG_OFFLINE_ROOT/usr/palm/" + "applications/" + id + "|' /tmp/postinst > " + postinst_file + "\n" + "/bin/rm -f /tmp/postinst\n/bin/chmod 777 " + postinst_file + "\n" + "/bin/sh -c 'export IPKG_OFFLINE_ROOT=" + this.novaCon.offlineRoot + " ; " + postinst_file + "'\n";
        result = this.doScript(script);
        return result;
    }

    private boolean doScript(String cmd) {
        String tmpFilePath = System.getProperty("java.io.tmpdir");
        boolean result = false;
        File script = new File(tmpFilePath, "script.sh");
        try {
            BufferedWriter bw = new BufferedWriter(new FileWriter(script));
            bw.write(cmd + "\n");
            bw.flush();
            bw.close();
            if (this.novaCon.sendFile(script, "/tmp/scriptFile.sh")) {
                this.novaCon.runCmd("/bin/chmod", new String[]{"777", "/tmp/scriptFile.sh"});
                result = this.novaCon.runScript("/tmp/scriptFile.sh");
                this.novaCon.delFile("/tmp/scriptFile.sh");
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return result;
    }

    private void parseMetaData(File patch) {
        try {
            StringBuffer sb = new StringBuffer();
            BufferedReader br = new BufferedReader(new FileReader(patch));
            String line = br.readLine();
            String prev = null;
            boolean meta = true;
            while (line != null) {
                if (meta) {
                    if (line.startsWith("Name:")) {
                        this.currMeta.parseName(line);
                    } else if (line.startsWith("Version:")) {
                        this.currMeta.parseVersion(line);
                    } else if (line.startsWith("Author:")) {
                        this.currMeta.parseAuthor(line);
                    } else if (line.startsWith("Description:")) {
                        this.currMeta.parseDescription(line);
                    }
                }
                if (line.startsWith("+++")) {
                    String[] tokens;
                    meta = false;
                    boolean newFile = false;
                    if (prev != null && prev.startsWith("---") && (tokens = prev.split(" ")).length >= 2 && tokens[1].equalsIgnoreCase("/dev/null")) {
                        newFile = true;
                    }
                    if ((tokens = line.split(" ")).length >= 2 && newFile && this.novaCon.fileExists(tokens[1])) {
                        this.novaCon.delFile(tokens[1]);
                    }
                }
                prev = line;
                sb.append(line + "\n");
                line = br.readLine();
            }
            br.close();
            BufferedWriter out = new BufferedWriter(new FileWriter(patch));
            out.write(sb.toString());
            out.flush();
            out.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void createIpkgEntry(String id, File patch, String name) {
        this.updateIpkgStatus(id, patch);
        this.createIpkgControl(id, patch);
        this.createIpkgList(id, name);
        this.createPrerm(id, name);
    }

    private void updateIpkgStatus(String id, File patch) {
        String tmpFilePath = System.getProperty("java.io.tmpdir");
        File tmp = new File(tmpFilePath, "status");
        boolean written = false;
        File revised = new File(tmpFilePath, "statusRevised");
        if (!this.novaCon.fileExists(this.novaCon.offlineRoot + "/usr/lib/ipkg/status")) {
            this.novaCon.createFile(this.novaCon.offlineRoot + "/usr/lib/ipkg/status");
        }
        this.novaCon.receiveFile(this.novaCon.offlineRoot + "/usr/lib/ipkg/status", tmp, true);
        try {
            BufferedReader br = new BufferedReader(new FileReader(tmp));
            BufferedWriter bw = new BufferedWriter(new FileWriter(revised));
            String line = br.readLine();
            while (line != null) {
                if (line.startsWith("Package: " + id)) {
                    written = true;
                    break;
                }
                bw.write(line + "\n");
                line = br.readLine();
            }
            if (!written) {
                bw.write("Package: " + id + "\n");
                bw.write("Version: " + this.currMeta.getVersion(this.version) + "\n");
                bw.write("Depends: org.webosinternals.patch, org.webosinternals.lsdiff\n");
                bw.write("Status: install user installed\n");
                bw.write("Architecture: all\n");
                bw.write("Description: " + this.currMeta.getName(this.novaCon.getFilename(patch)) + "\n");
                bw.write("Maintainer: " + this.currMeta.getAuthor() + "\n");
                bw.write("Section: WebOS Quick Install\n");
                bw.write("Size: " + patch.length() + "\n");
                bw.write("Installed-Size: " + patch.length() + "\n");
                String time = String.valueOf(System.currentTimeMillis() / 1000L);
                if (time.length() > 10) {
                    time = time.substring(0, 10);
                }
                bw.write("Installed-Time: " + time + "\n\n");
            }
            bw.flush();
            bw.close();
            br.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        this.novaCon.sendFile(revised, this.novaCon.offlineRoot + "/usr/lib/ipkg/status");
    }

    private void createIpkgControl(String id, File patch) {
        String tmpFilePath = System.getProperty("java.io.tmpdir");
        File tmp = new File(tmpFilePath, "control");
        try {
            BufferedWriter bw = new BufferedWriter(new FileWriter(tmp));
            bw.write("Package: " + id + "\n");
            bw.write("Version: " + this.currMeta.getVersion(this.version) + "\n");
            bw.write("Architecture: all\n");
            bw.write("Maintainer: " + this.currMeta.getAuthor() + "\n");
            bw.write("Description: " + this.currMeta.getName(this.novaCon.getFilename(patch)) + "\n");
            bw.write("Section: WebOS Quick Install\n");
            bw.write("Priority: optional\n");
            bw.write("Depends: org.webosinternals.patch, org.webosinternals.lsdiff\n");
            JSONObject obj = new JSONObject();
            obj.put("Feed", "N/A");
            obj.put("Type", "Patch");
            obj.put("Category", "WebOS Quick Install");
            obj.put("LastUpdated", System.currentTimeMillis() / 1000L + "");
            obj.put("Title", this.currMeta.getName(this.novaCon.getFilename(patch)));
            obj.put("FullDescription", this.currMeta.getDescription());
            bw.write("Source: " + obj.toString() + "\n");
            bw.flush();
            bw.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        this.novaCon.sendFile(tmp, this.novaCon.offlineRoot + "/usr/lib/ipkg/info/" + id + ".control");
    }

    private void createIpkgList(String id, String name) {
        String tmpFilePath = System.getProperty("java.io.tmpdir");
        File tmp = new File(tmpFilePath, "list");
        try {
            BufferedWriter bw = new BufferedWriter(new FileWriter(tmp));
            bw.write("/usr/palm/applications/" + id + "/" + name + "\n");
            bw.write("/usr/palm/applications/" + id + "/package_list\n");
            bw.flush();
            bw.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        this.novaCon.sendFile(tmp, this.novaCon.offlineRoot + "/usr/lib/ipkg/info/" + id + ".list");
    }

    private void createPrerm(String id, String name) {
        String prerm_file = this.novaCon.offlineRoot + "/usr/lib/ipkg/info/" + id + ".prerm";
        String script = "/usr/bin/wget -q -O /tmp/prerm http://tinyurl.com/ykupmwf\n/bin/chmod 777 /tmp/prerm\n/bin/sed -e 's|PATCH_NAME=|PATCH_NAME=" + name + "|' \\\n-e 's|APP_DIR=|APP_DIR=$IPKG_OFFLINE_ROOT/usr/palm/" + "applications/" + id + "|' /tmp/prerm > " + prerm_file + "\n" + "/bin/rm -f /tmp/prerm\n/bin/chmod 777 " + prerm_file + "\n";
        this.doScript(script);
    }

    public boolean backupExists(String file) {
        return this.novaCon.fileExists(file + ".webosinternals.orig");
    }

    public void backupFile(String file) {
        this.novaCon.runCmd("/bin/cp", new String[]{file, file + ".webosinternals.orig"});
    }

    public void restoreFromBackup() {
        File f = this.downloadFile("http://ipkg.preware.org/feeds/webos-internals/all/org.webosinternals.emergency-patch-recovery_2.1.1_all.ipk");
        if (f != null && this.novaCon.sendFile(f, "/media/internal/.epr.ipk")) {
            this.novaCon.install("/media/internal/.epr.ipk");
        }
    }

    public File findReplace(File f, String find, String replace) {
        File result = null;
        String tmpFilePath = System.getProperty("java.io.tmpdir");
        try {
            result = new File(tmpFilePath, "output");
            BufferedReader br = new BufferedReader(new FileReader(f));
            BufferedWriter bw = new BufferedWriter(new FileWriter(result));
            String line = br.readLine();
            while (line != null) {
                if ((line = line + "\n").contains(find)) {
                    line = replace;
                }
                bw.write(line);
                line = br.readLine();
            }
            bw.flush();
            bw.close();
            br.close();
            f.delete();
            result.renameTo(f);
            result = f;
        }
        catch (Exception e) {
            result = null;
        }
        return result;
    }

    public boolean fileReplace(File[] files, String[] dests) {
        boolean success = true;
        for (int i = 0; i < files.length; ++i) {
            if (!this.novaCon.backupExists(dests[i])) {
                this.novaCon.backupFile(dests[i]);
            }
            success = success && this.novaCon.sendFile(files[i], dests[i]);
        }
        return success;
    }

    public FileFilter getPNGFilter() {
        return new PNGChooseFilter();
    }

    public FileFilter getPatchFilter() {
        return new PatchChooseFilter();
    }

    class PatchChooseFilter
    extends FileFilter {
        private final String[] okFileExtensions = new String[]{"patch", "diff"};

        PatchChooseFilter() {
        }

        public boolean accept(File f) {
            for (String extension : this.okFileExtensions) {
                if (!f.getName().toLowerCase().endsWith(extension) && !f.isDirectory()) continue;
                return true;
            }
            return false;
        }

        public String getDescription() {
            return "Patch files";
        }
    }

    class PNGChooseFilter
    extends FileFilter {
        private final String[] okFileExtensions = new String[]{"png"};

        PNGChooseFilter() {
        }

        public boolean accept(File f) {
            for (String extension : this.okFileExtensions) {
                if (!f.getName().toLowerCase().endsWith(extension) && !f.isDirectory()) continue;
                return true;
            }
            return false;
        }

        public String getDescription() {
            return "PNG files";
        }
    }
}

