/*
 * Decompiled with CFR 0.152.
 */
package ca.canucksoftware;

import ca.canucksoftware.NovacomConnection;
import ca.canucksoftware.WebOSQuickInstallApp;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.UIManager;
import org.jdesktop.application.Application;
import org.jdesktop.application.ResourceMap;

public class ReceiveFile
extends JDialog {
    public Timer t;
    private NovacomConnection novaCon;
    private File dest;
    private String src;
    private boolean transferStarted;
    private JButton jButton1;
    private JButton jButton2;
    private JButton jButton3;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLayeredPane jLayeredPane1;
    private JLayeredPane jLayeredPane2;
    private JTextField jTextField1;
    private JTextField jTextField2;

    public ReceiveFile(Frame parent) {
        super(parent);
        this.initComponents();
        this.novaCon = new NovacomConnection();
        this.dest = null;
        this.transferStarted = false;
    }

    public void startTransfer() {
        if (this.dest != null && this.dest.exists()) {
            this.transferStarted = true;
            this.jButton1.setEnabled(false);
            this.jButton2.setEnabled(false);
            this.jButton3.setEnabled(false);
            this.jTextField2.setEnabled(false);
            this.setDefaultCloseOperation(0);
            this.jButton2.setText("Please wait...");
            this.src = this.formatSrc(this.jTextField1.getText());
            this.t = new Timer();
            this.t.schedule((TimerTask)new DoTransfer(), 200L);
        }
    }

    private String formatSrc(String file) {
        String result = null;
        result = file.replace("\\", "/");
        if (!result.startsWith("/")) {
            result = "/" + result;
        }
        return result;
    }

    public void closeCustTransfer() {
        this.dispose();
    }

    private String getFilename(String path) {
        String result = path;
        if (result.lastIndexOf("/") != -1) {
            result = result.substring(result.lastIndexOf("/") + 1);
        }
        if (result.lastIndexOf("\\") != -1) {
            result = result.substring(result.lastIndexOf("\\") + 1);
        }
        return result;
    }

    private void deleteExisting(File f) {
        if (f.exists()) {
            f.delete();
        }
    }

    private void loadFileChooser() {
        JFileChooser fc = new JFileChooser();
        fc.setDialogTitle("");
        fc.setFileSelectionMode(1);
        this.disableNewFolderButton(fc);
        if (fc.showDialog(this.rootPane, "Select") == 0) {
            this.dest = fc.getSelectedFile();
            try {
                this.jTextField2.setText(this.dest.getCanonicalPath());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void disableNewFolderButton(Container c) {
        int len = c.getComponentCount();
        for (int i = 0; i < len; ++i) {
            Component comp = c.getComponent(i);
            if (comp instanceof JButton) {
                JButton b = (JButton)comp;
                Icon icon = b.getIcon();
                if (icon == null || icon != UIManager.getIcon("FileChooser.newFolderIcon") && icon != UIManager.getIcon("FileChooser.upFolderIcon")) continue;
                b.setEnabled(false);
                continue;
            }
            if (!(comp instanceof Container)) continue;
            this.disableNewFolderButton((Container)comp);
        }
    }

    private void initComponents() {
        this.jLayeredPane1 = new JLayeredPane();
        this.jLayeredPane2 = new JLayeredPane();
        this.jLabel1 = new JLabel();
        this.jButton1 = new JButton();
        this.jButton2 = new JButton();
        this.jTextField2 = new JTextField();
        this.jLabel2 = new JLabel();
        this.jTextField1 = new JTextField();
        this.jButton3 = new JButton();
        this.setDefaultCloseOperation(2);
        ResourceMap resourceMap = Application.getInstance(WebOSQuickInstallApp.class).getContext().getResourceMap(ReceiveFile.class);
        this.setTitle(resourceMap.getString("title", new Object[0]));
        this.setBackground(resourceMap.getColor("transfer.background"));
        this.setForeground(resourceMap.getColor("transfer.foreground"));
        this.setIconImage(null);
        this.setModal(true);
        this.setName("transfer");
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            public void windowActivated(WindowEvent evt) {
                ReceiveFile.this.formWindowActivated(evt);
            }

            public void windowClosed(WindowEvent evt) {
                ReceiveFile.this.formWindowClosed(evt);
            }

            public void windowOpened(WindowEvent evt) {
                ReceiveFile.this.formWindowOpened(evt);
            }
        });
        this.jLayeredPane1.setName("jLayeredPane1");
        this.jLayeredPane2.setBorder(BorderFactory.createLineBorder(resourceMap.getColor("jLayeredPane2.border.lineColor")));
        this.jLayeredPane2.setName("jLayeredPane2");
        this.jLabel1.setFont(resourceMap.getFont("jLabel1.font"));
        this.jLabel1.setText(resourceMap.getString("jLabel1.text", new Object[0]));
        this.jLabel1.setName("jLabel1");
        this.jLabel1.setBounds(20, 60, 130, 20);
        this.jLayeredPane2.add((Component)this.jLabel1, JLayeredPane.DEFAULT_LAYER);
        this.jButton1.setText(resourceMap.getString("jButton1.text", new Object[0]));
        this.jButton1.setName("jButton1");
        this.jButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ReceiveFile.this.jButton1ActionPerformed(evt);
            }
        });
        this.jButton1.setBounds(400, 60, 45, 25);
        this.jLayeredPane2.add((Component)this.jButton1, JLayeredPane.DEFAULT_LAYER);
        this.jButton2.setFont(resourceMap.getFont("jButton2.font"));
        this.jButton2.setText(resourceMap.getString("jButton2.text", new Object[0]));
        this.jButton2.setName("jButton2");
        this.jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ReceiveFile.this.jButton2ActionPerformed(evt);
            }
        });
        this.jButton2.setBounds(110, 100, 140, 25);
        this.jLayeredPane2.add((Component)this.jButton2, JLayeredPane.DEFAULT_LAYER);
        this.jTextField2.setText(resourceMap.getString("jTextField2.text", new Object[0]));
        this.jTextField2.setEnabled(false);
        this.jTextField2.setName("jTextField2");
        this.jTextField2.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                ReceiveFile.this.jTextField2MouseClicked(evt);
            }
        });
        this.jTextField2.setBounds(150, 60, 240, 22);
        this.jLayeredPane2.add((Component)this.jTextField2, JLayeredPane.DEFAULT_LAYER);
        this.jLabel2.setFont(resourceMap.getFont("jLabel2.font"));
        this.jLabel2.setText(resourceMap.getString("jLabel2.text", new Object[0]));
        this.jLabel2.setName("jLabel2");
        this.jLabel2.setBounds(20, 20, 30, 20);
        this.jLayeredPane2.add((Component)this.jLabel2, JLayeredPane.DEFAULT_LAYER);
        this.jTextField1.setText(resourceMap.getString("jTextField1.text", new Object[0]));
        this.jTextField1.setName("jTextField1");
        this.jTextField1.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                ReceiveFile.this.jTextField1MouseClicked(evt);
            }
        });
        this.jTextField1.setBounds(60, 20, 360, 24);
        this.jLayeredPane2.add((Component)this.jTextField1, JLayeredPane.DEFAULT_LAYER);
        this.jButton3.setFont(resourceMap.getFont("jButton3.font"));
        this.jButton3.setText(resourceMap.getString("jButton3.text", new Object[0]));
        this.jButton3.setName("jButton3");
        this.jButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ReceiveFile.this.jButton3ActionPerformed(evt);
            }
        });
        this.jButton3.setBounds(270, 100, 79, 25);
        this.jLayeredPane2.add((Component)this.jButton3, JLayeredPane.DEFAULT_LAYER);
        this.jLayeredPane2.setBounds(10, 10, 450, 140);
        this.jLayeredPane1.add((Component)this.jLayeredPane2, JLayeredPane.DEFAULT_LAYER);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLayeredPane1, -1, 470, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLayeredPane1, -1, 160, Short.MAX_VALUE));
        this.pack();
    }

    private void formWindowOpened(WindowEvent evt) {
    }

    private void formWindowActivated(WindowEvent evt) {
    }

    private void formWindowClosed(WindowEvent evt) {
    }

    private void jTextField1MouseClicked(MouseEvent evt) {
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        this.loadFileChooser();
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        this.startTransfer();
    }

    private void jButton3ActionPerformed(ActionEvent evt) {
        this.closeCustTransfer();
    }

    private void jTextField2MouseClicked(MouseEvent evt) {
        if (!this.transferStarted) {
            this.loadFileChooser();
        }
    }

    class DoTransfer
    extends TimerTask {
        DoTransfer() {
        }

        public void run() {
            ReceiveFile.this.t.cancel();
            if (ReceiveFile.this.novaCon.connect(false)) {
                ReceiveFile.this.dest = new File(ReceiveFile.this.dest.getPath() + File.separator + ReceiveFile.this.getFilename(ReceiveFile.this.src));
                ReceiveFile.this.deleteExisting(ReceiveFile.this.dest);
                if (ReceiveFile.this.novaCon.receiveFile(ReceiveFile.this.src, ReceiveFile.this.dest, false)) {
                    JOptionPane.showMessageDialog(ReceiveFile.this.rootPane, "File transferred successfully.");
                }
            }
            ReceiveFile.this.novaCon.close();
            ReceiveFile.this.jButton1.setEnabled(true);
            ReceiveFile.this.jButton2.setEnabled(true);
            ReceiveFile.this.jButton3.setEnabled(true);
            ReceiveFile.this.jTextField2.setEnabled(true);
            ReceiveFile.this.setDefaultCloseOperation(2);
            ReceiveFile.this.jButton2.setText("Got From Device!");
            ReceiveFile.this.dispose();
        }
    }
}

