/*
 * Decompiled with CFR 0.152.
 */
package ca.canucksoftware;

import ca.canucksoftware.NovacomConnection;
import ca.canucksoftware.Themer;
import ca.canucksoftware.WebOSQuickInstallApp;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.GroupLayout;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import org.jdesktop.application.Application;
import org.jdesktop.application.ResourceMap;

public class ThemeChanging
extends JDialog {
    private NovacomConnection novaCon;
    private Themer themer;
    private String currTheme;
    private String url;
    private boolean transferStarted;
    private DoTransfer process;
    private JLabel jLabel2;
    private JLayeredPane jLayeredPane1;

    public ThemeChanging(Frame parent, NovacomConnection nc, Themer t, String curr, String link) {
        super(parent);
        this.initComponents();
        this.transferStarted = false;
        this.novaCon = nc;
        this.themer = t;
        this.currTheme = curr;
        this.url = link;
    }

    private void initComponents() {
        this.jLayeredPane1 = new JLayeredPane();
        this.jLabel2 = new JLabel();
        this.setDefaultCloseOperation(0);
        ResourceMap resourceMap = Application.getInstance(WebOSQuickInstallApp.class).getContext().getResourceMap(ThemeChanging.class);
        this.setTitle(resourceMap.getString("title", new Object[0]));
        this.setBackground(resourceMap.getColor("transfer.background"));
        this.setCursor(new Cursor(3));
        this.setForeground(resourceMap.getColor("transfer.foreground"));
        this.setIconImage(null);
        this.setModal(true);
        this.setName("transfer");
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            public void windowActivated(WindowEvent evt) {
                ThemeChanging.this.formWindowActivated(evt);
            }

            public void windowClosed(WindowEvent evt) {
                ThemeChanging.this.formWindowClosed(evt);
            }

            public void windowOpened(WindowEvent evt) {
                ThemeChanging.this.formWindowOpened(evt);
            }
        });
        this.jLayeredPane1.setBackground(resourceMap.getColor("jLayeredPane1.background"));
        this.jLayeredPane1.setForeground(resourceMap.getColor("jLayeredPane1.foreground"));
        this.jLayeredPane1.setName("jLayeredPane1");
        this.jLayeredPane1.setOpaque(true);
        this.jLabel2.setFont(resourceMap.getFont("jLabel2.font"));
        this.jLabel2.setHorizontalAlignment(0);
        this.jLabel2.setText(resourceMap.getString("jLabel2.text", new Object[0]));
        this.jLabel2.setName("jLabel2");
        this.jLabel2.setBounds(10, 10, 240, 50);
        this.jLayeredPane1.add((Component)this.jLabel2, JLayeredPane.DEFAULT_LAYER);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLayeredPane1, -2, 264, -2));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLayeredPane1, -2, 72, -2));
        this.pack();
    }

    private void formWindowOpened(WindowEvent evt) {
    }

    private void formWindowActivated(WindowEvent evt) {
        if (!this.transferStarted) {
            this.process = new DoTransfer();
            this.process.start();
            this.transferStarted = true;
        }
    }

    private void formWindowClosed(WindowEvent evt) {
        this.transferStarted = false;
        this.jLabel2.setText("<html>");
    }

    private class DoTransfer
    extends Thread {
        private DoTransfer() {
        }

        public void run() {
            if (ThemeChanging.this.currTheme != null) {
                ThemeChanging.this.jLabel2.setText("<html>Uninstalling current theme");
                if (ThemeChanging.this.novaCon.uninstall(ThemeChanging.this.currTheme)) {
                    ((ThemeChanging)ThemeChanging.this).novaCon.restartLuna |= true;
                }
            }
            if (ThemeChanging.this.url != null) {
                ThemeChanging.this.jLabel2.setText("<html>Downloading and installing new theme");
                if (ThemeChanging.this.themer.installFromURL(ThemeChanging.this.url)) {
                    ((ThemeChanging)ThemeChanging.this).novaCon.restartLuna |= true;
                }
            }
            ThemeChanging.this.novaCon.finishIpkgAction();
            ThemeChanging.this.dispose();
        }
    }
}

