/*
 * Decompiled with CFR 0.152.
 */
package ca.canucksoftware;

import ca.canucksoftware.AppInfoBox;
import ca.canucksoftware.AppInfoEntry;
import ca.canucksoftware.NovacomConnection;
import ca.canucksoftware.PackageFeed;
import ca.canucksoftware.ThemeChanging;
import ca.canucksoftware.Themer;
import ca.canucksoftware.WebOSQuickInstallApp;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URI;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.table.DefaultTableModel;
import org.jdesktop.application.Application;
import org.jdesktop.application.ResourceMap;

public class ThemeChooser
extends JDialog {
    public boolean dontOpen;
    private AppInfoBox infoBox;
    private ThemeChanging changingBox;
    private NovacomConnection novaCon;
    private PackageFeed themeFeeds;
    private AppInfoEntry currThemeInfo;
    private String currThemeID;
    private Themer themer;
    private ArrayList<AppInfoEntry> filtered;
    private ButtonGroup buttonGroup1;
    private JButton jButton1;
    private JButton jButton2;
    private JButton jButton3;
    private JComboBox jComboBox1;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLayeredPane jLayeredPane1;
    private JLayeredPane jLayeredPane2;
    private JLayeredPane jLayeredPane3;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane3;
    private JTable jTable1;
    private JTable jTable2;
    private JTextArea jTextArea1;

    public ThemeChooser(Frame parent) {
        super(parent);
        this.initComponents();
        this.getRootPane().setDefaultButton(this.jButton1);
        this.dontOpen = false;
        this.getContentPane().requestFocus();
        this.novaCon = new NovacomConnection();
        if (this.novaCon.connect(true)) {
            this.jLabel6.setCursor(Cursor.getPredefinedCursor(12));
            this.load();
        } else if (JOptionPane.showConfirmDialog(parent, "Please connect your device then hit \"OK\"", "No Device Detected", 2, 2) == 0) {
            if (this.novaCon.connect(true)) {
                this.jLabel6.setCursor(Cursor.getPredefinedCursor(12));
                this.load();
            } else {
                JOptionPane.showMessageDialog(parent, "ERROR: No device detected.", "ERROR", 0);
                this.dontOpen = true;
            }
        } else {
            this.dontOpen = true;
        }
    }

    private void load() {
        DefaultTableModel modTable = (DefaultTableModel)this.jTable2.getModel();
        modTable.addRow(new Object[]{"Loading themes feeds...", Boolean.FALSE});
        this.themer = new Themer(this.novaCon);
        new LoadCurrentTheme().start();
        new LoadThemeRepo().start();
    }

    private void closeInfo() {
        this.dispose();
    }

    private String removeHTML(String s) {
        s = s.replaceAll("</p>", "\n\n");
        s = s.replaceAll("<br>", "\n");
        s = s.replaceAll("<ul>", "\n");
        s = s.replaceAll("<ol>", "\n");
        s = s.replaceAll("<li>", "    - ");
        s = s.replaceAll("\t", "    ");
        s = s.replaceAll("</li>", "\n");
        s = s.replaceAll("\\<.*?\\>", "");
        s = s.replaceAll("&rsquo;", "'");
        s = s.replaceAll("&nbsp;", " ");
        s = s.replaceAll("&#58;", ":");
        s = s.replaceAll("&quot;", "\"");
        s = s.replaceAll("&amp;", "&");
        s = s.replaceAll("&lt;", "<");
        s = s.replaceAll("&gt;", ">");
        s = s.replaceAll("&raquo;", "\"");
        s = s.replaceAll("&laquo;", "\"");
        s = s.replaceAll("&raquo;", "\"");
        s = s.replaceAll("&copy;", "\u00a9");
        s = s.replaceAll("&reg;", "\u00ae");
        return s;
    }

    private void setState(boolean enabled) {
        this.jButton3.setEnabled(enabled && this.currThemeID != null);
        this.jButton1.setEnabled(enabled);
        this.jComboBox1.setEnabled(enabled);
        this.jTable2.setEnabled(enabled);
        this.jButton2.setEnabled(enabled);
        if (enabled) {
            this.jButton2.setText("Install Selected Theme");
        } else {
            this.jButton2.setText("Please wait...");
        }
    }

    private void loadCategory(String category) {
        DefaultTableModel modTable = (DefaultTableModel)this.jTable2.getModel();
        while (modTable.getRowCount() > 0) {
            modTable.removeRow(0);
        }
        this.filtered = this.themeFeeds.getAppsByCategory(category);
        for (int i = 0; i < this.filtered.size(); ++i) {
            modTable.addRow(new Object[]{"<html>" + this.filtered.get((int)i).name, Boolean.FALSE});
        }
    }

    private void launchInfo(int index) {
        if (index > -1) {
            JFrame mainFrame = WebOSQuickInstallApp.getApplication().getMainFrame();
            this.infoBox = new AppInfoBox((Frame)mainFrame, this.filtered.get(index));
            this.infoBox.setLocationRelativeTo(mainFrame);
            WebOSQuickInstallApp.getApplication().show(this.infoBox);
        }
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jLayeredPane1 = new JLayeredPane();
        this.jLayeredPane2 = new JLayeredPane();
        this.jLabel6 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jLabel1 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jTextArea1 = new JTextArea();
        this.jButton1 = new JButton();
        this.jButton3 = new JButton();
        this.jLayeredPane3 = new JLayeredPane();
        this.jComboBox1 = new JComboBox();
        this.jLabel5 = new JLabel();
        this.jScrollPane3 = new JScrollPane();
        this.jTable2 = new JTable();
        this.jButton2 = new JButton();
        this.setDefaultCloseOperation(2);
        ResourceMap resourceMap = Application.getInstance(WebOSQuickInstallApp.class).getContext().getResourceMap(ThemeChooser.class);
        this.setTitle(resourceMap.getString("title", new Object[0]));
        this.setBackground(resourceMap.getColor("Form.background"));
        this.setForeground(resourceMap.getColor("Form.foreground"));
        this.setIconImage(null);
        this.setModal(true);
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            public void windowActivated(WindowEvent evt) {
                ThemeChooser.this.formWindowActivated(evt);
            }

            public void windowClosed(WindowEvent evt) {
                ThemeChooser.this.formWindowClosed(evt);
            }

            public void windowOpened(WindowEvent evt) {
                ThemeChooser.this.formWindowOpened(evt);
            }
        });
        this.jLayeredPane1.setName("jLayeredPane1");
        this.jLayeredPane1.setOpaque(true);
        this.jLayeredPane2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(0), resourceMap.getString("jLayeredPane2.border.title", new Object[0]), 0, 0, resourceMap.getFont("jLayeredPane2.border.titleFont")));
        this.jLayeredPane2.setName("jLayeredPane2");
        this.jLayeredPane2.setOpaque(true);
        this.jLabel6.setFont(resourceMap.getFont("jLabel6.font"));
        this.jLabel6.setText(resourceMap.getString("jLabel6.text", new Object[0]));
        this.jLabel6.setName("jLabel6");
        this.jLabel6.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                ThemeChooser.this.jLabel6MouseClicked(evt);
            }
        });
        this.jLabel6.setBounds(90, 120, 130, 20);
        this.jLayeredPane2.add((Component)this.jLabel6, JLayeredPane.DEFAULT_LAYER);
        this.jLabel3.setFont(resourceMap.getFont("jLabel3.font"));
        this.jLabel3.setText(resourceMap.getString("jLabel3.text", new Object[0]));
        this.jLabel3.setName("jLabel3");
        this.jLabel3.setBounds(20, 90, 220, 20);
        this.jLayeredPane2.add((Component)this.jLabel3, JLayeredPane.DEFAULT_LAYER);
        this.jLabel1.setFont(resourceMap.getFont("jLabel1.font"));
        this.jLabel1.setText(resourceMap.getString("jLabel1.text", new Object[0]));
        this.jLabel1.setName("jLabel1");
        this.jLabel1.setBounds(20, 30, 220, 20);
        this.jLayeredPane2.add((Component)this.jLabel1, JLayeredPane.DEFAULT_LAYER);
        this.jLabel4.setFont(resourceMap.getFont("jLabel4.font"));
        this.jLabel4.setText(resourceMap.getString("jLabel4.text", new Object[0]));
        this.jLabel4.setName("jLabel4");
        this.jLabel4.setBounds(20, 120, 80, 20);
        this.jLayeredPane2.add((Component)this.jLabel4, JLayeredPane.DEFAULT_LAYER);
        this.jLabel2.setFont(resourceMap.getFont("jLabel2.font"));
        this.jLabel2.setText(resourceMap.getString("jLabel2.text", new Object[0]));
        this.jLabel2.setName("jLabel2");
        this.jLabel2.setBounds(20, 60, 220, 20);
        this.jLayeredPane2.add((Component)this.jLabel2, JLayeredPane.DEFAULT_LAYER);
        this.jScrollPane1.setBorder(null);
        this.jScrollPane1.setName("jScrollPane1");
        this.jTextArea1.setBackground(resourceMap.getColor("jTextArea1.background"));
        this.jTextArea1.setColumns(20);
        this.jTextArea1.setEditable(false);
        this.jTextArea1.setFont(resourceMap.getFont("jTextArea1.font"));
        this.jTextArea1.setLineWrap(true);
        this.jTextArea1.setRows(3);
        this.jTextArea1.setWrapStyleWord(true);
        this.jTextArea1.setMargin(new Insets(2, 0, 2, 2));
        this.jTextArea1.setName("jTextArea1");
        this.jScrollPane1.setViewportView(this.jTextArea1);
        this.jScrollPane1.setBounds(20, 150, 210, 150);
        this.jLayeredPane2.add((Component)this.jScrollPane1, JLayeredPane.DEFAULT_LAYER);
        this.jLayeredPane2.setBounds(10, 10, 250, 310);
        this.jLayeredPane1.add((Component)this.jLayeredPane2, JLayeredPane.DEFAULT_LAYER);
        this.jButton1.setText(resourceMap.getString("jButton1.text", new Object[0]));
        this.jButton1.setName("jButton1");
        this.jButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ThemeChooser.this.jButton1ActionPerformed(evt);
            }
        });
        this.jButton1.setBounds(90, 370, 80, 23);
        this.jLayeredPane1.add((Component)this.jButton1, JLayeredPane.DEFAULT_LAYER);
        this.jButton3.setText(resourceMap.getString("jButton3.text", new Object[0]));
        this.jButton3.setEnabled(false);
        this.jButton3.setName("jButton3");
        this.jButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ThemeChooser.this.jButton3ActionPerformed(evt);
            }
        });
        this.jButton3.setBounds(40, 330, 180, 30);
        this.jLayeredPane1.add((Component)this.jButton3, JLayeredPane.DEFAULT_LAYER);
        this.jLayeredPane3.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(resourceMap.getColor("jLayeredPane3.border.border.lineColor")), resourceMap.getString("jLayeredPane3.border.title", new Object[0]), 0, 0, resourceMap.getFont("jLayeredPane3.border.titleFont")));
        this.jLayeredPane3.setName("jLayeredPane3");
        this.jComboBox1.setFont(resourceMap.getFont("jComboBox1.font"));
        this.jComboBox1.setName("jComboBox1");
        this.jComboBox1.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                ThemeChooser.this.jComboBox1PropertyChange(evt);
            }
        });
        this.jComboBox1.setBounds(90, 20, 200, 25);
        this.jLayeredPane3.add((Component)this.jComboBox1, JLayeredPane.DEFAULT_LAYER);
        this.jLabel5.setFont(resourceMap.getFont("jLabel5.font"));
        this.jLabel5.setText(resourceMap.getString("jLabel5.text", new Object[0]));
        this.jLabel5.setName("jLabel5");
        this.jLabel5.setBounds(10, 20, 80, 25);
        this.jLayeredPane3.add((Component)this.jLabel5, JLayeredPane.DEFAULT_LAYER);
        this.jScrollPane3.setName("jScrollPane3");
        this.jTable2.setModel(new DefaultTableModel(new Object[0][], new String[]{"Name", ""}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{String.class, Boolean.class};
                this.canEdit = new boolean[]{false, true};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.jTable2.setFillsViewportHeight(true);
        this.jTable2.setName("jTable2");
        this.jTable2.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent evt) {
                ThemeChooser.this.jTable2MousePressed(evt);
            }

            public void mouseReleased(MouseEvent evt) {
                ThemeChooser.this.jTable2MouseReleased(evt);
            }
        });
        this.jScrollPane3.setViewportView(this.jTable2);
        this.jTable2.getColumnModel().getColumn(0).setResizable(false);
        this.jTable2.getColumnModel().getColumn(0).setHeaderValue(resourceMap.getString("jTable2.columnModel.title0", new Object[0]));
        this.jTable2.getColumnModel().getColumn(1).setMinWidth(35);
        this.jTable2.getColumnModel().getColumn(1).setPreferredWidth(35);
        this.jTable2.getColumnModel().getColumn(1).setMaxWidth(35);
        this.jTable2.getColumnModel().getColumn(1).setHeaderValue(resourceMap.getString("jTable2.columnModel.title1", new Object[0]));
        this.jScrollPane3.setBounds(20, 60, 260, 270);
        this.jLayeredPane3.add((Component)this.jScrollPane3, JLayeredPane.DEFAULT_LAYER);
        this.jButton2.setFont(resourceMap.getFont("jButton2.font"));
        this.jButton2.setText(resourceMap.getString("jButton2.text", new Object[0]));
        this.jButton2.setName("jButton2");
        this.jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ThemeChooser.this.jButton2ActionPerformed(evt);
            }
        });
        this.jButton2.setBounds(70, 340, 170, 25);
        this.jLayeredPane3.add((Component)this.jButton2, JLayeredPane.DEFAULT_LAYER);
        this.jLayeredPane3.setBounds(270, 10, 300, 380);
        this.jLayeredPane1.add((Component)this.jLayeredPane3, JLayeredPane.DEFAULT_LAYER);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLayeredPane1, -1, 582, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLayeredPane1, -1, 402, Short.MAX_VALUE));
        this.pack();
    }

    private void formWindowOpened(WindowEvent evt) {
    }

    private void formWindowActivated(WindowEvent evt) {
    }

    private void formWindowClosed(WindowEvent evt) {
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        this.closeInfo();
    }

    private void jLabel6MouseClicked(MouseEvent evt) {
        try {
            Desktop.getDesktop().browse(new URI(this.currThemeInfo.source.getString("Homepage")));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void jButton3ActionPerformed(ActionEvent evt) {
        JFrame mainFrame = WebOSQuickInstallApp.getApplication().getMainFrame();
        this.changingBox = new ThemeChanging(mainFrame, this.novaCon, this.themer, this.currThemeID, null);
        this.changingBox.setLocationRelativeTo(mainFrame);
        WebOSQuickInstallApp.getApplication().show(this.changingBox);
        new LoadCurrentTheme().run();
    }

    private void jComboBox1PropertyChange(PropertyChangeEvent evt) {
        if (this.themeFeeds != null) {
            this.loadCategory((String)this.jComboBox1.getSelectedItem());
        }
    }

    private void jTable2MousePressed(MouseEvent evt) {
        int i = this.jTable2.rowAtPoint(evt.getPoint());
        if (i > -1) {
            if (this.jTable2.columnAtPoint(evt.getPoint()) == 0) {
                this.launchInfo(i);
            } else if (this.jTable2.columnAtPoint(evt.getPoint()) == 1) {
                DefaultTableModel modTable = (DefaultTableModel)this.jTable2.getModel();
                for (int j = 0; j < modTable.getRowCount(); ++j) {
                    if (j == i) {
                        modTable.setValueAt(Boolean.TRUE, j, 1);
                        continue;
                    }
                    modTable.setValueAt(Boolean.FALSE, j, 1);
                }
            }
        }
        this.jTable2.removeRowSelectionInterval(this.jTable2.getSelectedRow(), this.jTable2.getSelectedRow());
    }

    private void jTable2MouseReleased(MouseEvent evt) {
        int i = this.jTable2.getSelectedRow();
        if (i > -1) {
            this.jTable2.removeRowSelectionInterval(i, i);
        }
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        DefaultTableModel modTable = (DefaultTableModel)this.jTable2.getModel();
        for (int i = 0; i < modTable.getRowCount(); ++i) {
            if (modTable.getValueAt(i, 1) != Boolean.TRUE) continue;
            JFrame mainFrame = WebOSQuickInstallApp.getApplication().getMainFrame();
            this.changingBox = new ThemeChanging(mainFrame, this.novaCon, this.themer, this.currThemeID, this.filtered.get((int)i).file);
            this.changingBox.setLocationRelativeTo(mainFrame);
            WebOSQuickInstallApp.getApplication().show(this.changingBox);
            new LoadCurrentTheme().run();
            break;
        }
    }

    private class LoadThemeRepo
    extends Thread {
        private LoadThemeRepo() {
        }

        public void run() {
            ThemeChooser.this.themeFeeds = ThemeChooser.this.themer.loadThemeFeeds();
            for (int i = 0; i < ((ThemeChooser)ThemeChooser.this).themeFeeds.categories.size(); ++i) {
                ThemeChooser.this.jComboBox1.addItem(((ThemeChooser)ThemeChooser.this).themeFeeds.categories.get(i));
            }
            ThemeChooser.this.jComboBox1.setSelectedIndex(0);
        }
    }

    private class LoadCurrentTheme
    extends Thread {
        private LoadCurrentTheme() {
        }

        public void run() {
            ThemeChooser.this.currThemeID = ThemeChooser.this.themer.installedTheme();
            if (ThemeChooser.this.currThemeID == null) {
                ThemeChooser.this.currThemeInfo = ((ThemeChooser)ThemeChooser.this).themer.DEFAULT_THEME;
            } else {
                ThemeChooser.this.currThemeInfo = ThemeChooser.this.themer.themeInfo(ThemeChooser.this.currThemeID);
                ThemeChooser.this.jButton3.setEnabled(true);
            }
            ThemeChooser.this.jLabel1.setText("Name:  " + ((ThemeChooser)ThemeChooser.this).currThemeInfo.name);
            ThemeChooser.this.jLabel2.setText("Version:  " + ((ThemeChooser)ThemeChooser.this).currThemeInfo.version);
            ThemeChooser.this.jLabel3.setText("Creator:  " + ((ThemeChooser)ThemeChooser.this).currThemeInfo.developer);
            try {
                String descript = "";
                if (((ThemeChooser)ThemeChooser.this).currThemeInfo.source.has("FullDescription")) {
                    descript = ((ThemeChooser)ThemeChooser.this).currThemeInfo.source.getString("FullDescription");
                    descript = ThemeChooser.this.removeHTML(descript);
                }
                ThemeChooser.this.jTextArea1.setText(descript);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

