/*
 * Decompiled with CFR 0.152.
 */
package ca.canucksoftware;

import ca.canucksoftware.AppInfoEntry;
import ca.canucksoftware.NovacomConnection;
import ca.canucksoftware.PackageFeed;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.List;
import javax.swing.JOptionPane;
import org.json.JSONObject;

public class Themer {
    public final AppInfoEntry DEFAULT_THEME;
    private final String PRECENTRAL_FEED = "http://ipkg.preware.org/feeds/precentral-themes/Packages.gz";
    private final String PRETHEMER_FEED = "http://www.prethemer.com/feeds/preware/themes/Packages.gz";
    private NovacomConnection novaCon;

    public Themer(NovacomConnection nc) {
        this.novaCon = nc;
        this.DEFAULT_THEME = new AppInfoEntry(this.novaCon);
        this.DEFAULT_THEME.name = "Default Theme";
        this.DEFAULT_THEME.version = "N/A";
        this.DEFAULT_THEME.developer = "Palm Inc.";
        this.DEFAULT_THEME.source = new JSONObject();
        try {
            this.DEFAULT_THEME.source.put("Homepage", "http://www.palm.com");
            this.DEFAULT_THEME.source.put("FullDescription", "The default Palm WebOS theme included on the device.");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String installedTheme() {
        String theme = this.readThemeIndicator();
        List<String> installed = this.novaCon.listInstalled();
        if (theme != null && !installed.contains(theme)) {
            theme = null;
        }
        if (theme == null) {
            for (int i = 0; i < installed.size(); ++i) {
                if (!installed.get(i).startsWith("com.prethemer.theme.") && !installed.get(i).startsWith("net.precentral.themes.")) continue;
                theme = installed.get(i);
                break;
            }
        }
        return theme;
    }

    private String readThemeIndicator() {
        String tmpFilePath;
        File current;
        String result = null;
        if (this.novaCon.fileExists("/var/usr/lib/.theme/current_theme") && this.novaCon.receiveFile("/var/usr/lib/.theme/current_theme", current = new File(tmpFilePath = System.getProperty("java.io.tmpdir"), "current_theme"), true)) {
            try {
                BufferedReader br = new BufferedReader(new FileReader(current));
                result = br.readLine();
                br.close();
            }
            catch (Exception e) {
                // empty catch block
            }
            current.delete();
        }
        return result;
    }

    public AppInfoEntry themeInfo(String id) {
        AppInfoEntry info = new AppInfoEntry(this.novaCon);
        info.id = id;
        info.parseControl();
        return info;
    }

    public PackageFeed loadThemeFeeds() {
        int i;
        PackageFeed allThemes = new PackageFeed(null, this.novaCon);
        PackageFeed precentral = null;
        PackageFeed prethemer = null;
        precentral = PackageFeed.downloadFeed("http://ipkg.preware.org/feeds/precentral-themes/Packages.gz", this.novaCon);
        prethemer = PackageFeed.downloadFeed("http://www.prethemer.com/feeds/preware/themes/Packages.gz", this.novaCon);
        while (precentral == null && prethemer == null) {
        }
        if (!precentral.errorDownloading) {
            for (i = 0; i < precentral.apps.size(); ++i) {
                precentral.apps.get((int)i).file = "http://ipkg.preware.org/feeds/precentral-themes/" + precentral.apps.get((int)i).file;
            }
            allThemes.mergeFeed(precentral);
        }
        if (!prethemer.errorDownloading) {
            for (i = 0; i < prethemer.apps.size(); ++i) {
                prethemer.apps.get((int)i).file = "http://www.prethemer.com/feeds/preware/themes/" + prethemer.apps.get((int)i).file;
            }
            allThemes.mergeFeed(prethemer);
        }
        allThemes.sort(true);
        return allThemes;
    }

    private File downloadFile(String url) {
        URLConnection urlCon = null;
        String tmpFilePath = System.getProperty("java.io.tmpdir");
        File result = new File(tmpFilePath, url.substring(url.lastIndexOf("/") + 1));
        try {
            int len;
            urlCon = new URL(url).openConnection();
            urlCon.setRequestProperty("Content-Type", "application/binary");
            BufferedInputStream bis = new BufferedInputStream(urlCon.getInputStream());
            BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(result));
            byte[] buf = new byte[2048];
            while ((len = bis.read(buf)) > 0) {
                bos.write(buf, 0, len);
            }
            bos.flush();
            bis.close();
            bos.close();
        }
        catch (Exception e) {
            result = null;
        }
        return result;
    }

    public boolean installFromURL(String url) {
        boolean success = false;
        if (this.urlExists(url)) {
            File theme = this.downloadFile(url);
            if (theme != null) {
                if (this.novaCon.sendFile(theme, "/media/internal/.theme.ipk")) {
                    success = this.novaCon.install("/media/internal/.theme.ipk");
                }
            } else {
                JOptionPane.showMessageDialog(null, "Error: Theme download failed");
            }
        } else {
            JOptionPane.showMessageDialog(null, "Error: Unable to connect to url:\n\n" + url);
        }
        return success;
    }

    private boolean urlExists(String URLName) {
        boolean result = false;
        try {
            HttpURLConnection.setFollowRedirects(false);
            HttpURLConnection con = (HttpURLConnection)new URL(URLName).openConnection();
            con.setInstanceFollowRedirects(false);
            con.setConnectTimeout(3000);
            con.setReadTimeout(3000);
            con.setRequestMethod("HEAD");
            result = con.getResponseCode() == 200;
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }
}

