/*
 * Decompiled with CFR 0.152.
 */
package ca.canucksoftware;

import ca.canucksoftware.NovacomConnection;
import ca.canucksoftware.Patcher;
import ca.canucksoftware.WebOSQuickInstallApp;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.GroupLayout;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import org.jdesktop.application.Application;
import org.jdesktop.application.ResourceMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Transfer
extends JDialog {
    public Timer t;
    public boolean transferStarted;
    public ArrayList<File> installedList;
    private NovacomConnection novaCon;
    private Patcher patchMgr;
    private ArrayList<File> installList;
    private String filename;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLayeredPane jLayeredPane1;

    public Transfer(Frame parent, ArrayList<File> list) {
        super(parent);
        this.initComponents();
        this.installedList = new ArrayList(0);
        this.transferStarted = false;
        this.installList = list;
        this.novaCon = new NovacomConnection();
        this.patchMgr = new Patcher(this.novaCon);
    }

    private void processList() {
        boolean firstPatch = true;
        boolean goodToPatch = false;
        this.jLabel2.setText("<html>Connecting to device...");
        if (this.novaCon.connect(false)) {
            this.patchMgr.loadVersion();
            for (int i = 0; i < this.installList.size(); ++i) {
                this.filename = this.novaCon.getFilename(this.installList.get(i));
                if (!this.isPatch(this.filename)) {
                    this.jLabel2.setText("<html>Transferring:<br/>" + this.filename);
                    if (!this.novaCon.sendFile(this.installList.get(i), "/media/internal/." + this.filename)) continue;
                    this.jLabel2.setText("<html>Installing:<br/>" + this.filename);
                    if (!this.novaCon.install("/media/internal/." + this.filename)) continue;
                    this.installedList.add(this.installList.get(i));
                    continue;
                }
                if (firstPatch) {
                    goodToPatch = this.patchMgr.meetsRequirements();
                    this.patchMgr.loadInstalledList();
                    firstPatch = false;
                }
                if (!goodToPatch) continue;
                this.jLabel2.setText("<html>Transferring and applying:<br/>" + this.filename);
                if (!this.patchMgr.installPatch(this.installList.get(i))) continue;
                this.installedList.add(this.installList.get(i));
                this.novaCon.restartLuna = true;
            }
            this.novaCon.finishIpkgAction();
        }
    }

    private boolean isPatch(String s) {
        return s.endsWith(".patch") || s.endsWith(".diff");
    }

    private void initComponents() {
        this.jLayeredPane1 = new JLayeredPane();
        this.jLabel1 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel4 = new JLabel();
        this.setDefaultCloseOperation(0);
        ResourceMap resourceMap = Application.getInstance(WebOSQuickInstallApp.class).getContext().getResourceMap(Transfer.class);
        this.setTitle(resourceMap.getString("title", new Object[0]));
        this.setBackground(resourceMap.getColor("transfer.background"));
        this.setCursor(new Cursor(3));
        this.setForeground(resourceMap.getColor("transfer.foreground"));
        this.setIconImage(null);
        this.setModal(true);
        this.setName("transfer");
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            public void windowActivated(WindowEvent evt) {
                Transfer.this.formWindowActivated(evt);
            }

            public void windowClosed(WindowEvent evt) {
                Transfer.this.formWindowClosed(evt);
            }

            public void windowOpened(WindowEvent evt) {
                Transfer.this.formWindowOpened(evt);
            }
        });
        this.jLayeredPane1.setBackground(resourceMap.getColor("jLayeredPane1.background"));
        this.jLayeredPane1.setForeground(resourceMap.getColor("jLayeredPane1.foreground"));
        this.jLayeredPane1.setName("jLayeredPane1");
        this.jLayeredPane1.setOpaque(true);
        this.jLabel1.setBackground(resourceMap.getColor("jLabel1.background"));
        this.jLabel1.setForeground(resourceMap.getColor("jLabel1.foreground"));
        this.jLabel1.setIcon(resourceMap.getIcon("jLabel1.icon"));
        this.jLabel1.setText(resourceMap.getString("jLabel1.text", new Object[0]));
        this.jLabel1.setName("jLabel1");
        this.jLabel1.setOpaque(true);
        this.jLabel1.setBounds(120, 10, 60, 50);
        this.jLayeredPane1.add((Component)this.jLabel1, JLayeredPane.DEFAULT_LAYER);
        this.jLabel3.setHorizontalAlignment(0);
        this.jLabel3.setIcon(resourceMap.getIcon("jLabel3.icon"));
        this.jLabel3.setText(resourceMap.getString("jLabel3.text", new Object[0]));
        this.jLabel3.setVerticalAlignment(3);
        this.jLabel3.setName("jLabel3");
        this.jLabel3.setBounds(170, 10, 60, 50);
        this.jLayeredPane1.add((Component)this.jLabel3, JLayeredPane.DEFAULT_LAYER);
        this.jLabel2.setHorizontalAlignment(0);
        this.jLabel2.setText(resourceMap.getString("jLabel2.text", new Object[0]));
        this.jLabel2.setName("jLabel2");
        this.jLabel2.setBounds(30, 70, 240, 50);
        this.jLayeredPane1.add((Component)this.jLabel2, JLayeredPane.DEFAULT_LAYER);
        this.jLabel4.setIcon(resourceMap.getIcon("jLabel4.icon"));
        this.jLabel4.setVerticalAlignment(1);
        this.jLabel4.setName("jLabel4");
        this.jLabel4.setBounds(70, 10, 50, 50);
        this.jLayeredPane1.add((Component)this.jLabel4, JLayeredPane.DEFAULT_LAYER);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLayeredPane1, -2, 296, -2));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLayeredPane1, -1, 126, Short.MAX_VALUE));
        this.pack();
    }

    private void formWindowOpened(WindowEvent evt) {
    }

    private void formWindowActivated(WindowEvent evt) {
        if (!this.transferStarted) {
            this.t = new Timer();
            this.t.schedule((TimerTask)new DoTransfer(), 200L);
            this.transferStarted = true;
        }
    }

    private void formWindowClosed(WindowEvent evt) {
        this.transferStarted = false;
        this.jLabel2.setText("<html>");
    }

    class DoTransfer
    extends TimerTask {
        DoTransfer() {
        }

        public void run() {
            Transfer.this.t.cancel();
            Transfer.this.processList();
            Transfer.this.novaCon.close();
            Transfer.this.dispose();
        }
    }
}

