/*
 * Decompiled with CFR 0.152.
 */
package ca.canucksoftware;

import ca.canucksoftware.AppInfoEntry;
import ca.canucksoftware.NovacomConnection;
import ca.canucksoftware.PackageFeed;
import ca.canucksoftware.Patcher;
import ca.canucksoftware.Tweaks;
import ca.canucksoftware.WebOSQuickInstallApp;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.jdesktop.application.Application;
import org.jdesktop.application.ResourceMap;

public class UpdateTransition
extends JDialog {
    private NovacomConnection novaCon;
    private PackageFeed deviceFeed;
    private PackageFeed patchFeed;
    private Patcher patchMgr;
    private String[] patches;
    private Timer t;
    private boolean firstRun;
    private JButton jButton1;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLayeredPane jLayeredPane1;
    private JScrollPane jScrollPane1;
    private JTextArea jTextArea1;

    public UpdateTransition(Frame parent, NovacomConnection nc, PackageFeed df, PackageFeed pf, Patcher pm) {
        super(parent);
        this.initComponents();
        this.novaCon = nc;
        this.deviceFeed = df;
        this.patchFeed = pf;
        this.patchMgr = pm;
        this.patches = null;
        this.firstRun = true;
        this.t = new Timer();
        if (this.patches == null) {
            this.jLabel1.setText("<html>All patches are now being updated to webOS " + this.novaCon.getWebOSVersion() + "-compatible versions. If such a version does" + " not yet exist, the patch will be removed.");
        } else {
            this.jLabel1.setText("<html>It appears you've used webOSDoctor on your device. All on-feed patches are now being restored");
        }
        this.t.schedule((TimerTask)new DoTransition(), 100L);
    }

    private void appendLog(String line) {
        this.jTextArea1.append(line + "\n");
        this.jTextArea1.setCaretPosition(this.jTextArea1.getText().length());
    }

    private boolean doScript(String cmd) {
        return this.doScript(cmd, "/tmp/scriptFile.sh");
    }

    private boolean doScript(String cmd, String file) {
        String tmpFilePath = System.getProperty("java.io.tmpdir");
        boolean result = false;
        File script = new File(tmpFilePath, "script.sh");
        try {
            BufferedWriter bw = new BufferedWriter(new FileWriter(script));
            bw.write(cmd + "\n");
            bw.flush();
            bw.close();
            if (this.novaCon.sendFile(script, file)) {
                this.novaCon.runCmd("/bin/chmod", new String[]{"777", file});
                result = this.novaCon.runScript(file, false);
                this.novaCon.delFile(file);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return result;
    }

    private void restorePatches() {
        String script = "";
        String packages = "/media/internal/.webosinternals.patches.packages";
        for (int i = 0; i < this.patches.length; ++i) {
            AppInfoEntry curr = this.deviceFeed.getAppInfo(this.patches[i]);
            if (curr != null) continue;
            if (this.patches[i].startsWith("ca.canucksoftware.patches.")) {
                String patchName = this.patches[i].replaceFirst("ca.canucksoftware.patches.", "") + ".patch";
                script = script + "sed -i -e /\\^'" + this.patches[i] + " aupt-1'\\$/d " + packages + "\n";
                this.appendLog("Unable to install: " + patchName);
                continue;
            }
            if (!this.patches[i].startsWith("org.webosinternals.patches.") || (curr = this.patchFeed.getAppInfo(this.patches[i])) == null) continue;
            this.appendLog("Installing: " + curr.id);
            if (this.patchMgr.installPatchFromFeed(curr.file, curr.id)) {
                if (curr.version.endsWith("-0")) {
                    this.appendLog("--dummy package installed");
                } else {
                    this.appendLog("--installed");
                }
                this.deviceFeed.apps.add(curr);
                continue;
            }
            script = script + "sed -i -e /\\^'" + this.patches[i] + " aupt-1'\\$/d " + packages + "\n";
            this.appendLog("--error, installation failed");
        }
        script = script + "exit 0";
        this.doScript(script);
    }

    private void processPatches() {
        this.deviceFeed.sort(true);
        for (int i = 0; i < this.deviceFeed.apps.size(); ++i) {
            AppInfoEntry curr = this.deviceFeed.apps.get(i);
            if (curr.id.startsWith("ca.canucksoftware.patches.")) {
                String base = curr.id.replaceFirst("ca.canucksoftware.patches.", "");
                String patchName = base + ".patch";
                String path1 = this.novaCon.offlineRoot + "/usr/palm/applications/" + curr.id + "/" + patchName;
                String path2 = "/tmp/" + patchName;
                if (this.novaCon.fileExists(path1)) {
                    this.novaCon.runCmd("/bin/cp", new String[]{path1, path2}, false);
                }
                if (this.patchMgr.uninstallPatch(curr.id)) {
                    if (this.novaCon.fileExists(path2)) {
                        this.novaCon.runCmd("/bin/chmod", new String[]{"777", path2});
                        if (this.doScript(this.novaCon.offlineRoot + "/usr/bin/patch " + "-p1 --no-backup-if-mismatch --dry-run < " + path2, base + ".sh")) {
                            this.appendLog("Reapplying: " + patchName);
                            String tmpFilePath = System.getProperty("java.io.tmpdir");
                            File tmp = new File(tmpFilePath, patchName);
                            this.novaCon.receiveFile(path2, tmp, true);
                            this.patchMgr.installPatch(tmp);
                            this.appendLog("--reapplied");
                            continue;
                        }
                        this.appendLog("Cannot reapply, uninstalled: " + patchName);
                        continue;
                    }
                    this.appendLog("Cannot reapply, uninstalled: " + patchName);
                    continue;
                }
                this.appendLog("Error uninstalling: " + patchName);
                continue;
            }
            if (!curr.id.startsWith("org.webosinternals.patches.") || !this.newerWebOSVersion(curr, this.patchFeed.getAppInfo(curr.id))) continue;
            if (this.patchMgr.uninstallPatch(curr.id)) {
                curr = this.patchFeed.getAppInfo(curr.id);
                if (this.patchMgr.installPatchFromFeed(curr.file, curr.id)) {
                    if (curr.version.endsWith("-0")) {
                        this.appendLog("Installed dummy package: " + curr.id);
                        continue;
                    }
                    this.appendLog("Updated: " + curr.id);
                    continue;
                }
                this.appendLog("Error installing: " + curr.id);
                continue;
            }
            this.appendLog("Error uninstalling: " + curr.id);
        }
    }

    private boolean newerWebOSVersion(AppInfoEntry curr, AppInfoEntry onServer) {
        boolean result = false;
        if (onServer != null) {
            String[] tokens1 = curr.version.split("-");
            String[] tokens2 = onServer.version.split("-");
            if (curr.id.startsWith("org.webosinternals.patches.")) {
                result = !tokens1[0].equalsIgnoreCase(tokens2[0]);
            } else if (curr.id.startsWith("ca.canucksoftware.patches.")) {
                result = !tokens1[0].equalsIgnoreCase(this.novaCon.getWebOSVersion());
            }
        }
        return result;
    }

    private void initComponents() {
        this.jLayeredPane1 = new JLayeredPane();
        this.jLabel2 = new JLabel();
        this.jLabel1 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jTextArea1 = new JTextArea();
        this.jButton1 = new JButton();
        this.setDefaultCloseOperation(0);
        ResourceMap resourceMap = Application.getInstance(WebOSQuickInstallApp.class).getContext().getResourceMap(UpdateTransition.class);
        this.setTitle(resourceMap.getString("title", new Object[0]));
        this.setBackground(resourceMap.getColor("transfer.background"));
        this.setForeground(resourceMap.getColor("transfer.foreground"));
        this.setIconImage(null);
        this.setModal(true);
        this.setName("transfer");
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            public void windowActivated(WindowEvent evt) {
                UpdateTransition.this.formWindowActivated(evt);
            }

            public void windowClosed(WindowEvent evt) {
                UpdateTransition.this.formWindowClosed(evt);
            }

            public void windowOpened(WindowEvent evt) {
                UpdateTransition.this.formWindowOpened(evt);
            }
        });
        this.jLayeredPane1.setBackground(resourceMap.getColor("jLayeredPane1.background"));
        this.jLayeredPane1.setForeground(resourceMap.getColor("jLayeredPane1.foreground"));
        this.jLayeredPane1.setName("jLayeredPane1");
        this.jLayeredPane1.setOpaque(true);
        this.jLabel2.setText(resourceMap.getString("jLabel2.text", new Object[0]));
        this.jLabel2.setName("jLabel2");
        this.jLabel2.setBounds(20, 80, 34, 14);
        this.jLayeredPane1.add((Component)this.jLabel2, JLayeredPane.DEFAULT_LAYER);
        this.jLabel1.setFont(resourceMap.getFont("jLabel1.font"));
        this.jLabel1.setText(resourceMap.getString("jLabel1.text", new Object[0]));
        this.jLabel1.setName("jLabel1");
        this.jLabel1.setBounds(10, 10, 400, 60);
        this.jLayeredPane1.add((Component)this.jLabel1, JLayeredPane.DEFAULT_LAYER);
        this.jScrollPane1.setName("jScrollPane1");
        this.jTextArea1.setColumns(20);
        this.jTextArea1.setEditable(false);
        this.jTextArea1.setFont(resourceMap.getFont("jTextArea1.font"));
        this.jTextArea1.setRows(5);
        this.jTextArea1.setName("jTextArea1");
        this.jScrollPane1.setViewportView(this.jTextArea1);
        this.jScrollPane1.setBounds(20, 100, 380, 100);
        this.jLayeredPane1.add((Component)this.jScrollPane1, JLayeredPane.DEFAULT_LAYER);
        this.jButton1.setText(resourceMap.getString("jButton1.text", new Object[0]));
        this.jButton1.setEnabled(false);
        this.jButton1.setName("jButton1");
        this.jButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                UpdateTransition.this.jButton1ActionPerformed(evt);
            }
        });
        this.jButton1.setBounds(140, 210, 130, 30);
        this.jLayeredPane1.add((Component)this.jButton1, JLayeredPane.DEFAULT_LAYER);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLayeredPane1, -1, 419, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLayeredPane1, -2, 251, -2));
        this.pack();
    }

    private void formWindowOpened(WindowEvent evt) {
    }

    private void formWindowActivated(WindowEvent evt) {
    }

    private void formWindowClosed(WindowEvent evt) {
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        this.dispose();
        JFrame mainFrame = WebOSQuickInstallApp.getApplication().getMainFrame();
        Tweaks tweaks = new Tweaks(mainFrame);
        tweaks.setLocationRelativeTo(mainFrame);
        if (!tweaks.dontOpen) {
            WebOSQuickInstallApp.getApplication().show(tweaks);
        }
    }

    class DoTransition
    extends TimerTask {
        DoTransition() {
        }

        public void run() {
            UpdateTransition.this.t.cancel();
            if (UpdateTransition.this.firstRun) {
                if (UpdateTransition.this.patches == null) {
                    UpdateTransition.this.processPatches();
                } else {
                    UpdateTransition.this.restorePatches();
                }
            }
            UpdateTransition.this.jButton1.setText("Done");
            UpdateTransition.this.jButton1.setEnabled(true);
        }
    }
}

