/*
 * Decompiled with CFR 0.152.
 */
package ca.canucksoftware;

import java.awt.Desktop;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.util.prefs.Preferences;
import javax.swing.JOptionPane;

public class Versioning {
    public static final double CURR_VERSION = 3.14;
    private static final String VERSION_CHECK = "http://images.precentral.net/sites/precentral.net/files/webos-homebrew-apps/wosqi/wosqiVersion.txt";
    private static final String WOSQI_DOWNLOAD = "http://images.precentral.net/sites/precentral.net/files/webos-homebrew-apps/wosqi/WebOSQuickInstall.jar";

    public static boolean isTimeToCheck() {
        boolean result = false;
        long checkFreq = Preferences.userRoot().getInt("checkTime", 7);
        long prev = Preferences.userRoot().getLong("lastCheck", System.currentTimeMillis() - checkFreq * 86400000L);
        if (checkFreq != -1L) {
            result = System.currentTimeMillis() - prev >= checkFreq * 86400000L;
        }
        return result;
    }

    public static void checkForUpdates() {
        Preferences.userRoot().putLong("lastCheck", System.currentTimeMillis());
        String foundVer = Versioning.isUpdateAvailable();
        if (foundVer != null && JOptionPane.showConfirmDialog(null, "WebOS Quick Install v" + foundVer + " is now available. Would you like to download it now?", "Update Available", 0) == 0) {
            Versioning.launchDownload();
        }
    }

    private static String isUpdateAvailable() {
        String result = null;
        URLConnection urlCon = null;
        try {
            urlCon = new URL(VERSION_CHECK).openConnection();
            urlCon.setRequestProperty("Content-Type", "text/plain");
            BufferedInputStream bis = new BufferedInputStream(urlCon.getInputStream());
            BufferedReader br = new BufferedReader(new InputStreamReader(bis));
            String line = br.readLine();
            if (line != null && Double.parseDouble(line) > 3.14) {
                result = line;
            }
            br.close();
        }
        catch (Exception e) {
            result = null;
        }
        return result;
    }

    public static void launchDownload() {
        try {
            Desktop.getDesktop().browse(new URI(WOSQI_DOWNLOAD));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

