/*
 * Decompiled with CFR 0.152.
 */
package ca.canucksoftware;

import ca.canucksoftware.DoctorSelector;
import ca.canucksoftware.Download;
import ca.canucksoftware.MainView;
import java.awt.Frame;
import java.awt.Window;
import java.io.File;
import java.util.jar.JarFile;
import javax.swing.JOptionPane;
import org.jdesktop.application.Application;
import org.jdesktop.application.SingleFrameApplication;

public class WebOSQuickInstallApp
extends SingleFrameApplication {
    protected void startup() {
        String dir = WebOSQuickInstallApp.getDir();
        boolean b = new File(dir, "webOSDoctor.jar").exists() ? true : this.theDoctorIsIn();
        if (!b) {
            if (JOptionPane.showConfirmDialog(null, "<html><body width=\"400px\">For WebOS Quick Install to run correctly, it is required to download webOSDoctor (approx 220MB). Would you like to download it now?", "Download Required", 0, 2) == 0) {
                DoctorSelector docSel = new DoctorSelector(this.getMainFrame());
                docSel.setLocationRelativeTo(this.getMainFrame());
                this.show(docSel);
                String url = docSel.selectedURL;
                if (url == null) {
                    System.exit(0);
                }
                Download dl = new Download((Frame)this.getMainFrame(), new String[]{url}, new File[]{new File(dir, "webOSDoctor.jar")}, new int[]{202910});
                dl.setLocationRelativeTo(this.getMainFrame());
                this.show(dl);
                if (dl.cancel) {
                    System.exit(0);
                }
                try {
                    if (System.getProperty("os.name").toUpperCase().contains("WINDOWS")) {
                        Runtime.getRuntime().exec("java -jar " + WebOSQuickInstallApp.getFilename(new File(Application.getInstance().getClass().getProtectionDomain().getCodeSource().getLocation().toURI())));
                    } else {
                        JOptionPane.showMessageDialog(null, "<html><body width=\"350px\">webOSDoctor downloaded and setup.  Please restart WebOS Quick Install to finish installation.");
                    }
                    System.exit(0);
                }
                catch (Exception e) {
                    System.exit(0);
                }
            } else {
                System.exit(0);
            }
        }
        if (b) {
            MainView app = new MainView(this);
            app.getFrame().setResizable(false);
            app.getFrame().setSize(650, 400);
            app.getFrame().setVisible(true);
            app.mainPanel.requestFocus();
            this.show(app);
        }
    }

    private boolean theDoctorIsIn() {
        boolean found = false;
        File dir = new File(WebOSQuickInstallApp.getDir());
        File[] files = dir.listFiles();
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                if (!files[i].getName().endsWith(".jar")) continue;
                try {
                    JarFile jar = new JarFile(files[i]);
                    if (jar.getEntry("com/palm/novacom/Novacom.class") != null) {
                        found = true;
                        jar.close();
                        files[i].renameTo(new File(dir, "webOSDoctor.jar"));
                        if (System.getProperty("os.name").toUpperCase().contains("WINDOWS")) {
                            Runtime.getRuntime().exec("java -jar " + files[i].getCanonicalPath());
                        } else {
                            JOptionPane.showMessageDialog(null, "<html><body width=\"350px\">webOSDoctor detected and setup.  Please restart WebOS Quick Install to finish installation.");
                        }
                        System.exit(0);
                        continue;
                    }
                    jar.close();
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        return found;
    }

    public static String getDir() {
        String s;
        File f2;
        try {
            File f1 = new File(Application.getInstance().getClass().getProtectionDomain().getCodeSource().getLocation().toURI());
            f2 = f1.getParentFile();
        }
        catch (Exception e) {
            s = Application.getInstance().getClass().getProtectionDomain().getCodeSource().getLocation().getPath().replaceAll("%20", " ");
            f2 = new File(s).getParentFile();
        }
        try {
            s = f2.getCanonicalPath();
        }
        catch (Exception e2) {
            s = f2.getPath();
        }
        return s;
    }

    private static String getFilename(File f) {
        String s = f.getName();
        int i = s.lastIndexOf("\\");
        if (i > -1) {
            s = s.substring(i + 1, s.length());
        } else {
            i = s.lastIndexOf("/");
            if (i > -1) {
                s = s.substring(i + 1, s.length());
            }
        }
        return s;
    }

    protected void configureWindow(Window root) {
    }

    public static WebOSQuickInstallApp getApplication() {
        return Application.getInstance(WebOSQuickInstallApp.class);
    }

    public static void main(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            if (args[i] == null) continue;
            String dir = "Install";
            try {
                File oldF = new File(args[i]);
                if (!oldF.getName().toLowerCase().endsWith("ipk")) continue;
                File newF = new File(dir + File.separatorChar + WebOSQuickInstallApp.getFilename(oldF));
                MainView.copyFile(oldF, newF);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        WebOSQuickInstallApp.launch(WebOSQuickInstallApp.class, args);
    }
}

