/*
 * Decompiled with CFR 0.152.
 */
package ca.canucksoftware;

import com.twicom.qdparser.Element;
import com.twicom.qdparser.TaggedElement;
import com.twicom.qdparser.XMLReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import javax.swing.JOptionPane;

public class XMLHandler {
    private TaggedElement root;
    private XMLReader document;
    private File xmlFile;

    public XMLHandler(String path) {
        this(new File(path));
    }

    public XMLHandler(File xml) {
        this.xmlFile = xml;
        try {
            FileReader fstream = new FileReader(this.xmlFile);
            this.document = new XMLReader("", fstream);
            this.root = this.document.parse();
            fstream.close();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "ERROR: Unable to read xml file.\n\n" + e.getMessage());
        }
    }

    public TaggedElement getRoot() {
        return this.root;
    }

    public String getContent(Element e) {
        String s = e.toString();
        s = s.substring(s.indexOf(">") + 1, s.lastIndexOf("<"));
        return s;
    }

    public TaggedElement setContent(TaggedElement parent, TaggedElement ele, String content) {
        int i = parent.findIndex(ele.getName());
        Element newEle = Element.newElement("<" + ele.getTag() + ">" + content + "</" + ele.getTag() + ">");
        parent.remove(ele);
        parent.add(i, newEle);
        return (TaggedElement)newEle;
    }

    public void updateFile() {
        try {
            FileWriter fstream = new FileWriter(this.xmlFile);
            BufferedWriter out = new BufferedWriter(fstream);
            out.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            out.newLine();
            out.write(this.root.toString());
            out.flush();
            out.close();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "ERROR: Unable to write to xml file.");
        }
    }

    public File getFile() {
        return this.xmlFile;
    }

    public static XMLHandler createNewXML(String file) {
        return XMLHandler.createNewXML(file, "data");
    }

    public static XMLHandler createNewXML(File f) {
        return XMLHandler.createNewXML(f, "data");
    }

    public static XMLHandler createNewXML(String file, String rootTag) {
        return XMLHandler.createNewXML(new File(file), rootTag);
    }

    public static XMLHandler createNewXML(File f, String rootTag) {
        XMLHandler result = null;
        try {
            if (f.exists()) {
                f.delete();
            }
            FileWriter fstream = new FileWriter(f);
            BufferedWriter out = new BufferedWriter(fstream);
            out.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            out.newLine();
            out.write("<" + rootTag + ">");
            out.newLine();
            out.write("</" + rootTag + ">");
            out.newLine();
            out.flush();
            out.close();
            result = new XMLHandler(f);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "ERROR: Unable to write to xml file.");
        }
        return result;
    }
}

