/*
 * Decompiled with CFR 0.152.
 */
package com.twicom.qdparser;

import com.twicom.qdparser.DocHandler;
import com.twicom.qdparser.XMLParseException;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Stack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QDParser {
    private static final int TEXT = 1;
    private static final int ENTITY = 2;
    private static final int OPEN_TAG = 3;
    private static final int CLOSE_TAG = 4;
    private static final int START_TAG = 5;
    private static final int ATTRIBUTE_LVALUE = 6;
    private static final int ATTRIBUTE_EQUAL = 9;
    private static final int ATTRIBUTE_RVALUE = 10;
    private static final int QUOTE = 7;
    private static final int IN_TAG = 8;
    private static final int SINGLE_TAG = 12;
    private static final int COMMENT = 13;
    private static final int IGNORE = 14;
    private static final int PRE = 15;
    private static final int CDATA = 16;
    private static final int OPEN_INSTRUCTION = 17;

    private static int popMode(Stack<Integer> st) {
        if (!st.empty()) {
            return st.pop();
        }
        return 15;
    }

    public static void parse(DocHandler doc, Reader r) throws XMLParseException, IOException {
        Stack<Integer> st = new Stack<Integer>();
        int depth = 0;
        int mode = 15;
        int c = 0;
        int quotec = 34;
        depth = 0;
        StringBuffer sb = new StringBuffer();
        StringBuffer etag = new StringBuffer();
        String nameSpace = null;
        String tagName = null;
        String lvalue = null;
        String rvalue = null;
        Map<String, String> attrs = null;
        doc.startDocument();
        int line = 1;
        int col = 0;
        boolean eol = false;
        while ((c = r.read()) != -1) {
            if (c == 10 && eol) {
                eol = false;
                continue;
            }
            if (eol) {
                eol = false;
            } else if (c == 10) {
                ++line;
                col = 0;
            } else if (c == 13) {
                eol = true;
                c = 10;
                ++line;
                col = 0;
            } else {
                ++col;
            }
            if (mode == 1) {
                if (c == 60) {
                    st.push(new Integer(mode));
                    mode = 5;
                    if (sb.length() <= 0) continue;
                    doc.text(sb.toString(), line, col);
                    sb.setLength(0);
                    continue;
                }
                if (c == 38) {
                    st.push(new Integer(mode));
                    mode = 2;
                    etag.setLength(0);
                    continue;
                }
                sb.append((char)c);
                continue;
            }
            if (mode == 4) {
                if (c == 62) {
                    mode = QDParser.popMode(st);
                    tagName = sb.toString();
                    sb.setLength(0);
                    doc.endElement(nameSpace, tagName);
                    if (--depth != 0) continue;
                    doc.endDocument();
                    return;
                }
                sb.append((char)c);
                continue;
            }
            if (mode == 16) {
                if (c == 62 && sb.toString().endsWith("]]")) {
                    sb.setLength(sb.length() - 2);
                    doc.text(sb.toString(), true, line, col);
                    sb.setLength(0);
                    mode = QDParser.popMode(st);
                    continue;
                }
                sb.append((char)c);
                continue;
            }
            if (mode == 13) {
                if (c == 62 && sb.toString().endsWith("--")) {
                    sb.setLength(0);
                    mode = QDParser.popMode(st);
                    continue;
                }
                sb.append((char)c);
                continue;
            }
            if (mode == 15) {
                if (c != 60) continue;
                mode = 1;
                st.push(new Integer(mode));
                mode = 5;
                continue;
            }
            if (mode == 14) {
                if (c != 62 || (mode = QDParser.popMode(st)) != 1) continue;
                mode = 15;
                continue;
            }
            if (mode == 5) {
                mode = QDParser.popMode(st);
                if (c == 47) {
                    st.push(new Integer(mode));
                    mode = 4;
                    continue;
                }
                if (c == 63) {
                    mode = 14;
                    continue;
                }
                if (c == 33) {
                    st.push(new Integer(mode));
                    mode = 17;
                    tagName = null;
                    attrs = new Hashtable<String, String>();
                    sb.append((char)c);
                    continue;
                }
                if (c == 95 || Character.isLetter(c)) {
                    st.push(new Integer(mode));
                    mode = 3;
                    tagName = null;
                    attrs = new Hashtable();
                    sb.append((char)c);
                    continue;
                }
                QDParser.exc("Illegal character '" + (char)c + "' at start of tag name", line, col);
                continue;
            }
            if (mode == 2) {
                if (c == 59) {
                    mode = QDParser.popMode(st);
                    String cent = etag.toString();
                    etag.setLength(0);
                    if (cent.equals("lt")) {
                        sb.append('<');
                        continue;
                    }
                    if (cent.equals("gt")) {
                        sb.append('>');
                        continue;
                    }
                    if (cent.equals("amp")) {
                        sb.append('&');
                        continue;
                    }
                    if (cent.equals("quot")) {
                        sb.append('\"');
                        continue;
                    }
                    if (cent.equals("apos")) {
                        sb.append('\'');
                        continue;
                    }
                    if (cent.startsWith("#x")) {
                        sb.append((char)Integer.parseInt(cent.substring(2), 16));
                        continue;
                    }
                    if (cent.startsWith("#")) {
                        sb.append((char)Integer.parseInt(cent.substring(1)));
                        continue;
                    }
                    sb.append('&');
                    sb.append(cent);
                    sb.append(';');
                    continue;
                }
                etag.append((char)c);
                continue;
            }
            if (mode == 12) {
                if (tagName == null) {
                    tagName = sb.toString();
                }
                if (c != 62) {
                    QDParser.exc("Expected > for tag: <" + tagName + "/>", line, col);
                }
                doc.startElement(nameSpace, tagName, attrs, line, col);
                doc.endElement(nameSpace, tagName);
                if (depth == 0) {
                    doc.endDocument();
                    return;
                }
                sb.setLength(0);
                attrs = new HashMap();
                tagName = null;
                mode = QDParser.popMode(st);
                continue;
            }
            if (mode == 17) {
                if (c == 62) {
                    QDParser.exc("Missing completion at end of element for instruction '" + sb.toString() + "'", line, col);
                    continue;
                }
                if (c == 45 && sb.toString().equals("!-")) {
                    mode = 13;
                    continue;
                }
                if (c == 91 && sb.toString().equals("![CDATA")) {
                    mode = 16;
                    sb.setLength(0);
                    continue;
                }
                if (c == 69 && sb.toString().equals("!DOCTYP")) {
                    sb.setLength(0);
                    mode = 14;
                    continue;
                }
                if (Character.isWhitespace((char)c)) {
                    QDParser.exc("Whitespace not allowed in instruction name '" + sb.toString() + "'", line, col);
                    continue;
                }
                if (sb.length() > 9) {
                    QDParser.exc("Instruction name too long in '" + sb.toString() + "'", line, col);
                }
                if (c == 45 || c == 91 || Character.isLetter(c)) {
                    sb.append((char)c);
                    continue;
                }
                QDParser.exc("Illegal character " + c + " in instruction name '" + sb.toString() + "'", line, col);
                continue;
            }
            if (mode == 3) {
                if (c == 62) {
                    if (tagName == null) {
                        tagName = sb.toString();
                    }
                    sb.setLength(0);
                    ++depth;
                    doc.startElement(nameSpace, tagName, attrs, line, col);
                    nameSpace = null;
                    tagName = null;
                    attrs = new HashMap();
                    mode = QDParser.popMode(st);
                    continue;
                }
                if (c == 47) {
                    mode = 12;
                    continue;
                }
                if (Character.isWhitespace((char)c)) {
                    tagName = sb.toString();
                    sb.setLength(0);
                    mode = 8;
                    continue;
                }
                if (c == 58) {
                    nameSpace = sb.toString();
                    sb.setLength(0);
                    continue;
                }
                if (Character.isLetterOrDigit(c) || c == 95 || c == 45 || c == 46) {
                    sb.append((char)c);
                    continue;
                }
                QDParser.exc("Illegal character " + c + " in tag name", line, col);
                continue;
            }
            if (mode == 7) {
                if (c == quotec) {
                    rvalue = sb.toString();
                    sb.setLength(0);
                    attrs.put(lvalue, rvalue);
                    mode = 8;
                    continue;
                }
                if (" \r\n\t".indexOf(c) >= 0) {
                    sb.append(' ');
                    continue;
                }
                if (c == 38) {
                    st.push(new Integer(mode));
                    mode = 2;
                    etag.setLength(0);
                    continue;
                }
                sb.append((char)c);
                continue;
            }
            if (mode == 10) {
                if (c == 34 || c == 39) {
                    quotec = c;
                    mode = 7;
                    continue;
                }
                if (Character.isWhitespace((char)c)) continue;
                QDParser.exc("Error in attribute processing", line, col);
                continue;
            }
            if (mode == 6) {
                if (Character.isWhitespace((char)c)) {
                    lvalue = sb.toString();
                    sb.setLength(0);
                    mode = 9;
                    continue;
                }
                if (c == 61) {
                    lvalue = sb.toString();
                    sb.setLength(0);
                    mode = 10;
                    continue;
                }
                sb.append((char)c);
                continue;
            }
            if (mode == 9) {
                if (c == 61) {
                    mode = 10;
                    continue;
                }
                if (Character.isWhitespace((char)c)) continue;
                QDParser.exc("Error in attribute processing.", line, col);
                continue;
            }
            if (mode != 8) continue;
            if (c == 62) {
                mode = QDParser.popMode(st);
                doc.startElement(nameSpace, tagName, attrs, line, col);
                ++depth;
                nameSpace = null;
                tagName = null;
                attrs = new HashMap();
                continue;
            }
            if (c == 47) {
                mode = 12;
                continue;
            }
            if (Character.isWhitespace((char)c)) continue;
            mode = 6;
            sb.append((char)c);
        }
        if (mode != 15) {
            QDParser.exc("missing end tag", line, col);
        }
    }

    private static void exc(String s, int line, int col) throws XMLParseException {
        throw new XMLParseException(s + " near line " + line + ", column " + col);
    }
}

