/*
 * Decompiled with CFR 0.152.
 */
package com.twicom.qdparser;

import com.twicom.qdparser.Element;
import com.twicom.qdparser.TextElement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaggedElement
extends Element
implements Cloneable {
    String nameSpace;
    String tagName;
    String name;
    private int line;
    private int col;
    Map<String, String> attributes;
    List<Element> elements;
    private String comment;

    public TaggedElement(String tag) {
        this(null, tag);
    }

    public TaggedElement(String nameSpace, String tagName) {
        this.nameSpace = nameSpace;
        this.tagName = tagName;
        this.name = nameSpace == null ? tagName : nameSpace + ":" + tagName;
        this.attributes = null;
        this.elements = null;
        this.comment = null;
        this.col = 0;
        this.line = 0;
    }

    public TaggedElement(String tag, Object[] children) {
        this(null, tag, children);
    }

    public TaggedElement(String nameSpace, String tag, Object[] children) {
        this(nameSpace, tag);
        for (int i = 0; i < children.length; ++i) {
            Object obj = children[i];
            if (obj instanceof Element) {
                this.add((Element)obj);
                continue;
            }
            this.add(obj.toString());
        }
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        TaggedElement newElement = (TaggedElement)super.clone();
        if (this.attributes != null) {
            newElement.attributes = new HashMap<String, String>(this.attributes);
        }
        if (this.elements != null) {
            newElement.elements = new ArrayList<Element>();
            Iterator<Element> it = this.elements.iterator();
            while (it.hasNext()) {
                newElement.elements.add((Element)it.next().clone());
            }
        }
        return newElement;
    }

    public String getName() {
        return this.name;
    }

    public String getNameSpace() {
        return this.nameSpace;
    }

    public String getTag() {
        return this.tagName;
    }

    public void setAttribute(String name, String value) {
        if (this.attributes == null) {
            this.attributes = new HashMap<String, String>();
        }
        this.attributes.put(name, value);
    }

    public String getAttribute(String name) {
        return this.attributes == null ? null : this.attributes.get(name);
    }

    public String getAttribute(String name, String defaultValue) {
        String result = this.getAttribute(name);
        return result == null ? defaultValue : result;
    }

    public void delAttribute(String string) {
        if (this.hasAttributes()) {
            this.attributes.remove(string);
        }
    }

    public boolean hasAttribute(String name) {
        return this.attributes == null ? false : this.attributes.containsKey(name);
    }

    public boolean hasAttributes() {
        return this.attributes != null && !this.attributes.isEmpty();
    }

    public Map<String, String> getAttributes() {
        if (this.attributes == null) {
            this.attributes = new HashMap<String, String>();
        }
        return this.attributes;
    }

    public int elements() {
        return this.elements == null ? 0 : this.elements.size();
    }

    public boolean hasElements() {
        return this.elements() != 0;
    }

    public void clearElements() {
        if (this.elements != null) {
            this.elements.clear();
        }
    }

    public void add(Element element) {
        this.add(-1, element);
    }

    public void add(int index, Element element) {
        if (this.elements == null) {
            this.elements = new ArrayList<Element>();
        }
        if (index < 0 || index >= this.elements.size()) {
            this.elements.add(element);
        } else {
            this.elements.add(index, element);
        }
    }

    public void add(String string) {
        this.add(new TextElement(string));
    }

    public void add(int index, String string) {
        this.add(index, new TextElement(string));
    }

    public Element getChild(int i) {
        if (i < 0 || i >= this.elements()) {
            return null;
        }
        return this.elements.get(i);
    }

    public void replace(int index, Element newElement) {
        if (this.elements == null) {
            this.elements = new ArrayList<Element>();
        }
        if (index >= this.elements.size()) {
            this.elements.add(newElement);
        } else {
            this.elements.set(index, newElement);
        }
    }

    public Element remove(int index) {
        Element result = null;
        if (this.elements == null) {
            this.elements = new ArrayList<Element>();
        }
        if (index >= 0 && index < this.elements.size()) {
            result = this.elements.remove(index);
        }
        return result;
    }

    public boolean remove(Element element) {
        return this.elements.remove(element);
    }

    public TaggedElement find(String name) {
        for (int i = 0; i < this.elements.size(); ++i) {
            Element element = this.elements.get(i);
            if (!(element instanceof TaggedElement) || !((TaggedElement)element).getName().equals(name)) continue;
            return (TaggedElement)element;
        }
        return null;
    }

    public int findIndex(String name) {
        for (int i = 0; i < this.elements.size(); ++i) {
            Element element = this.elements.get(i);
            if (!(element instanceof TaggedElement) || !((TaggedElement)element).getName().equals(name)) continue;
            return i;
        }
        return -1;
    }

    public void setElements(List<Element> elements) {
        this.elements = elements;
    }

    public List<Element> getElements() {
        if (this.elements == null) {
            this.elements = new ArrayList<Element>();
        }
        return this.elements;
    }

    public Iterator<Element> iterator() {
        return this.getElements().iterator();
    }

    public void setLocation(int line, int col) {
        this.line = line;
        this.col = col;
    }

    public int getLine() {
        return this.line;
    }

    public int getCol() {
        return this.col;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public String toString() {
        return this.toString(true);
    }

    @Override
    protected StringBuffer toString(StringBuffer sb, boolean formatted, int level) {
        String nsTagName;
        if (formatted && level > 0) {
            sb.append("\r\n");
            for (int i = level; i > 0; --i) {
                sb.append("  ");
            }
        }
        String nsAttribute = null;
        if (this.nameSpace == null) {
            nsTagName = this.tagName;
        } else {
            String ns = null;
            if (this.hasAttributes()) {
                for (Map.Entry<String, String> entry : this.getAttributes().entrySet()) {
                    String key = entry.getKey();
                    if (!key.startsWith("xmlns:") || !this.nameSpace.equals(entry.getValue())) continue;
                    ns = key.substring(6);
                    break;
                }
            }
            if (ns == null) {
                ns = this.nameSpace;
                for (int i = 0; i < this.nameSpace.length(); ++i) {
                    char ch = this.nameSpace.charAt(i);
                    if (ch == '_' || Character.isLetterOrDigit(ch)) continue;
                    ns = null;
                    break;
                }
            }
            if (ns != null) {
                nsTagName = ns + ':' + this.tagName;
            } else {
                nsTagName = "nsqdp:" + this.tagName;
                nsAttribute = " xmlns:nsqdp='" + this.nameSpace + "'";
            }
        }
        sb.append("<" + nsTagName);
        if (nsAttribute != null) {
            sb.append(nsAttribute);
        }
        if (this.hasAttributes()) {
            for (Map.Entry<String, String> entry : this.getAttributes().entrySet()) {
                sb.append(' ' + entry.getKey() + '=');
                sb.append("'" + TaggedElement.quote(entry.getValue()) + "'");
            }
        }
        boolean formatThis = formatted;
        if (!this.hasElements()) {
            sb.append("/>");
        } else {
            sb.append(">");
            Iterator<Object> it = this.elements.iterator();
            while (it.hasNext()) {
                Element element = (Element)it.next();
                formatThis = element instanceof TextElement ? false : formatted;
                element.toString(sb, formatThis, level + 1);
                if (!(element instanceof TextElement) || !it.hasNext()) continue;
                sb.append("<!-- -->");
            }
            if (formatThis && level >= 0) {
                sb.append("\r\n");
                for (int i = level; i > 0; --i) {
                    sb.append("  ");
                }
            }
            sb.append("</" + nsTagName + ">");
        }
        return sb;
    }
}

