/*
 * Decompiled with CFR 0.152.
 */
package com.twicom.qdparser;

import com.twicom.qdparser.Element;

public class TextElement
extends Element
implements Cloneable {
    String string;
    Integer integer;
    private boolean cdata;

    public TextElement(String string) {
        this.setValue(string);
    }

    public TextElement(int value) {
        this.setValue(value);
    }

    public Object clone() throws CloneNotSupportedException {
        TextElement newText = (TextElement)super.clone();
        if (this.integer != null) {
            newText.integer = new Integer(this.integer);
        }
        return newText;
    }

    public void setValue(String value) {
        this.string = value;
        this.integer = null;
        this.cdata = false;
    }

    public void setValue(int value) {
        this.string = "" + value;
        this.integer = new Integer(value);
    }

    public void setCData(boolean cdata) {
        this.cdata = cdata;
    }

    public boolean getCData() {
        return this.cdata;
    }

    public boolean isNumber() {
        this.checkValue();
        return this.integer != null;
    }

    public int getInteger() {
        if (this.isNumber()) {
            return this.integer;
        }
        return 0;
    }

    private void checkValue() {
        if (this.integer == null) {
            try {
                this.integer = new Integer(this.string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    public String toString() {
        if (this.cdata) {
            return this.cdataToString(this.string).toString();
        }
        return this.string;
    }

    protected StringBuffer toString(StringBuffer sb, boolean formatted, int level) {
        if (formatted) {
            sb.append("\n");
            for (int i = level; i > 0; --i) {
                sb.append("  ");
            }
        }
        if (this.cdata) {
            sb.append(this.cdataToString(this.string));
        } else {
            sb.append(this.string);
        }
        return sb;
    }

    private StringBuffer cdataToString(String string) {
        StringBuffer sb = new StringBuffer(string);
        int index = 0;
        while (index >= 0 && index <= sb.length() && (index = sb.indexOf("]]>", index)) >= 0) {
            sb.insert(index += 3, "]]&gt;<![CDATA[");
        }
        sb.insert(0, "<![CDATA[");
        sb.append("]]>");
        return sb;
    }
}

