/*
 * Decompiled with CFR 0.152.
 */
package com.palm.nova.installer.core;

import com.palm.nova.installer.core.DeviceInfo;
import com.palm.nova.installer.core.FlasherThread;
import com.palm.nova.installer.core.IFlasherLogger;
import com.palm.nova.installer.core.ModemUtilities;
import com.palm.nova.installer.core.ScreenPainter;
import com.palm.nova.installer.core.TarInTarInstallerModel;
import com.palm.nova.installer.core.TarfileInstallerModel;
import com.palm.nova.installer.core.TokenReader;
import com.palm.nova.installer.core.stages.RamdiskLoadingStage;
import com.palm.novacom.INovacomController;
import com.palm.novacom.INovacomDevice;
import com.palm.novacom.INovacomStream;
import com.palm.novacom.NovaDeviceInfo;
import com.palm.novacom.Novacom;
import com.palm.novacom.NovacomException;
import java.io.File;
import java.io.IOException;
import java.util.Date;

public class IcssUtilities
implements IFlasherLogger {
    private INovacomDevice device = null;
    ModemUtilities modemobj = null;
    private static int ERROR = 0;
    private static int SUCCESS = 1;
    static Date date = new Date();

    private INovacomDevice getDevice(int index) throws NovacomException, IOException {
        INovacomController controller = Novacom.getController();
        NovaDeviceInfo[] devices = controller.getDeviceList();
        if (devices.length <= index) {
            return null;
        }
        return controller.connectToDevice(devices[index]);
    }

    public int checkConnection(int index) throws NovacomException, IOException {
        this.device = this.getDevice(index);
        if (this.device == null) {
            return ERROR;
        }
        return SUCCESS;
    }

    public String getSwVersion() throws NovacomException, IOException {
        this.device = this.getDevice(0);
        DeviceInfo devinfo = new DeviceInfo(this.device);
        return devinfo.getProductVersion() + " (" + devinfo.getBuildVersion() + ")";
    }

    public int modemPowerCycle() throws NovacomException, IOException {
        try {
            INovacomController controller = Novacom.getController();
            INovacomDevice device = controller.connectDefaultDevice();
            String[] args = new String[]{"cycle"};
            INovacomStream stream = device.runProgram("/usr/bin/pmmodempower", args);
            stream.close();
            Thread.sleep(5000L);
        }
        catch (Exception e) {
            return ERROR;
        }
        return SUCCESS;
    }

    public int resetDevice(int index) throws NovacomException, IOException {
        try {
            this.device = this.getDevice(0);
            INovacomStream stream = this.device.runProgram("/sbin/tellbootie", new String[]{"reboot"});
            stream.waitForReturnCode();
            stream.close();
        }
        catch (NovacomException e) {
            return ERROR;
        }
        return SUCCESS;
    }

    public int invokeRamdisk(String buildFilename, int index) throws NovacomException, IOException {
        try {
            this.device = this.getDevice(index);
            if (this.device == null) {
                return ERROR;
            }
            if (this.device.getState() == Novacom.DeviceState.BOOTLOADER) {
                // empty if block
            }
            TarfileInstallerModel baseModel = new TarfileInstallerModel(new File(buildFilename));
            if (this.device.getState() == Novacom.DeviceState.BOOTLOADER) {
                RamdiskLoadingStage ramdiskStage = new RamdiskLoadingStage(baseModel, this.device);
                ramdiskStage.run();
                ScreenPainter painter = new ScreenPainter(this.device);
                painter.drawImage(0, 0, this.getClass().getResourceAsStream("/resources/PalmIcss.png"));
            }
            this.modemobj = new ModemUtilities(this.device);
        }
        catch (NovacomException e) {
            throw new NovacomException(-1, "Ramdisk download error");
        }
        catch (IOException e2) {
            throw new NovacomException(-1, "Ramdisk download error");
        }
        return SUCCESS;
    }

    public ModemUtilities getModemUtilities() {
        return this.modemobj;
    }

    public int invokeSoftwareDownload(String buildFilename, int index) throws NovacomException, IOException {
        FlasherThread flasherThread = null;
        Thread thread = null;
        try {
            this.device = this.getDevice(index);
            if (this.device == null) {
                return ERROR;
            }
            TarInTarInstallerModel baseModel = new TarInTarInstallerModel(new File(buildFilename), "cust-castle");
            TarInTarInstallerModel custModel = new TarInTarInstallerModel(new File(buildFilename), "sprint-castle");
            flasherThread = new FlasherThread(baseModel, custModel);
            flasherThread.setMainWindow(this);
            flasherThread.doVerifyRom(true);
            flasherThread.doForceModemUpdate(true);
            flasherThread.setScreenPicture("/resources/PalmIcss.png");
            flasherThread.setDevice(this.device);
            thread = new Thread(flasherThread);
            thread.start();
            thread.join();
        }
        catch (NovacomException e) {
            throw new NovacomException(-1, "Error during download");
        }
        catch (InterruptedException e) {
            throw new NovacomException(-1, "Error during download");
        }
        return SUCCESS;
    }

    public String getHwVersion() throws NovacomException, IOException {
        INovacomController controller = Novacom.getController();
        INovacomDevice device = controller.connectDefaultDevice();
        TokenReader tokenReader = new TokenReader(device);
        if (tokenReader.isTokenPresent("PalmSN")) {
            return tokenReader.getTokenValue("PalmSN");
        }
        return "ENG";
    }

    @Override
    public void logPrint(String data) {
        date.setTime(System.currentTimeMillis());
        System.out.print("icss-print (" + date.toString() + "): " + data);
    }

    @Override
    public void logPrintln(String data) {
        date.setTime(System.currentTimeMillis());
        System.out.println("console-println (" + date.toString() + "): " + data);
    }

    @Override
    public void postFlashEvent(IFlasherLogger.FlashEvents event, Object obj) {
    }
}

